package iip.impl;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import de.iip_ecosphere.platform.services.environment.DefaultServiceImpl;
import de.iip_ecosphere.platform.services.environment.ParameterConfigurer;
import de.iip_ecosphere.platform.services.environment.ServiceKind;
import de.iip_ecosphere.platform.services.environment.YamlService;

import iip.interfaces.SimpleDataReceiver3Interface;

/**
 * IIP-Ecosphere supporting service implementation for 'Simple Data Receiver3'.
 * Generated by: EASy-Producer.
 */
public abstract class SimpleDataReceiver3Impl extends DefaultServiceImpl implements SimpleDataReceiver3Interface {

    private Map<String, ParameterConfigurer<?>> paramConfigurers = new HashMap<>();

    /**
     * Fallback constructor setting most fields to "empty" default values.
     *
     * @param kind the service kind
     */
    protected SimpleDataReceiver3Impl(ServiceKind kind) {
        super(kind);
        registerParameterConfigurers();
    }

    /**
     * Fallback constructor setting most fields to "empty" default values.
     *
     * @param serviceId the id of the service
     * @param kind the service kind
     */
    protected SimpleDataReceiver3Impl(String serviceId, ServiceKind kind) {
        super(serviceId, kind);
        registerParameterConfigurers();
    }

    /**
     * Creates a service instance from YAML information.
     *
     * @param yaml the service information as read from YAML
     */
    protected SimpleDataReceiver3Impl(YamlService yaml) {
        super(yaml);
        registerParameterConfigurers();
    }

    /**
     * Creates a service instance from a service id and a YAML artifact.
     *
     * @param serviceId the id of the service
     * @param ymlFile the YML file containing the YAML artifact with the service descriptor
     */
    protected SimpleDataReceiver3Impl(String serviceId, InputStream ymlFile) {
        super(serviceId, ymlFile);
        registerParameterConfigurers();
    }

    @Override
    public ParameterConfigurer<?> getParameterConfigurer(String paramName) {
        return paramConfigurers.get(paramName);
    }

    @Override
    public Set<String> getParameterNames() {
        return paramConfigurers.keySet();
    }

    /**
     * Registers the configurers.
     */
    protected void registerParameterConfigurers() {
    }

}
