/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.test.apps.serviceImpl;

import de.iip_ecosphere.platform.services.environment.DefaultServiceImpl;
import de.iip_ecosphere.platform.services.environment.ServiceKind;
import iip.datatypes.Rec13;
import iip.interfaces.SimpleDataReceiver3Interface;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.LocalDate;

public class SimpleReceiverMonikaImpl
extends DefaultServiceImpl
implements SimpleDataReceiver3Interface {
    public SimpleReceiverMonikaImpl() {
        super(ServiceKind.SINK_SERVICE);
    }

    public SimpleReceiverMonikaImpl(String serviceId, InputStream ymlFile) {
        super(serviceId, ymlFile);
    }

    public void processRec13(Rec13 data) {
        System.out.println("TestApp03 RECEIVED " + data.getStringField() + " " + data.getIntField());
        String fileName = System.getProperty("user.home") + "/testapp03_logs.txt";
        File file = new File(fileName);
        if (Files.notExists(Paths.get(fileName, new String[0]), new LinkOption[0])) {
            try {
                file.createNewFile();
                FileOutputStream oFile = new FileOutputStream(file, false);
                oFile.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        long timestamp = System.currentTimeMillis();
        String date = LocalDate.now().toString();
        String contentToAppend = "\nReceivered data on: " + date + ", " + String.valueOf(timestamp);
        try {
            Files.write(Paths.get(fileName, new String[0]), contentToAppend.getBytes(), StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

