/*
 * Decompiled with CFR 0.152.
 */
package iip.nodes;

import de.iip_ecosphere.platform.connectors.Connector;
import de.iip_ecosphere.platform.connectors.ConnectorFactory;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.types.ProtocolAdapter;
import de.iip_ecosphere.platform.connectors.types.TranslatingProtocolAdapter;
import de.iip_ecosphere.platform.services.environment.DataMapper;
import de.iip_ecosphere.platform.support.StringUtils;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import de.iip_ecosphere.platform.support.setup.CmdLine;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.serialization.SerializerRegistry;
import iip.datatypes.RoutingCommandImpl;
import iip.datatypes.RoutingConnInImpl;
import iip.datatypes.RoutingConnOut;
import iip.nodes.MyRoutingConnector;
import iip.serializers.AvaMqttOutputImplSerializer;
import iip.serializers.AvaMqttOutputSerializer;
import iip.serializers.MipMqttInputImplSerializer;
import iip.serializers.MipMqttInputSerializer;
import iip.serializers.MipMqttOutputImplSerializer;
import iip.serializers.MipMqttOutputSerializer;
import iip.serializers.RoutingCommandImplSerializer;
import iip.serializers.RoutingCommandSerializer;
import iip.serializers.RoutingConnInImplSerializer;
import iip.serializers.RoutingConnInSerializer;
import iip.serializers.RoutingConnOutImplSerializer;
import iip.serializers.RoutingConnOutSerializer;
import iip.serializers.RoutingTestDataImplSerializer;
import iip.serializers.RoutingTestDataSerializer;
import iip.serializers.SubmodelElementListImplSerializer;
import iip.serializers.SubmodelElementListSerializer;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import org.hamcrest.core.IsAnything;
import org.junit.Assert;
import org.junit.Test;

public class MyRoutingConnectorTest {
    private Map<Class<?>, Integer> received = new HashMap();
    private static String[] cmdArgs = new String[0];

    public MyRoutingConnectorTest() {
        SerializerRegistry.registerSerializer(AvaMqttOutputImplSerializer.class);
        SerializerRegistry.registerSerializer(AvaMqttOutputSerializer.class);
        SerializerRegistry.registerSerializer(MipMqttInputImplSerializer.class);
        SerializerRegistry.registerSerializer(MipMqttInputSerializer.class);
        SerializerRegistry.registerSerializer(MipMqttOutputImplSerializer.class);
        SerializerRegistry.registerSerializer(MipMqttOutputSerializer.class);
        SerializerRegistry.registerSerializer(RoutingCommandImplSerializer.class);
        SerializerRegistry.registerSerializer(RoutingCommandSerializer.class);
        SerializerRegistry.registerSerializer(RoutingConnInImplSerializer.class);
        SerializerRegistry.registerSerializer(RoutingConnInSerializer.class);
        SerializerRegistry.registerSerializer(RoutingConnOutImplSerializer.class);
        SerializerRegistry.registerSerializer(RoutingConnOutSerializer.class);
        SerializerRegistry.registerSerializer(RoutingTestDataImplSerializer.class);
        SerializerRegistry.registerSerializer(RoutingTestDataSerializer.class);
        SerializerRegistry.registerSerializer(SubmodelElementListImplSerializer.class);
        SerializerRegistry.registerSerializer(SubmodelElementListSerializer.class);
    }

    protected void testConnector(ConnectorParameter params, ReceptionCallback<RoutingConnOut> callback) throws IOException {
        ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)ActiveAasBase.NotificationMode.NONE);
        Connector conn = ConnectorFactory.createConnector((String)"de.iip_ecosphere.platform.test.apps.serviceImpl.routingTest.ConnectorImpl", () -> params, (ProtocolAdapter[])new TranslatingProtocolAdapter[]{MyRoutingConnector.createConnectorAdapter()});
        conn.connect(params);
        conn.setReceptionCallback(callback);
        conn.request(true);
        conn.notificationsChanged(false);
        int samplingTime = CmdLine.getIntArg((String[])cmdArgs, (String)"iip.test.samplingTime", (int)10000);
        System.out.println("Waiting for sampling... " + samplingTime + " ms until auto-stop");
        TimeUtils.sleep((int)samplingTime);
        System.out.println("Disconnecting...");
        conn.disconnect();
    }

    protected ConnectorParameter createConnectorParameter() {
        return MyRoutingConnector.createConnectorParameter();
    }

    private void incrementReceived(Class<?> type) {
        if (this.received.containsKey(type)) {
            this.received.put(type, this.received.get(type) + 1);
        } else {
            this.received.put(type, 1);
        }
    }

    protected Predicate<RoutingConnOut> getAssertPredicateRoutingConnOut() {
        return d -> true;
    }

    protected Predicate<Map<Class<?>, Integer>> createReceivedCounterAssertPredicate() {
        return m -> true;
    }

    protected void printReceivedData(Object data) {
        System.out.println(data);
    }

    protected int getInitialPeriod() {
        return 500;
    }

    @Test
    public void testConnector() throws IOException {
        MyRoutingConnectorTest test = new MyRoutingConnectorTest();
        final AtomicInteger counter = new AtomicInteger(0);
        ReceptionCallback<RoutingConnOut> callback = new ReceptionCallback<RoutingConnOut>(){

            public void received(RoutingConnOut data) {
                counter.incrementAndGet();
                MyRoutingConnectorTest.this.printReceivedData(data);
                MyRoutingConnectorTest.this.incrementReceived(RoutingConnOut.class);
            }

            public Class<RoutingConnOut> getType() {
                return RoutingConnOut.class;
            }
        };
        test.testConnector(test.createConnectorParameter(), callback);
        Assert.assertTrue((String)"Connector does not deliver data", (counter.get() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Received counters not as expected", (boolean)this.createReceivedCounterAssertPredicate().test(Collections.unmodifiableMap(this.received)));
    }

    public static void main(String[] args) throws IOException {
        cmdArgs = args;
        MyRoutingConnectorTest test = new MyRoutingConnectorTest();
        ReceptionCallback<RoutingConnOut> callback = new ReceptionCallback<RoutingConnOut>(){

            public void received(RoutingConnOut data) {
                System.out.println(data);
            }

            public Class<RoutingConnOut> getType() {
                return RoutingConnOut.class;
            }
        };
        test.testConnector(test.createConnectorParameter(), callback);
        System.exit(0);
    }

    private class TestMatcher
    extends IsAnything<Object> {
        private Map<Class<?>, Predicate<?>> predicates;

        public TestMatcher() {
            super("myRoutingConnector matcher");
            this.predicates = new HashMap();
        }

        private <T> void addPredicate(Class<T> cls, Predicate<T> pred) {
            this.predicates.put(cls, pred);
        }

        public boolean matches(Object obj) {
            return this.test(obj);
        }

        private <T> boolean test(T obj) {
            MyRoutingConnectorTest.this.incrementReceived(obj.getClass());
            MyRoutingConnectorTest.this.printReceivedData(obj);
            Predicate<?> pred = this.predicates.get(obj.getClass());
            return null == pred ? true : pred.test(obj);
        }
    }

    public static class DataUnit
    extends DataMapper.BaseDataUnit {
        private RoutingConnInImpl routingConnIn;
        private RoutingCommandImpl routingCommand;

        public RoutingConnInImpl getRoutingConnIn() {
            return this.routingConnIn;
        }

        public void setRoutingConnIn(RoutingConnInImpl routingConnIn) {
            this.routingConnIn = routingConnIn;
        }

        public RoutingCommandImpl getRoutingCommand() {
            return this.routingCommand;
        }

        public void setRoutingCommand(RoutingCommandImpl routingCommand) {
            this.routingCommand = routingCommand;
        }

        public String toString() {
            return StringUtils.toStringShortStyle((Object)((Object)this));
        }
    }
}

