/*
 * Decompiled with CFR 0.152.
 */
package iip.nodes;

import de.iip_ecosphere.platform.services.environment.AbstractService;
import de.iip_ecosphere.platform.services.environment.MonitoringService;
import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.services.environment.metricsProvider.MetricsProvider;
import de.iip_ecosphere.platform.services.environment.spring.SpringAsyncServiceBase;
import de.iip_ecosphere.platform.services.environment.spring.Starter;
import de.iip_ecosphere.platform.services.environment.switching.ServiceBase;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.metrics.Counter;
import de.iip_ecosphere.platform.support.metrics.Timer;
import iip.datatypes.RoutingCommand;
import iip.datatypes.RoutingTestData;
import iip.interfaces.MyRoutingSourceInterface;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"iip.service.myRoutingSource"}, havingValue="true", matchIfMissing=true)
@EnableScheduling
public class MyRoutingSource
extends SpringAsyncServiceBase {
    @Value(value="${iip.service.myRoutingSource:true}")
    private String activated;
    @Autowired
    private StreamBridge streamBridge;
    private MyRoutingSourceInterface service = (MyRoutingSourceInterface)AbstractService.createInstance((String)"de.iip_ecosphere.platform.test.apps.serviceImpl.routingTest.SourceImpl", MyRoutingSourceInterface.class, (String)"myRoutingSource", (String)"deployment.yml");
    @Autowired
    private de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider metrics;
    private Counter serviceSent;
    private Counter serviceReceived;
    private Timer processingTime;
    private String appInstId = MyRoutingSource.getAppInstIdSuffix((Service)this.service, (String)"_");

    @Bean
    public Consumer<RoutingCommand> processRoutingCommand_myRoutingSource() {
        return data -> {
            de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider.increaseCounterBy((Counter)this.serviceReceived, (double)1.0);
            this.processingTime.record(() -> this.service.processRoutingCommand(data));
        };
    }

    @Bean
    public Supplier<RoutingTestData> createRoutingTestData_myRoutingSource() {
        return () -> {
            de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider.increaseCounterBy((Counter)this.serviceSent, (double)1.0);
            return this.service.produceRoutingTestData();
        };
    }

    @PostConstruct
    public void initService() {
        if (null == this.activated || "".equals(this.activated) || "true".equals(this.activated)) {
            LoggerFactory.getLogger(this.getClass()).info("Initializing service myRoutingSource: {}", (Object)this.activated);
            String sId = Starter.getServiceId((Service)this.service);
            String iId = ServiceBase.getApplicationInstanceId((String)sId);
            if (iId == null || iId.length() == 0) {
                iId = "dflt";
            }
            this.serviceSent = this.metrics.createServiceSentCounter("myRoutingSource", sId, "RoutingTestApp", iId);
            this.serviceReceived = this.metrics.createServiceReceivedCounter("myRoutingSource", sId, "RoutingTestApp", iId);
            this.processingTime = this.metrics.createServiceProcessingTimer("myRoutingSource", sId, "RoutingTestApp", iId);
            MonitoringService.setUp((Service)this.service, (MetricsProvider)this.metrics);
            Starter.mapService((Service)this.service);
            this.createReceptionCallback("data_RoutingSink_RoutingCommand_RoutingTestApp" + this.appInstId, this.processRoutingCommand_myRoutingSource(), RoutingCommand.class, "processRoutingCommand_myRoutingSource-in-0");
        }
    }
}

