package iip.nodes;

import java.util.function.Consumer;
import javax.annotation.PostConstruct;

import de.iip_ecosphere.platform.services.environment.AbstractService;
import de.iip_ecosphere.platform.services.environment.MonitoringService;
import de.iip_ecosphere.platform.services.environment.spring.SpringAsyncServiceBase;
import de.iip_ecosphere.platform.services.environment.spring.Starter;
import de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider;
import de.iip_ecosphere.platform.services.environment.switching.ServiceBase;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.metrics.Counter;
import de.iip_ecosphere.platform.support.metrics.Timer;
import de.iip_ecosphere.platform.transport.Transport;
import de.iip_ecosphere.platform.transport.spring.SerializerMessageConverter;

import iip.datatypes.RoutingCommand;
import iip.datatypes.RoutingConnOut;
import iip.datatypes.RoutingTestData;
import iip.interfaces.RoutingProcessorInterface;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

/**
 * Spring Cloud Stream service frame for net node 'RoutingProcessor'.
 * Generated by: EASy-Producer.
 */
@Component
@ConditionalOnProperty(value = "iip.service.RoutingProcessor", havingValue = "true", matchIfMissing = true)
@EnableScheduling
public class RoutingProcessor extends SpringAsyncServiceBase {

    @Value("${iip.service.RoutingProcessor:true}")
    private String activated;
    @Autowired
    private StreamBridge streamBridge;
    private RoutingProcessorInterface service;
    @Autowired
    private MetricsProvider metrics;
    private Counter serviceSent;
    private Counter serviceReceived;
    private Timer processingTime;
    private String appInstId = "";

    /**
     * Creates an instance.
     */
    public RoutingProcessor() {
        service = AbstractService.createInstance(
            "de.iip_ecosphere.platform.test.apps.serviceImpl.routingTest.ProcessorImpl", RoutingProcessorInterface.
            class, "RoutingProcessor", "deployment.yml");
        appInstId = getAppInstIdSuffix(service, "_");
    }

    /**
     * Called when data arrived that shall be processed (asynchronously).
     *
     * @return the data consumer functor
     */
    @Bean
    public Consumer<RoutingTestData> processRoutingTestData_RoutingProcessor() {
        return data -> {
            MetricsProvider.increaseCounterBy(serviceReceived, 1.0);
            processingTime.record(() -> service.processRoutingTestData(data));
        };
    }

    /**
     * Called when data arrived that shall be processed (asynchronously).
     *
     * @return the data consumer functor
     */
    @Bean
    public Consumer<RoutingConnOut> processRoutingConnOut_RoutingProcessor() {
        return data -> {
            MetricsProvider.increaseCounterBy(serviceReceived, 1.0);
            processingTime.record(() -> service.processRoutingConnOut(data));
        };
    }

    /**
     * Called when data arrived that shall be processed (asynchronously).
     *
     * @return the data consumer functor
     */
    @Bean
    public Consumer<RoutingCommand> processRoutingCommand_RoutingProcessor() {
        return data -> {
            MetricsProvider.increaseCounterBy(serviceReceived, 1.0);
            processingTime.record(() -> service.processRoutingCommand(data));
        };
    }

    /**
     * Initializes the service when feasible in Spring lifecycle.
     */
    @PostConstruct
    public void initService() {
        if (null == activated || "".equals(activated) || "true".equals(activated)) {
            LoggerFactory.getLogger(getClass())
                .info("Initializing service RoutingProcessor: {}", activated);
            String iId;
            String sId;
            sId = Starter.getServiceId(service);
            iId = ServiceBase.getApplicationInstanceId(sId);
            if (iId == null || iId.length() == 0) {
                iId = "dflt";
            }
            serviceSent = metrics.createServiceSentCounter("RoutingProcessor", sId, "RoutingTestApp", iId);
            serviceReceived = metrics.createServiceReceivedCounter("RoutingProcessor", sId, "RoutingTestApp", iId);
            processingTime = metrics.createServiceProcessingTimer("RoutingProcessor", sId, "RoutingTestApp", iId);
            MonitoringService.setUp(service, metrics);
            Starter.mapService(service);
            service.attachRoutingTestDataIngestor(data -> {
                MetricsProvider.increaseCounterBy(serviceSent, 1.0);
                SerializerMessageConverter.serializeAndSend(streamBridge, 
                    "transformRoutingTestDataRoutingTestData_ParallelRoutingProcessor3-in-0", data);
            });
            service.attachRoutingTestDataIngestor(data -> {
                MetricsProvider.increaseCounterBy(serviceSent, 1.0);
                Transport.send(c -> c.asyncSend("data_RoutingProcessor_RoutingTestData_RoutingTestApp" + appInstId,
                    data), "RoutingProcessor", "processRoutingTestData_ParallelRoutingProcessor1-in-0",
                    "processRoutingTestData_ParallelRoutingProcessor2-in-0");
            });
            createReceptionCallback("data_myRoutingConnector_RoutingConnOut_RoutingTestApp" + appInstId,
                processRoutingConnOut_RoutingProcessor(), RoutingConnOut.class, 
                "processRoutingConnOut_RoutingProcessor-in-0");
            createReceptionCallback("data_RoutingSink_RoutingCommand_RoutingTestApp" + appInstId,
                processRoutingCommand_RoutingProcessor(), RoutingCommand.class, 
                "processRoutingCommand_RoutingProcessor-in-0");
        }
    }

}
