package iip.nodes;

import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.PostConstruct;

import de.iip_ecosphere.platform.services.environment.AbstractService;
import de.iip_ecosphere.platform.services.environment.MonitoringService;
import de.iip_ecosphere.platform.services.environment.spring.SpringAsyncServiceBase;
import de.iip_ecosphere.platform.services.environment.spring.Starter;
import de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider;
import de.iip_ecosphere.platform.services.environment.switching.ServiceBase;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.metrics.Counter;
import de.iip_ecosphere.platform.support.metrics.Timer;

import iip.datatypes.RoutingCommand;
import iip.datatypes.RoutingTestData;
import iip.interfaces.ParallelRoutingProcessor3Interface;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

/**
 * Spring Cloud Stream service frame for net node 'ParallelRoutingProcessor3'.
 * Generated by: EASy-Producer.
 */
@Component
@ConditionalOnProperty(value = "iip.service.ParallelRoutingProcessor3", havingValue = "true", matchIfMissing = true)
@EnableScheduling
public class ParallelRoutingProcessor3 extends SpringAsyncServiceBase {

    @Value("${iip.service.ParallelRoutingProcessor3:true}")
    private String activated;
    @Autowired
    private StreamBridge streamBridge;
    private ParallelRoutingProcessor3Interface service;
    @Autowired
    private MetricsProvider metrics;
    private Counter serviceSent;
    private Counter serviceReceived;
    private Timer processingTime;
    private String appInstId = "";

    /**
     * Creates an instance.
     */
    public ParallelRoutingProcessor3() {
        service = AbstractService.createInstance(
            "de.iip_ecosphere.platform.test.apps.serviceImpl.routingTest.ProcessorP3Impl",
            ParallelRoutingProcessor3Interface.class, "ParallelRoutingProcessor3", "deployment.yml");
        appInstId = getAppInstIdSuffix(service, "_");
    }

    /**
     * Called when data arrived that shall be processed (asynchronously).
     *
     * @return the data consumer functor
     */
    @Bean
    public Consumer<RoutingCommand> processRoutingCommand_ParallelRoutingProcessor3() {
        return data -> {
            MetricsProvider.increaseCounterBy(serviceReceived, 1.0);
            processingTime.record(() -> service.processRoutingCommand(data));
        };
    }

    /**
     * Called when data arrived that shall be processed (synchronously).
     *
     * @return the data transformation functor
     */
    @Bean
    public Function<RoutingTestData, RoutingTestData> transformRoutingTestDataRoutingTestData_ParallelRoutingProcessor3(
        ) {
        return data -> service.transformRoutingTestData(data);
    }

    /**
     * Initializes the service when feasible in Spring lifecycle.
     */
    @PostConstruct
    public void initService() {
        if (null == activated || "".equals(activated) || "true".equals(activated)) {
            LoggerFactory.getLogger(getClass())
                .info("Initializing service ParallelRoutingProcessor3: {}", activated);
            String iId;
            String sId;
            sId = Starter.getServiceId(service);
            iId = ServiceBase.getApplicationInstanceId(sId);
            if (iId == null || iId.length() == 0) {
                iId = "dflt";
            }
            serviceSent = metrics.createServiceSentCounter("ParallelRoutingProcessor3", sId, "RoutingTestApp", iId);
            serviceReceived = metrics.createServiceReceivedCounter("ParallelRoutingProcessor3", sId, "RoutingTestApp",
                iId);
            processingTime = metrics.createServiceProcessingTimer("ParallelRoutingProcessor3", sId, "RoutingTestApp",
                iId);
            MonitoringService.setUp(service, metrics);
            Starter.mapService(service);
            createReceptionCallback("data_RoutingSink_RoutingCommand_RoutingTestApp" + appInstId,
                processRoutingCommand_ParallelRoutingProcessor3(), RoutingCommand.class, 
                "processRoutingCommand_ParallelRoutingProcessor3-in-0");
        }
    }

}
