/*
 * Decompiled with CFR 0.152.
 */
package iip.nodes;

import de.iip_ecosphere.platform.services.environment.AbstractService;
import de.iip_ecosphere.platform.services.environment.MonitoringService;
import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.services.environment.metricsProvider.MetricsProvider;
import de.iip_ecosphere.platform.services.environment.spring.SpringAsyncServiceBase;
import de.iip_ecosphere.platform.services.environment.spring.Starter;
import de.iip_ecosphere.platform.services.environment.switching.ServiceBase;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.metrics.Counter;
import de.iip_ecosphere.platform.support.metrics.Timer;
import de.iip_ecosphere.platform.transport.Transport;
import iip.datatypes.RoutingTestData;
import iip.interfaces.RoutingSinkInterface;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"iip.service.RoutingSink"}, havingValue="true", matchIfMissing=true)
@EnableScheduling
public class RoutingSink
extends SpringAsyncServiceBase {
    @Value(value="${iip.service.RoutingSink:true}")
    private String activated;
    @Autowired
    private StreamBridge streamBridge;
    private RoutingSinkInterface service = (RoutingSinkInterface)AbstractService.createInstance((String)"de.iip_ecosphere.platform.test.apps.serviceImpl.routingTest.SinkImpl", RoutingSinkInterface.class, (String)"RoutingSink", (String)"deployment.yml");
    @Autowired
    private de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider metrics;
    private Counter serviceSent;
    private Counter serviceReceived;
    private Timer processingTime;
    private String appInstId = RoutingSink.getAppInstIdSuffix((Service)this.service, (String)"_");

    @Bean
    public Consumer<RoutingTestData> receiveRoutingTestData_RoutingSink() {
        return data -> {
            de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider.increaseCounterBy((Counter)this.serviceReceived, (double)1.0);
            this.processingTime.record(() -> this.service.processRoutingTestData(data));
        };
    }

    @PostConstruct
    public void initService() {
        if (null == this.activated || "".equals(this.activated) || "true".equals(this.activated)) {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Initializing service RoutingSink: {}", (Object)this.activated);
            String sId = Starter.getServiceId((Service)this.service);
            String iId = ServiceBase.getApplicationInstanceId((String)sId);
            if (iId == null || iId.length() == 0) {
                iId = "dflt";
            }
            this.serviceSent = this.metrics.createServiceSentCounter("RoutingSink", sId, "RoutingTestApp", iId);
            this.serviceReceived = this.metrics.createServiceReceivedCounter("RoutingSink", sId, "RoutingTestApp", iId);
            this.processingTime = this.metrics.createServiceProcessingTimer("RoutingSink", sId, "RoutingTestApp", iId);
            MonitoringService.setUp((Service)this.service, (MetricsProvider)this.metrics);
            Starter.mapService((Service)this.service);
            this.service.attachRoutingCommandIngestor(data -> {
                de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider.increaseCounterBy((Counter)this.serviceSent, (double)1.0);
                Transport.send(c -> c.asyncSend("data_RoutingSink_RoutingCommand_RoutingTestApp" + this.appInstId, data), (String)"RoutingSink", (String[])new String[]{"processRoutingCommand_myRoutingConnector-in-0", "processRoutingCommand_myRoutingSource-in-0", "processRoutingCommand_ParallelRoutingProcessor1-in-0", "processRoutingCommand_ParallelRoutingProcessor2-in-0", "processRoutingCommand_RoutingProcessor-in-0"});
            });
            this.createReceptionCallback("data_ParallelRoutingProcessor1_RoutingTestData_RoutingTestApp" + this.appInstId, this.receiveRoutingTestData_RoutingSink(), RoutingTestData.class, "receiveRoutingTestData_RoutingSink-in-0");
            this.createReceptionCallback("data_ParallelRoutingProcessor2_RoutingTestData_RoutingTestApp" + this.appInstId, this.receiveRoutingTestData_RoutingSink(), RoutingTestData.class, "receiveRoutingTestData_RoutingSink-in-0");
        }
    }
}

