package iip.nodes;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;

import de.iip_ecosphere.platform.services.environment.DataMapper.BaseDataUnit;
import de.iip_ecosphere.platform.services.environment.DataMapper.BaseMappingConsumer;
import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.YamlArtifact;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.services.environment.spring.SpringAsyncServiceBase;
import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.StringUtils;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase.NotificationMode;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.transport.serialization.SerializerRegistry;

import iip.Starter;
import iip.datatypes.RoutingCommandImpl;
import iip.datatypes.RoutingTestData;
import iip.serializers.AvaMqttOutputImplSerializer;
import iip.serializers.AvaMqttOutputSerializer;
import iip.serializers.MipMqttInputImplSerializer;
import iip.serializers.MipMqttInputSerializer;
import iip.serializers.MipMqttOutputImplSerializer;
import iip.serializers.MipMqttOutputSerializer;
import iip.serializers.RoutingCommandImplSerializer;
import iip.serializers.RoutingCommandSerializer;
import iip.serializers.RoutingConnInImplSerializer;
import iip.serializers.RoutingConnInSerializer;
import iip.serializers.RoutingConnOutImplSerializer;
import iip.serializers.RoutingConnOutSerializer;
import iip.serializers.RoutingTestDataImplSerializer;
import iip.serializers.RoutingTestDataSerializer;
import iip.serializers.SubmodelElementListImplSerializer;
import iip.serializers.SubmodelElementListSerializer;

import org.hamcrest.core.IsAnything;
import org.junit.Test;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.RunWith;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.stream.binder.test.TestChannelBinderConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringRunner;
import static org.junit.Assert.assertTrue;

/**
 * Implements tests for "MyRoutingSource". The generated class is meant to be re-usable and extensible, e.g., regarding
 * the assert predicates. We provide a main method to ease startup.
 * There is no guarantee on the sequence of received data, in particular not when the service is declared to be
 * asynchronous. The test loads input data file from the system property "iip.test.dataFile",
 * "../../src/test/resources/testData-myRoutingSource.json", the default resource
 * "testData-myRoutingSource.json" or "resources/software" if you want to deploy it, e.g., in case of a mocked
 * connector. The input data file is a JSON file, one data unit per line, following a generic structure per data
 * unit. A data unit consists of one optional object entry per input type of the service under test (attribute name
 * is the type name with first character in small case) - the contents of the same structure as defined in the
 * configuration model. The structure for this service is: {@code {"routingCommand": {"cmd": m}, "$period": p,
 * "$repeats": r}}. Depending on your data type definitions in the model, individual fields may be mandatory
 * (indicated by <i>m</i>), optional (indicated by <i>o</i>) or nested fields (not indicated further).
 * "$period" is an optional generic entry that defines the delay period <i>p</i> between the actual and the
 * next data entry (if unspecified the initial value is {@link #getInitialPeriod()}. "$repeats" is the number of
 * repeats of the specifying line (0: none, positive: #repeats, negative: endless).
 * Generated by: EASy-Producer.
 */
@SpringBootTest(classes = Starter.class)
@ImportAutoConfiguration(TestChannelBinderConfiguration.class)
@TestPropertySource(properties = {
"spring.cloud.stream.poller.fixedDelay=800",
"spring.cloud.function.definition=createRoutingTestData_myRoutingSource",
"spring.cloud.stream.source=data_createRoutingTestData_myRoutingSource_RoutingTestApp",
"iip.service.myRoutingConnector=false",
"iip.service.myRoutingSource=true",
"iip.service.ParallelRoutingProcessor1=false",
"iip.service.ParallelRoutingProcessor2=false",
"iip.service.ParallelRoutingProcessor3=false",
"iip.service.RoutingProcessor=false",
"iip.service.RoutingSink=false"})
@RunWith(SpringRunner.class)
public class MyRoutingSourceTest extends SpringAsyncServiceBase {

    private TestMatcher matcher = new TestMatcher();
    private Map<Class<?>, Integer> received = new HashMap<>();
    private static String[] cmdArgs = new String[0];

    /**
     * Represents all potential inputs to the service and the JSON input format.
     */
    public static class DataUnit extends BaseDataUnit {

        private RoutingCommandImpl routingCommand;

        /**
         * Returns the value of routingCommand.
         *
         * @return the value of routingCommand, may be <b>null</b>
         */
        public RoutingCommandImpl getRoutingCommand() {
            return routingCommand;
        }

        /**
         * Changes the value of routingCommand. [required by JSON]
         *
         * @param routingCommand the new value, may be <b>null</b>
         */
        public void setRoutingCommand(RoutingCommandImpl routingCommand) {
            this.routingCommand = routingCommand;
        }

        @Override
        public String toString() {
            return StringUtils.toStringShortStyle(this);
        }

    }

    /**
     * A predicate-based matcher for spring-based output testing. Class generated here, because we do not want to include
     * the testing artifact of services.environment and hamcrest shall not be a major production dependency.
     */
    private class TestMatcher extends IsAnything<Object> {

        private Map<Class<?>, Predicate<?>> predicates = new HashMap<>();

        /**
         * Creates an instance.
         */
        public TestMatcher() {
            super("myRoutingSource matcher");
        }

        /**
         * Adds a predicate for a given type.
         *
         * @param <T> the type of data to be considered by the predicate
         * @param cls the type to add the predicate for
         * @param pred the predicate
         */
        private <T> void addPredicate(Class<T> cls, Predicate<T> pred) {
            predicates.put(cls, pred);
        }

        @Override
        public boolean matches(Object obj) {
            return test(obj);
        }

        /**
         * Does a typed test against {@link #predicates}.
         *
         * @param <T> the type of data to be considered by the test
         * @param obj the data/object to be tested
         * @return whether {@code obj} matches the condition of a registered predicate or {@code true} if none was
         * registered
         */
        private <T> boolean test(T obj) {
            incrementReceived(obj.getClass());
            printReceivedData(obj);
            @SuppressWarnings("unchecked")
            Predicate<T> pred = (Predicate<T>) predicates.get(obj.getClass());
            return null == pred ? true : pred.test(obj);
        }

    }

    /**
     * Creates an instance and registers the application serializers.
     */
    public MyRoutingSourceTest() {
        SerializerRegistry.registerSerializer(AvaMqttOutputImplSerializer.class);
        SerializerRegistry.registerSerializer(AvaMqttOutputSerializer.class);
        SerializerRegistry.registerSerializer(MipMqttInputImplSerializer.class);
        SerializerRegistry.registerSerializer(MipMqttInputSerializer.class);
        SerializerRegistry.registerSerializer(MipMqttOutputImplSerializer.class);
        SerializerRegistry.registerSerializer(MipMqttOutputSerializer.class);
        SerializerRegistry.registerSerializer(RoutingCommandImplSerializer.class);
        SerializerRegistry.registerSerializer(RoutingCommandSerializer.class);
        SerializerRegistry.registerSerializer(RoutingConnInImplSerializer.class);
        SerializerRegistry.registerSerializer(RoutingConnInSerializer.class);
        SerializerRegistry.registerSerializer(RoutingConnOutImplSerializer.class);
        SerializerRegistry.registerSerializer(RoutingConnOutSerializer.class);
        SerializerRegistry.registerSerializer(RoutingTestDataImplSerializer.class);
        SerializerRegistry.registerSerializer(RoutingTestDataSerializer.class);
        SerializerRegistry.registerSerializer(SubmodelElementListImplSerializer.class);
        SerializerRegistry.registerSerializer(SubmodelElementListSerializer.class);
    }

    /**
     * Tests the source.
     *
     * @throws IOException if setting up the source fails
     */
    public void testSource() throws IOException {
        BaseMappingConsumer<DataUnit> consumer = new BaseMappingConsumer<DataUnit>(DataUnit.class, getInitialPeriod());
        final Predicate<RoutingTestData> predRoutingTestData = getAssertPredicateRoutingTestData();
        createReceptionCallback("data_myRoutingSource_RoutingTestData_RoutingTestApp", d -> {
            incrementReceived(RoutingTestData.class);
            printReceivedData(d);
            assertTrue(predRoutingTestData.test(d));
        }, RoutingTestData.class);
        TimeUtils.sleep(5000);
        Service svc = Starter.getMappedService("myRoutingSource");
        if (null != svc) {
            try {
                LoggerFactory.getLogger(getClass())
                    .info("Service autostop (test): myRoutingSource");
                svc.setState(ServiceState.STOPPING);
            } catch (ExecutionException e) {
                LoggerFactory.getLogger(getClass())
                    .error("Stopping service myRoutingSource: {}", e.getMessage());
            }
        }
        System.exit(0);
    }

    /**
     * Increments the received counter for the given data {@code type}.
     *
     * @param type the type to increment the counter for
     */
    private void incrementReceived(Class<?> type) {
        if (received.containsKey(type)) {
            received.put(type, received.get(type) + 1);
        } else {
            received.put(type, 1);
        }
    }

    /**
     * Creates/returns a predicate asserting that the received data of type RoutingTestData as output of the testing
     * object is ok (or not). Allows for overriding the test behavior with "semantic" expectations.
     *
     * @return the predicate (default: lambda function always returning {@code true})
     */
    protected Predicate<RoutingTestData> getAssertPredicateRoutingTestData() {
        return d -> true;
    }

    /**
     * Returns the predicate to assert the counters for received data type instances.
     *
     * @return the predicate (by default, a predicate with constant value {@code true})
     */
    protected Predicate<Map<Class<?>, Integer>> createReceivedCounterAssertPredicate() {
        return m -> true;
    }

    /**
     * Prints the received data. Can be overridden.
     *
     * @param data the received data
     */
    protected void printReceivedData(Object data) {
        System.out.println(data);
    }

    /**
     * Returns the initial period.
     *
     * @return the initial period in ms, no (initial) input delay happens if the value is zero or negative
     */
    protected int getInitialPeriod() {
        return 500;
    }

    /**
     * Tests the source.
     *
     * @throws IOException shall not occur / test failure
     */
    @Test
    public void testMyRoutingSourceService() throws IOException {
        NotificationMode oldM = ActiveAasBase.setNotificationMode(NotificationMode.NONE);
        testSource();
        assertTrue("Received counters not as expected", createReceivedCounterAssertPredicate().test(Collections.
            unmodifiableMap(received)));
        ActiveAasBase.setNotificationMode(oldM);
    }

    /**
     * Starts the configured version of this service/connector as main program.
     *
     * @param args command line arguments
     *
     * @throws IOException shall not occur
     */
    public static void main(String[] args) throws IOException {
        cmdArgs = args;
        Starter.setServiceAutostart(true);
        Starter.setOnServiceAutostartAttachShutdownHook(false);
        YamlService yaml = YamlArtifact.readFromYamlSafe(ResourceLoader.getResourceAsStream("deployment.yml"))
            .getServiceSafe("myRoutingSource");
        File f = FileUtils.findFile(new File(".."), "RoutingTestApp-0.1.0-SNAPSHOT-bin.jar");
        if (null != f && null != yaml.getProcess()) {
            Starter.extractProcessArtifacts("myRoutingSource", yaml.getProcess(), f, null);
        } else {
            LoggerFactory.getLogger(MyRoutingSourceTest.class)
                .info("Service artifact {} not found in {}", "RoutingTestApp-0.1.0-SNAPSHOT-bin.jar", "..");
        }
        JUnitCore junit = new JUnitCore();
        junit.addListener(new TextListener(System.out));
        junit.run(MyRoutingSourceTest.class);
    }

}
