package iip.nodes;

import java.util.function.Supplier;
import javax.annotation.PostConstruct;

import de.iip_ecosphere.platform.services.environment.AbstractService;
import de.iip_ecosphere.platform.services.environment.MonitoringService;
import de.iip_ecosphere.platform.services.environment.spring.SpringAsyncServiceBase;
import de.iip_ecosphere.platform.services.environment.spring.Starter;
import de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider;
import de.iip_ecosphere.platform.services.environment.switching.ServiceBase;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.metrics.Counter;
import de.iip_ecosphere.platform.support.metrics.Timer;

import iip.datatypes.KRec13;
import iip.interfaces.SimpleKodexDataSourceInterface;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

/**
 * Spring Cloud Stream service frame for net node 'Simple Kodex Data Source'.
 * Generated by: EASy-Producer.
 */
@Component
@ConditionalOnProperty(value = "iip.service.SimpleKodexSource", havingValue = "true", matchIfMissing = true)
@EnableScheduling
public class SimpleKodexDataSource extends SpringAsyncServiceBase {

    @Value("${iip.service.SimpleKodexSource:true}")
    private String activated;
    @Autowired
    private StreamBridge streamBridge;
    private SimpleKodexDataSourceInterface service;
    @Autowired
    private MetricsProvider metrics;
    private Counter serviceSent;
    private Counter serviceReceived;
    private Timer processingTime;
    private String appInstId = "";

    /**
     * Creates an instance.
     */
    public SimpleKodexDataSource() {
        service = AbstractService.createInstance("de.iip_ecosphere.platform.test.apps.serviceImpl.SimpleSourceKodexImpl"
            , SimpleKodexDataSourceInterface.class, "SimpleKodexSource", "deployment.yml");
        appInstId = getAppInstIdSuffix(service, "_");
    }

    /**
     * Creates data to be ingested.
     *
     * @return the data supplier functor
     */
    @Bean
    public Supplier<KRec13> createKRec13_SimpleKodexSource() {
        return () -> {
            MetricsProvider.increaseCounterBy(serviceSent, 1.0);
            return service.produceKRec13();
        };
    }

    /**
     * Initializes the service when feasible in Spring lifecycle.
     */
    @PostConstruct
    public void initService() {
        if (null == activated || "".equals(activated) || "true".equals(activated)) {
            LoggerFactory.getLogger(getClass())
                .info("Initializing service SimpleKodexSource: {}", activated);
            String iId;
            String sId;
            sId = Starter.getServiceId(service);
            iId = ServiceBase.getApplicationInstanceId(sId);
            if (iId == null || iId.length() == 0) {
                iId = "dflt";
            }
            serviceSent = metrics.createServiceSentCounter("SimpleKodexSource", sId, "KodexMeshApp", iId);
            serviceReceived = metrics.createServiceReceivedCounter("SimpleKodexSource", sId, "KodexMeshApp", iId);
            processingTime = metrics.createServiceProcessingTimer("SimpleKodexSource", sId, "KodexMeshApp", iId);
            MonitoringService.setUp(service, metrics);
            Starter.mapService(service);
        }
    }

}
