package iip.nodes;

import java.util.function.Consumer;
import javax.annotation.PostConstruct;

import de.iip_ecosphere.platform.services.environment.AbstractService;
import de.iip_ecosphere.platform.services.environment.MonitoringService;
import de.iip_ecosphere.platform.services.environment.spring.SpringAsyncServiceBase;
import de.iip_ecosphere.platform.services.environment.spring.Starter;
import de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider;
import de.iip_ecosphere.platform.services.environment.switching.ServiceBase;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.metrics.Counter;
import de.iip_ecosphere.platform.support.metrics.Timer;

import iip.datatypes.KRec13Anon;
import iip.interfaces.KodexDataReceiverInterface;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

/**
 * Spring Cloud Stream service frame for net node 'Kodex Data Receiver'.
 * Generated by: EASy-Producer.
 */
@Component
@ConditionalOnProperty(value = "iip.service.KodexReceiver", havingValue = "true", matchIfMissing = true)
@EnableScheduling
public class KodexDataReceiver extends SpringAsyncServiceBase {

    @Value("${iip.service.KodexReceiver:true}")
    private String activated;
    @Autowired
    private StreamBridge streamBridge;
    private KodexDataReceiverInterface service;
    @Autowired
    private MetricsProvider metrics;
    private Counter serviceSent;
    private Counter serviceReceived;
    private Timer processingTime;
    private String appInstId = "";

    /**
     * Creates an instance.
     */
    public KodexDataReceiver() {
        service = AbstractService.createInstance("de.iip_ecosphere.platform.test.apps.serviceImpl.KodexReceiverImpl",
            KodexDataReceiverInterface.class, "KodexReceiver", "deployment.yml");
        appInstId = getAppInstIdSuffix(service, "_");
    }

    /**
     * Called when data arrived that shall be received (data sink).
     *
     * @return the data consumer functor
     */
    @Bean
    public Consumer<KRec13Anon> receiveKRec13Anon_KodexReceiver() {
        return data -> {
            MetricsProvider.increaseCounterBy(serviceReceived, 1.0);
            processingTime.record(() -> service.processKRec13Anon(data));
        };
    }

    /**
     * Initializes the service when feasible in Spring lifecycle.
     */
    @PostConstruct
    public void initService() {
        if (null == activated || "".equals(activated) || "true".equals(activated)) {
            LoggerFactory.getLogger(getClass())
                .info("Initializing service KodexReceiver: {}", activated);
            String iId;
            String sId;
            sId = Starter.getServiceId(service);
            iId = ServiceBase.getApplicationInstanceId(sId);
            if (iId == null || iId.length() == 0) {
                iId = "dflt";
            }
            serviceSent = metrics.createServiceSentCounter("KodexReceiver", sId, "KodexMeshApp", iId);
            serviceReceived = metrics.createServiceReceivedCounter("KodexReceiver", sId, "KodexMeshApp", iId);
            processingTime = metrics.createServiceProcessingTimer("KodexReceiver", sId, "KodexMeshApp", iId);
            MonitoringService.setUp(service, metrics);
            Starter.mapService(service);
        }
    }

}
