/*
 * Decompiled with CFR 0.152.
 */
package iip.nodes;

import de.iip_ecosphere.platform.services.environment.AbstractService;
import de.iip_ecosphere.platform.services.environment.MonitoringService;
import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.services.environment.metricsProvider.MetricsProvider;
import de.iip_ecosphere.platform.services.environment.spring.SpringAsyncServiceBase;
import de.iip_ecosphere.platform.services.environment.spring.Starter;
import de.iip_ecosphere.platform.services.environment.switching.ServiceBase;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.metrics.Counter;
import de.iip_ecosphere.platform.support.metrics.Timer;
import de.iip_ecosphere.platform.transport.Transport;
import iip.datatypes.Rec1;
import iip.interfaces.SimpleDataReceiverInterface;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.stream.function.StreamBridge;
import org.springframework.context.annotation.Bean;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"iip.service.SimpleReceiver"}, havingValue="true", matchIfMissing=true)
@EnableScheduling
public class SimpleDataReceiver
extends SpringAsyncServiceBase {
    @Value(value="${iip.service.SimpleReceiver:true}")
    private String activated;
    @Autowired
    private StreamBridge streamBridge;
    private SimpleDataReceiverInterface service = (SimpleDataReceiverInterface)AbstractService.createInstance((String)"de.iip_ecosphere.platform.test.apps.serviceImpl.SimpleReceiverImpl", SimpleDataReceiverInterface.class, (String)"SimpleReceiver", (String)"deployment.yml");
    @Autowired
    private de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider metrics;
    private Counter serviceSent;
    private Counter serviceReceived;
    private Timer processingTime;
    private String appInstId = SimpleDataReceiver.getAppInstIdSuffix((Service)this.service, (String)"_");

    @Bean
    public Consumer<Rec1> receiveRec1_SimpleReceiver() {
        return data -> {
            de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider.increaseCounterBy((Counter)this.serviceReceived, (double)1.0);
            this.processingTime.record(() -> this.service.processRec1(data));
        };
    }

    @PostConstruct
    public void initService() {
        if (null == this.activated || "".equals(this.activated) || "true".equals(this.activated)) {
            LoggerFactory.getLogger(this.getClass()).info("Initializing service SimpleReceiver: {}", (Object)this.activated);
            String sId = Starter.getServiceId((Service)this.service);
            String iId = ServiceBase.getApplicationInstanceId((String)sId);
            if (iId == null || iId.length() == 0) {
                iId = "dflt";
            }
            this.serviceSent = this.metrics.createServiceSentCounter("SimpleReceiver", sId, "SimpleMeshApp", iId);
            this.serviceReceived = this.metrics.createServiceReceivedCounter("SimpleReceiver", sId, "SimpleMeshApp", iId);
            this.processingTime = this.metrics.createServiceProcessingTimer("SimpleReceiver", sId, "SimpleMeshApp", iId);
            MonitoringService.setUp((Service)this.service, (MetricsProvider)this.metrics);
            Starter.mapService((Service)this.service);
            this.service.attachFeedbackIngestor(data -> {
                de.iip_ecosphere.platform.services.environment.spring.metricsProvider.MetricsProvider.increaseCounterBy((Counter)this.serviceSent, (double)1.0);
                Transport.send(c -> c.asyncSend("data_SimpleReceiver_Feedback_SimpleMeshApp" + this.appInstId, data), (String)"SimpleReceiver", (String[])new String[]{"processFeedback_SimpleSource-in-0"});
            });
            this.createReceptionCallback("data_SimpleSource_Rec1_SimpleMeshApp" + this.appInstId, this.receiveRec1_SimpleReceiver(), Rec1.class, "receiveRec1_SimpleReceiver-in-0");
        }
    }
}

