/*
 * Decompiled with CFR 0.152.
 */
package iip.nodes;

import de.iip_ecosphere.platform.services.environment.DataMapper;
import de.iip_ecosphere.platform.services.environment.ProcessSpec;
import de.iip_ecosphere.platform.services.environment.Service;
import de.iip_ecosphere.platform.services.environment.ServiceState;
import de.iip_ecosphere.platform.services.environment.YamlArtifact;
import de.iip_ecosphere.platform.services.environment.YamlService;
import de.iip_ecosphere.platform.services.environment.spring.SpringAsyncServiceBase;
import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.StringUtils;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import de.iip_ecosphere.platform.transport.serialization.SerializerRegistry;
import iip.Starter;
import iip.datatypes.Rec13;
import iip.serializers.AvaMqttOutputImplSerializer;
import iip.serializers.AvaMqttOutputSerializer;
import iip.serializers.MipMqttInputImplSerializer;
import iip.serializers.MipMqttInputSerializer;
import iip.serializers.MipMqttOutputImplSerializer;
import iip.serializers.MipMqttOutputSerializer;
import iip.serializers.Rec13ImplSerializer;
import iip.serializers.Rec13Serializer;
import iip.serializers.SubmodelElementListImplSerializer;
import iip.serializers.SubmodelElementListSerializer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import org.hamcrest.core.IsAnything;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.TextListener;
import org.junit.runner.JUnitCore;
import org.junit.runner.RunWith;
import org.junit.runner.notification.RunListener;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.stream.binder.test.TestChannelBinderConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringRunner;

@SpringBootTest(classes={Starter.class})
@ImportAutoConfiguration(value={TestChannelBinderConfiguration.class})
@TestPropertySource(properties={"spring.cloud.stream.poller.fixedDelay=800", "spring.cloud.function.definition=createRec13_SimpleSource3", "spring.cloud.stream.source=data_createRec13_SimpleSource3_SimpleMeshApp3", "iip.service.SimpleReceiver3=false", "iip.service.SimpleSource3=true", "iip.service.SimpleTransformer3=false"})
@RunWith(value=SpringRunner.class)
public class SimpleDataSource3Test
extends SpringAsyncServiceBase {
    private TestMatcher matcher = new TestMatcher();
    private Map<Class<?>, Integer> received = new HashMap();
    private static String[] cmdArgs = new String[0];

    public SimpleDataSource3Test() {
        SerializerRegistry.registerSerializer(AvaMqttOutputImplSerializer.class);
        SerializerRegistry.registerSerializer(AvaMqttOutputSerializer.class);
        SerializerRegistry.registerSerializer(MipMqttInputImplSerializer.class);
        SerializerRegistry.registerSerializer(MipMqttInputSerializer.class);
        SerializerRegistry.registerSerializer(MipMqttOutputImplSerializer.class);
        SerializerRegistry.registerSerializer(MipMqttOutputSerializer.class);
        SerializerRegistry.registerSerializer(Rec13ImplSerializer.class);
        SerializerRegistry.registerSerializer(Rec13Serializer.class);
        SerializerRegistry.registerSerializer(SubmodelElementListImplSerializer.class);
        SerializerRegistry.registerSerializer(SubmodelElementListSerializer.class);
    }

    public void testSource() throws IOException {
        DataMapper.BaseMappingConsumer consumer = new DataMapper.BaseMappingConsumer(DataUnit.class, this.getInitialPeriod());
        Predicate<Rec13> predRec13 = this.getAssertPredicateRec13();
        this.createReceptionCallback("data_SimpleSource3_Rec13_SimpleMeshApp3", d -> {
            this.incrementReceived(Rec13.class);
            this.printReceivedData(d);
            Assert.assertTrue((boolean)predRec13.test((Rec13)d));
        }, Rec13.class);
        TimeUtils.sleep((int)5000);
        Service svc = Starter.getMappedService((String)"SimpleSource3");
        if (null != svc) {
            try {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).info("Service autostop (test): SimpleSource3");
                svc.setState(ServiceState.STOPPING);
            }
            catch (ExecutionException e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Stopping service SimpleSource3: {}", (Object)e.getMessage());
            }
        }
        System.exit(0);
    }

    private void incrementReceived(Class<?> type) {
        if (this.received.containsKey(type)) {
            this.received.put(type, this.received.get(type) + 1);
        } else {
            this.received.put(type, 1);
        }
    }

    protected Predicate<Rec13> getAssertPredicateRec13() {
        return d -> true;
    }

    protected Predicate<Map<Class<?>, Integer>> createReceivedCounterAssertPredicate() {
        return m -> true;
    }

    protected void printReceivedData(Object data) {
        System.out.println(data);
    }

    protected int getInitialPeriod() {
        return 500;
    }

    @Test
    public void testSimpleSource3Service() throws IOException {
        ActiveAasBase.NotificationMode oldM = ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)ActiveAasBase.NotificationMode.NONE);
        this.testSource();
        Assert.assertTrue((String)"Received counters not as expected", (boolean)this.createReceivedCounterAssertPredicate().test(Collections.unmodifiableMap(this.received)));
        ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)oldM);
    }

    public static void main(String[] args) throws IOException {
        cmdArgs = args;
        Starter.setServiceAutostart((boolean)true);
        Starter.setOnServiceAutostartAttachShutdownHook((boolean)false);
        YamlService yaml = YamlArtifact.readFromYamlSafe((InputStream)ResourceLoader.getResourceAsStream((String)"deployment.yml", (ResourceResolver[])new ResourceResolver[0])).getServiceSafe("SimpleSource3");
        File f = FileUtils.findFile((File)new File(".."), (String)"SimpleMeshTestingApp3-0.1.0-SNAPSHOT-bin.jar");
        if (null != f && null != yaml.getProcess()) {
            Starter.extractProcessArtifacts((String)"SimpleSource3", (ProcessSpec)yaml.getProcess(), (File)f, null);
        } else {
            LoggerFactory.getLogger(SimpleDataSource3Test.class).info("Service artifact {} not found in {}", (Object)"SimpleMeshTestingApp3-0.1.0-SNAPSHOT-bin.jar", (Object)"..");
        }
        JUnitCore junit = new JUnitCore();
        junit.addListener((RunListener)new TextListener(System.out));
        junit.run(new Class[]{SimpleDataSource3Test.class});
    }

    private class TestMatcher
    extends IsAnything<Object> {
        private Map<Class<?>, Predicate<?>> predicates;

        public TestMatcher() {
            super("SimpleSource3 matcher");
            this.predicates = new HashMap();
        }

        private <T> void addPredicate(Class<T> cls, Predicate<T> pred) {
            this.predicates.put(cls, pred);
        }

        public boolean matches(Object obj) {
            return this.test(obj);
        }

        private <T> boolean test(T obj) {
            SimpleDataSource3Test.this.incrementReceived(obj.getClass());
            SimpleDataSource3Test.this.printReceivedData(obj);
            Predicate<?> pred = this.predicates.get(obj.getClass());
            return null == pred ? true : pred.test(obj);
        }
    }

    public static class DataUnit
    extends DataMapper.BaseDataUnit {
        public String toString() {
            return StringUtils.toStringShortStyle((Object)((Object)this));
        }
    }
}

