/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.maven;

import de.iip_ecosphere.platform.support.NetUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public class BasicProcessSpec {
    @Parameter(required=true)
    private String description;
    @Parameter(required=true)
    private String cmd;
    @Parameter(required=false, defaultValue="false")
    private boolean cmdAsScript;
    @Parameter(required=false)
    private List<String> args;
    @Parameter(required=false, defaultValue="")
    private File home;
    @Parameter(required=false)
    private List<PortSpec> ports;
    @Parameter(required=false, defaultValue="false")
    private boolean errToIn;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCmd() {
        return this.cmd;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    public boolean isCmdAsScript() {
        return this.cmdAsScript;
    }

    public void setCmdAsScript(boolean cmdAsScript) {
        this.cmdAsScript = cmdAsScript;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public void setArgs(List<String> args) {
        this.args = args;
    }

    public File getHome() {
        return this.home;
    }

    public void setHome(File home) {
        this.home = home;
    }

    public boolean isErrToIn() {
        return this.errToIn;
    }

    public void setErrToIn(boolean errToIn) {
        this.errToIn = errToIn;
    }

    void allocatePorts(MavenProject project, Log log) {
        if (null != this.ports) {
            for (PortSpec p : this.ports) {
                p.allocatedPort = p.port;
                if (p.allocatedPort <= 0) {
                    p.allocatedPort = NetUtils.getEphemeralPort();
                }
                if (p.property != null && p.property.length() > 0) {
                    project.getProperties().setProperty(p.property, String.valueOf(p.allocatedPort));
                    log.info((CharSequence)("Assigned " + p.property + "=" + p.allocatedPort));
                    continue;
                }
                log.info((CharSequence)("Allocated port " + p.allocatedPort));
            }
        }
    }

    List<String> extrapolateArgs() {
        return this.extrapolateArgs(this.args);
    }

    List<String> extrapolateArgs(List<String> args) {
        ArrayList<String> result = null;
        if (null != args) {
            result = new ArrayList<String>();
            for (String a : args) {
                if (null != this.ports) {
                    for (PortSpec p : this.ports) {
                        if (p.property == null || p.property.length() <= 0) continue;
                        a = a.replace("${" + p.property + "}", String.valueOf(p.allocatedPort));
                    }
                }
                result.add(a);
            }
        }
        return result;
    }

    public static class PortSpec {
        @Parameter(required=false, defaultValue="-1")
        private int port;
        @Parameter(required=false, defaultValue="")
        private String property;
        private int allocatedPort;
    }
}

