/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.maven;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

public class DependencyResolver {
    private static final ArtifactHandler JAR_HANDLER = new DefaultArtifactHandler("jar");
    private Caller caller;
    private Set<org.apache.maven.artifact.Artifact> done = new HashSet<org.apache.maven.artifact.Artifact>();

    public DependencyResolver(Caller caller) {
        this.caller = caller;
    }

    public org.apache.maven.artifact.Artifact resolve(org.apache.maven.artifact.Artifact artifact) {
        org.apache.maven.artifact.DefaultArtifact result = null;
        try {
            Artifact art;
            ArtifactRequest request = new ArtifactRequest();
            request.setArtifact((Artifact)this.createAetherArtifact(artifact));
            request.setRepositories(this.caller.getRemoteRepos());
            ArtifactResult aetherResult = this.caller.getRepoSystem().resolveArtifact(this.caller.getRepoSession(), request);
            if (aetherResult.isResolved() && (art = aetherResult.getArtifact()).getFile() != null) {
                result = new org.apache.maven.artifact.DefaultArtifact(art.getGroupId(), art.getArtifactId(), art.getVersion(), artifact.getScope(), art.getExtension(), art.getClassifier(), JAR_HANDLER);
                result.setFile(art.getFile());
            }
        }
        catch (ArtifactResolutionException e) {
            this.caller.getLog().warn((CharSequence)("Artifact resolution problem: " + e.getMessage()));
        }
        return result;
    }

    private DefaultArtifact createAetherArtifact(org.apache.maven.artifact.Artifact artifact) {
        return new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getClassifier(), artifact.getType(), artifact.getVersion());
    }

    private boolean hasChanged(org.apache.maven.artifact.Artifact artifact, Predicate<File> since) {
        boolean changed = false;
        if (artifact.isSnapshot() && !this.done.contains(artifact)) {
            this.done.add(artifact);
            org.apache.maven.artifact.Artifact resolved = this.resolve(artifact);
            if (null != resolved) {
                if (since.test(resolved.getFile())) {
                    changed = true;
                } else {
                    try {
                        MavenProject mavenProject = this.createMavenProject(artifact);
                        for (Dependency d : mavenProject.getDependencies()) {
                            org.apache.maven.artifact.DefaultArtifact da = new org.apache.maven.artifact.DefaultArtifact(d.getGroupId(), d.getArtifactId(), d.getVersion(), d.getScope(), "jar", "", JAR_HANDLER);
                            if (!this.hasChanged((org.apache.maven.artifact.Artifact)da, since)) continue;
                            changed = true;
                            break;
                        }
                    }
                    catch (ProjectBuildingException e) {
                        this.caller.getLog().warn((CharSequence)("Project resolution problem: " + e.getMessage()));
                    }
                }
            }
        }
        return changed;
    }

    public MavenProject createMavenProject(org.apache.maven.artifact.Artifact artifact) throws ProjectBuildingException {
        MavenProject result = null;
        if (null != artifact) {
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.caller.getSession().getProjectBuildingRequest());
            buildingRequest.setProject(null);
            result = this.caller.getProjectBuilder().build(artifact, (ProjectBuildingRequest)buildingRequest).getProject();
        }
        return result;
    }

    public boolean haveDependenciesChangedSince(List<String> artifacts, Predicate<File> since) {
        boolean changed = false;
        for (String a : artifacts) {
            org.apache.maven.artifact.Artifact artifact = DependencyResolver.createArtifact(a, "compile");
            if (null == artifact) continue;
            changed = this.hasChanged(artifact, since);
        }
        return changed;
    }

    public static org.apache.maven.artifact.Artifact createArtifact(String artifact, String scope) {
        org.apache.maven.artifact.DefaultArtifact result = null;
        String[] tmp = artifact.split(":");
        if (tmp.length >= 3) {
            String version;
            String groupId = tmp[0];
            String artifactId = tmp[1];
            String type = "jar";
            String classifier = "";
            if (tmp.length == 3) {
                version = tmp[2];
            } else if (tmp.length == 4) {
                type = tmp[2];
                version = tmp[3];
            } else {
                type = tmp[2];
                classifier = tmp[3];
                version = tmp[4];
            }
            result = new org.apache.maven.artifact.DefaultArtifact(groupId, artifactId, version, scope, type, classifier, JAR_HANDLER);
        }
        return result;
    }

    public void clear() {
        this.done.clear();
    }

    public static interface Caller {
        public MavenSession getSession();

        public MavenProject getProject();

        public ProjectBuilder getProjectBuilder();

        default public List<RemoteRepository> getRemoteRepos() {
            return this.getProject().getRemoteProjectRepositories();
        }

        public RepositorySystem getRepoSystem();

        default public RepositorySystemSession getRepoSession() {
            return this.getSession().getRepositorySession();
        }

        public Log getLog();
    }
}

