/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.maven;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="textFile", defaultPhase=LifecyclePhase.COMPILE)
public class TextFileMojo
extends AbstractMojo {
    @Parameter(property="configuration.textFile.skip", required=false, defaultValue="false")
    private boolean skip;
    @Parameter(property="configuration.textFile.file", required=true)
    private File file;
    @Parameter(property="configuration.textFile.prepends", required=false)
    private List<String> prepends;
    @Parameter(property="configuration.textFile.appends", required=false)
    private List<String> appends;
    @Parameter(property="configuration.textFile.deletions", required=false)
    private Set<String> deletions;
    @Parameter(property="configuration.textFile.disabled", required=false)
    private Set<String> disabled;
    @Parameter
    private List<ReplacementSpec> replacements;

    private boolean isDisabled(ReplacementSpec spec) {
        boolean result = false;
        if (spec.id != null && spec.id.length() > 0 && this.disabled != null) {
            result = this.disabled.contains(spec.id);
        }
        return result;
    }

    private String applyReplacements(String line) {
        if (null != this.replacements) {
            for (ReplacementSpec r : this.replacements) {
                if (r.token == null || r.value == null || this.isDisabled(r)) continue;
                String val = r.value;
                if (r.escapeValueIn != null) {
                    switch (r.escapeValueIn.toLowerCase()) {
                        case "backslashes": {
                            val = val.replace("\\", "\\\\");
                            break;
                        }
                        case "java": {
                            val = StringEscapeUtils.escapeJava((String)val);
                            break;
                        }
                        case "ecma": {
                            val = StringEscapeUtils.escapeEcmaScript((String)val);
                            break;
                        }
                        case "json": {
                            val = StringEscapeUtils.escapeJson((String)val);
                            break;
                        }
                    }
                }
                line = line.replace(r.token, val);
            }
        }
        return line;
    }

    private static boolean isNonEmpty(Collection<?> coll) {
        return coll != null && coll.size() > 0;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            if (TextFileMojo.isNonEmpty(this.replacements) && TextFileMojo.isNonEmpty(this.disabled)) {
                this.getLog().info((CharSequence)("Disabled replacement specs: " + String.valueOf(this.disabled)));
            }
            File tmp = null;
            try {
                tmp = Files.createTempFile("mvnTextFile", ".txt", new FileAttribute[0]).toFile();
                Files.copy(this.file.toPath(), tmp.toPath(), LinkOption.NOFOLLOW_LINKS, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot copy source file " + String.valueOf(this.file) + ":" + e.getMessage());
            }
            try (LineNumberReader reader = new LineNumberReader(new FileReader(tmp));
                 PrintWriter out = new PrintWriter(new FileWriter(this.file));){
                String line;
                if (null != this.prepends) {
                    for (String s : this.prepends) {
                        out.println(s);
                    }
                }
                do {
                    if (null == (line = reader.readLine()) || null != this.deletions && this.deletions.contains(String.valueOf(reader.getLineNumber()))) continue;
                    out.println(this.applyReplacements(line));
                } while (line != null);
                if (null != this.appends) {
                    for (String s : this.appends) {
                        out.println(s);
                    }
                }
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot perform modifications:" + e.getMessage());
            }
            FileUtils.deleteQuietly((File)tmp);
            this.getLog().info((CharSequence)("Modified file " + String.valueOf(this.file)));
        }
    }

    public static class ReplacementSpec {
        @Parameter(required=false)
        private String id;
        @Parameter(required=true)
        private String token;
        @Parameter(required=true)
        private String value;
        @Parameter(required=false, defaultValue="")
        private String escapeValueIn;
    }
}

