/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration;

import de.iip_ecosphere.platform.configuration.cfg.AasChange;
import de.iip_ecosphere.platform.configuration.cfg.ConfigurationFactory;
import de.iip_ecosphere.platform.support.aas.Aas;
import de.iip_ecosphere.platform.support.aas.InvocablesCreator;
import de.iip_ecosphere.platform.support.aas.ProtocolServerBuilder;
import de.iip_ecosphere.platform.support.aas.Submodel;
import de.iip_ecosphere.platform.support.iip_aas.AasContributor;
import de.iip_ecosphere.platform.support.iip_aas.AasPartRegistry;
import de.iip_ecosphere.platform.support.json.JsonResultWrapper;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.io.IOException;

public class ConfigurationAas
implements AasContributor,
JsonResultWrapper.OperationCompletedListener {
    public static final String NAME_SUBMODEL = "Configuration";

    public Aas contributeTo(Aas.AasBuilder aasBuilder, InvocablesCreator iCreator) {
        Submodel.SubmodelBuilder smB = AasPartRegistry.createSubmodelBuilderRbac((Aas.AasBuilder)aasBuilder, (String)NAME_SUBMODEL);
        ConfigurationFactory.getAasChanges().setup(smB, iCreator, (JsonResultWrapper.OperationCompletedListener)this);
        smB.build();
        return null;
    }

    public void contributeTo(ProtocolServerBuilder sBuilder) {
        ConfigurationFactory.getAasChanges().bindOperations(sBuilder);
    }

    public AasContributor.Kind getKind() {
        return AasContributor.Kind.ACTIVE;
    }

    public boolean isValid() {
        return true;
    }

    public void operationCompleted() {
        try {
            Aas aas = AasPartRegistry.retrieveIipAas();
            Submodel sm = aas.getSubmodel(NAME_SUBMODEL);
            Submodel.SubmodelBuilder smB = AasPartRegistry.createSubmodelBuilderRbac((Aas)aas, (String)NAME_SUBMODEL);
            for (AasChange c : ConfigurationFactory.getAasChanges().getAndClearAasChanges()) {
                c.apply(sm, smB);
            }
            smB.build();
        }
        catch (IOException e) {
            LoggerFactory.getLogger(ConfigurationAas.class).error("While modifying configuration AAS: {}", (Object)e.getMessage());
        }
    }

    public void operationFailed() {
        ConfigurationFactory.getAasChanges().clearAasChanges();
    }
}

