/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.configuration.defaultLib;

import de.iip_ecosphere.platform.services.environment.DataIngestors;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import iip.datatypes.MipMqttInput;
import iip.datatypes.MipMqttInputImpl;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimerTask;

public class MipIdentificationSensor {
    public static final String DATE_PATTERN = "E MMM dd HH:mm:ss yyyy";

    public static String formatDate(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_PATTERN, Locale.GERMAN);
        return simpleDateFormat.format(date).replace(".", "");
    }

    public static MipMqttInput createStartStopCommand(boolean start, String sensorId) {
        MipMqttInputImpl cmd = new MipMqttInputImpl();
        cmd.setMipcontext("reader_command");
        cmd.setMipdate(MipIdentificationSensor.formatDate(new Date()));
        cmd.setMipto(sensorId);
        cmd.setMipcommand(start ? "reader_read s 1\n" : "reader_read s 0\n");
        return cmd;
    }

    public static void sendStartStopCommand(boolean start, String sensorId, DataIngestors<MipMqttInput> ingestors) {
        MipMqttInput cmd = MipIdentificationSensor.createStartStopCommand(start, sensorId);
        LoggerFactory.getLogger(MipIdentificationSensor.class).info("Sending MIP sensor command (start: {}, id:{}) via ingestors", (Object)start, (Object)sensorId);
        ingestors.ingest((Object)cmd);
    }

    public static class MipTimerTask
    extends TimerTask {
        private boolean start;
        private DataIngestors<MipMqttInput> ingestors;
        private String sensorId;

        public MipTimerTask(boolean start, String sensorId, DataIngestors<MipMqttInput> ingestors) {
            this.start = start;
            this.sensorId = sensorId;
            this.ingestors = ingestors;
        }

        @Override
        public void run() {
            MipIdentificationSensor.sendStartStopCommand(this.start, this.sensorId, this.ingestors);
        }
    }
}

