/*
 * Decompiled with CFR 0.152.
 */
package test.de.oktoflow.platform.connectors.file;

import de.iip_ecosphere.platform.connectors.Connector;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.types.ChannelProtocolAdapter;
import de.iip_ecosphere.platform.connectors.types.ChannelTranslatingProtocolAdapter;
import de.iip_ecosphere.platform.connectors.types.ConnectorInputTypeAdapter;
import de.iip_ecosphere.platform.connectors.types.ConnectorInputTypeTranslator;
import de.iip_ecosphere.platform.connectors.types.ConnectorOutputTypeAdapter;
import de.iip_ecosphere.platform.connectors.types.ConnectorOutputTypeTranslator;
import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.FileUtils;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import de.iip_ecosphere.platform.transport.serialization.Serializer;
import de.iip_ecosphere.platform.transport.serialization.SerializerRegistry;
import de.oktoflow.platform.connectors.file.FileConnector;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.connectors.ConnectorTest;
import test.de.iip_ecosphere.platform.transport.Command;
import test.de.iip_ecosphere.platform.transport.CommandJsonSerializer;
import test.de.iip_ecosphere.platform.transport.Product;
import test.de.iip_ecosphere.platform.transport.ProductJsonSerializer;

public class FileConnectorTest {
    private Connector<byte[], byte[], Product, Command> createConnector(Serializer<Product> outSer, Serializer<Command> inSer, boolean determineTimeDiff) {
        FileConnector result = new FileConnector(new ChannelProtocolAdapter[]{new ChannelTranslatingProtocolAdapter("prod", (ConnectorOutputTypeTranslator)new ConnectorOutputTypeAdapter(outSer), "cmd", (ConnectorInputTypeTranslator)new ConnectorInputTypeAdapter(inSer))});
        if (determineTimeDiff) {
            result.setDataTimeDifferenceProvider(p -> 900);
        }
        return result;
    }

    private static String composeTmpPath(String postfix) {
        Object tmp = FileUtils.getTempDirectoryPath();
        if (!((String)tmp).endsWith(File.separator)) {
            tmp = (String)tmp + File.separator;
        }
        return (String)tmp + postfix;
    }

    @Test
    public void testSingleFile() throws IOException {
        this.testConnector("src/test/resources/singleFile/dataFile.json", FileConnectorTest.composeTmpPath(""), 2, false);
    }

    @Test
    public void testSingleFileResource() throws IOException {
        this.testConnector("singleFile/dataFile.json", null, 2, false);
    }

    @Test
    public void testMultipleFiles() throws IOException {
        this.testConnector("src/test/resources/multiFiles/", FileConnectorTest.composeTmpPath("fileConnTest.txt"), 4, false);
    }

    @Test
    public void testRegExFiles() throws IOException {
        this.testConnector("src/test/resources/patternFiles/dataFile\\d.json", null, 4, true);
    }

    private static File[] listTmpConnectorFiles(boolean considerThread) {
        return FileUtils.getTempDirectory().listFiles(FileConnector.getWriteFileNameFilter((boolean)considerThread));
    }

    private static File[] deleteTmpConnectorFiles(String writeFiles) {
        File f;
        File[] files = FileConnectorTest.listTmpConnectorFiles(false);
        if (null != files) {
            for (File f2 : files) {
                FileUtils.deleteQuietly((File)f2);
            }
        }
        if (null != writeFiles && (f = new File(writeFiles)).isFile() && f.exists()) {
            FileUtils.deleteQuietly((File)f);
        }
        return files;
    }

    private static File findNewConnectorFile(File[] before, String writeFiles) {
        Object[] files;
        File tmp;
        File result = null;
        boolean checkTmp = true;
        if (null != writeFiles && (tmp = new File(writeFiles)).isFile() && tmp.exists()) {
            result = tmp;
            checkTmp = false;
        }
        if (checkTmp && null != (files = FileConnectorTest.listTmpConnectorFiles(true)) && null != before) {
            HashSet tmp2 = new HashSet();
            CollectionUtils.addAll(tmp2, (Object[])files);
            for (File b : before) {
                tmp2.remove(b);
            }
            Optional o = tmp2.stream().findFirst();
            if (o.isPresent()) {
                result = (File)o.get();
            }
        }
        return result;
    }

    private void testConnector(String readFiles, String writeFiles, int expectedReceived, boolean determineTimeDiff) throws IOException {
        System.out.println("Testing with read (" + readFiles + ") write (" + writeFiles + ")");
        File[] tmpFiles = FileConnectorTest.deleteTmpConnectorFiles(writeFiles);
        ConnectorTest.assertDescriptorRegistration(FileConnector.Descriptor.class);
        ConnectorParameter cParams = ConnectorParameter.ConnectorParameterBuilder.newBuilder((String)"localhost", (int)10).setNotificationInterval(1000).setSpecificSetting("READ_FILES", (Object)readFiles).setSpecificSetting("WRITE_FILES", (Object)writeFiles).setSpecificSetting("DATA_TIMEDIFF", (Object)100).build();
        ProductJsonSerializer outSer = new ProductJsonSerializer();
        SerializerRegistry.registerSerializer((Serializer)outSer);
        CommandJsonSerializer inSer = new CommandJsonSerializer();
        SerializerRegistry.registerSerializer((Serializer)inSer);
        Connector<byte[], byte[], Product, Command> c = this.createConnector((Serializer<Product>)outSer, (Serializer<Command>)inSer, determineTimeDiff);
        ConnectorTest.assertInstance(c, (boolean)false);
        ConnectorTest.assertConnectorProperties(c);
        c.connect(cParams);
        ConnectorTest.assertInstance(c, (boolean)true);
        final ArrayList receivedProducts = new ArrayList();
        c.setReceptionCallback((ReceptionCallback)new ReceptionCallback<Product>(){

            public void received(Product data) {
                receivedProducts.add(data);
                System.out.println("RECEIVED " + data.getDescription() + " " + data.getPrice());
            }

            public Class<Product> getType() {
                return Product.class;
            }
        });
        c.enableNotifications(false);
        TimeUtils.sleep((int)(expectedReceived * 1500));
        Command cmd = new Command("run");
        c.write((Object)cmd);
        ConnectorTest.assertInstance(c, (boolean)true);
        c.disconnect();
        ConnectorTest.assertInstance(c, (boolean)false);
        c.dispose();
        SerializerRegistry.unregisterSerializer((Serializer)outSer);
        SerializerRegistry.unregisterSerializer((Serializer)inSer);
        Assert.assertEquals((long)expectedReceived, (long)receivedProducts.size());
        ArrayList receivedProductsSorted = new ArrayList(receivedProducts);
        Collections.sort(receivedProductsSorted, (p1, p2) -> p1.getDescription().compareTo(p2.getDescription()));
        Assert.assertEquals(receivedProductsSorted, receivedProducts);
        if (writeFiles != null) {
            File written = FileConnectorTest.findNewConnectorFile(tmpFiles, writeFiles);
            Assert.assertNotNull((String)"No file written", (Object)written);
            String writtenContents = FileUtils.readFileToString((File)written, (Charset)Charset.defaultCharset()).trim();
            String expectedContents = new String((byte[])inSer.to((Object)cmd)).trim();
            Assert.assertEquals((Object)expectedContents, (Object)writtenContents);
            FileUtils.deleteQuietly((File)written);
        }
    }
}

