/*
 * Decompiled with CFR 0.152.
 */
package de.oktoflow.platform.connectors.file;

import de.iip_ecosphere.platform.connectors.AbstractChannelConnector;
import de.iip_ecosphere.platform.connectors.AbstractPluginChannelConnectorDescriptor;
import de.iip_ecosphere.platform.connectors.ChannelAdapterSelector;
import de.iip_ecosphere.platform.connectors.Connector;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.MachineConnector;
import de.iip_ecosphere.platform.connectors.MachineConnectorSupportedQueries;
import de.iip_ecosphere.platform.connectors.events.ConnectorTriggerQuery;
import de.iip_ecosphere.platform.connectors.types.ChannelProtocolAdapter;
import de.iip_ecosphere.platform.support.CollectionUtils;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.support.resources.ResourceLoader;
import de.iip_ecosphere.platform.support.resources.ResourceResolver;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

@MachineConnector(hasModel=false, supportsEvents=true, supportsHierarchicalQNames=false, supportsModelCalls=false, supportsModelProperties=false, supportsModelStructs=false, specificSettings={}, supportsDataTimeDifference=true)
@MachineConnectorSupportedQueries(value={ConnectorTriggerQuery.class})
public class FileConnector<CO, CI>
extends AbstractChannelConnector<byte[], byte[], CO, CI> {
    public static final String NAME = "File";
    public static final String SETTING_READ_FILES = "READ_FILES";
    public static final String SETTING_WRITE_FILES = "WRITE_FILES";
    public static final String SETTING_DATA_TIMEDIFF = "DATA_TIMEDIFF";
    public static final String SETTING_SKIP_FIRST_LINE = "SKIP_FIRST_LINE";
    public static final String OUT_NAME_PREFIX = "FileConnector_";
    public static final String OUT_NAME_SUFFIX = ".txt";
    private static final Logger LOGGER = LoggerFactory.getLogger(FileConnector.class);
    private List<File> readFiles = new ArrayList<File>();
    private File writeFiles;
    private boolean connected = false;
    private Map<String, PrintStream> out = new HashMap<String, PrintStream>();
    private boolean outFailed = false;
    private String pollResult = null;
    private boolean polling = false;
    private int requestTimeout = -1;
    private int pollingFrequency = 0;
    private int fixedDataInterval = 0;
    private int nextDataInterval = -1;
    private boolean skipFirstLine = false;

    @SafeVarargs
    public FileConnector(ChannelProtocolAdapter<byte[], byte[], CO, CI> ... adapter) {
        this((ChannelAdapterSelector<byte[], byte[], CO, CI>)null, adapter);
    }

    @SafeVarargs
    public FileConnector(ChannelAdapterSelector<byte[], byte[], CO, CI> selector, ChannelProtocolAdapter<byte[], byte[], CO, CI> ... adapter) {
        super(selector, adapter);
    }

    protected void connectImpl(ConnectorParameter params) throws IOException {
        String inFiles = params.getSpecificStringSetting(SETTING_READ_FILES);
        if (null != inFiles) {
            StringTokenizer tokens = new StringTokenizer(inFiles, ";:");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                File f = new File(token);
                Object[] tmp = null;
                if (f.isFile() && f.exists()) {
                    this.readFiles.add(f);
                } else if (f.isDirectory() && f.exists()) {
                    tmp = f.listFiles();
                } else {
                    try {
                        final Pattern p = Pattern.compile(token);
                        String dirTmp = "";
                        String sepTmp = "";
                        int pos = token.lastIndexOf(47);
                        if (pos > 0) {
                            dirTmp = token.substring(0, pos);
                            sepTmp = "/";
                        } else {
                            pos = token.lastIndexOf(92);
                            if (pos > 0) {
                                dirTmp = token.substring(0, pos);
                                sepTmp = "\\";
                            }
                        }
                        final String sep = sepTmp;
                        final String dir = dirTmp;
                        tmp = new File(dir).listFiles(new FilenameFilter(){

                            @Override
                            public boolean accept(File dirFile, String name) {
                                return p.matcher(dir + sep + name).matches();
                            }
                        });
                    }
                    catch (PatternSyntaxException e) {
                        LOGGER.warn("Pattern '{}' is not a Java regular expression. Ignoring/trying as resource.", (Object)f.getName());
                    }
                    if (tmp == null || tmp.length == 0) {
                        tmp = new File[]{new File(token)};
                    }
                }
                if (null == tmp) continue;
                CollectionUtils.addAll(this.readFiles, (Object[])tmp);
                Collections.sort(this.readFiles, (f1, f2) -> f1.getAbsolutePath().compareTo(f2.getAbsolutePath()));
            }
        } else {
            LOGGER.warn("No READ_FILES specified.");
        }
        this.connected = true;
        String writeFiles = params.getSpecificStringSetting(SETTING_WRITE_FILES);
        if (null != writeFiles) {
            this.writeFiles = new File(writeFiles);
        }
        LOGGER.info("File connected with InputFile(s) " + String.valueOf(this.readFiles) + " OutputFile" + writeFiles);
        this.fixedDataInterval = params.getSpecificIntSetting(SETTING_DATA_TIMEDIFF);
        this.skipFirstLine = Boolean.valueOf(params.getSpecificStringSetting(SETTING_SKIP_FIRST_LINE));
        this.pollingFrequency = params.getNotificationInterval();
        this.requestTimeout = params.getRequestTimeout();
        this.readData();
    }

    private BufferedReader open(File file) throws IOException {
        BufferedReader result;
        try {
            LOGGER.info("Trying to open file {}", (Object)file);
            result = new BufferedReader(new FileReader(file));
        }
        catch (IOException e) {
            LOGGER.info("Trying to read resource {}", (Object)file);
            InputStream in = ResourceLoader.getResourceAsStream((String)file.toString(), (ResourceResolver[])new ResourceResolver[0]);
            if (null == in) {
                LOGGER.info("Trying to read resource resources/{}", (Object)file);
                in = ResourceLoader.getResourceAsStream((String)("resources/" + file.toString()), (ResourceResolver[])new ResourceResolver[0]);
            }
            if (null == in) {
                LOGGER.info("Trying to read resource resources/software/{}", (Object)file);
                in = ResourceLoader.getResourceAsStream((String)("resources/software/" + file.toString()), (ResourceResolver[])new ResourceResolver[0]);
            }
            if (in != null) {
                result = new BufferedReader(new InputStreamReader(in));
            }
            throw e;
        }
        return result;
    }

    private void readData() {
        new Thread(() -> {
            for (File f : this.readFiles) {
                boolean firstLine = true;
                try (BufferedReader br = this.open(f);){
                    String line;
                    while (this.connected && (line = br.readLine()) != null) {
                        if (!firstLine || firstLine && !this.skipFirstLine) {
                            if (this.pollingFrequency > 0) {
                                while (this.connected && (!this.polling || this.pollResult != null)) {
                                    TimeUtils.sleep((int)50);
                                }
                                this.pollResult = line;
                            } else {
                                try {
                                    this.received(f.getName(), line.getBytes());
                                }
                                catch (IOException e) {
                                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("When receiving line: {}", (Object)e.getMessage(), (Object)e);
                                }
                                int interval = this.fixedDataInterval;
                                if (this.nextDataInterval >= 0) {
                                    interval = this.nextDataInterval;
                                }
                                if (interval > 0) {
                                    TimeUtils.sleep((int)interval);
                                }
                            }
                        }
                        firstLine = false;
                    }
                }
                catch (IOException e) {
                    LOGGER.error("While reading file {}: {}", new Object[]{f, e.getMessage(), e});
                }
                if (this.connected) continue;
                break;
            }
        }).start();
    }

    protected void notifyDataTimeDifference(int difference) {
        this.nextDataInterval = difference;
    }

    protected synchronized void disconnectImpl() throws IOException {
        this.connected = false;
        if (this.out != null) {
            for (PrintStream o : this.out.values()) {
                o.close();
            }
            this.out.clear();
        }
    }

    public void dispose() {
    }

    public String getName() {
        return NAME;
    }

    protected synchronized void writeImpl(byte[] data, String channel) throws IOException {
        if (null == channel) {
            channel = "";
        }
        PrintStream out = this.out.get(channel);
        if (null != this.writeFiles && null == out && !this.outFailed) {
            File f = this.writeFiles;
            if (this.writeFiles.isDirectory()) {
                this.writeFiles.mkdirs();
                f = new File(this.writeFiles, OUT_NAME_PREFIX + System.currentTimeMillis() + "_" + Thread.currentThread().getId() + OUT_NAME_SUFFIX);
            }
            try {
                out = new PrintStream(new FileOutputStream(f));
                this.out.put(channel, out);
            }
            catch (IOException e) {
                this.outFailed = true;
                LOGGER.error("While reading file {}: {}", new Object[]{f, e.getMessage(), e});
            }
        }
        if (null != out) {
            out.write(data);
            out.println();
        }
    }

    protected byte[] read() throws IOException {
        byte[] result = null;
        if (!this.polling) {
            this.polling = true;
            TimeUtils.waitFor(() -> this.pollResult == null, (int)this.requestTimeout, (int)20);
            result = null == this.pollResult ? null : this.pollResult.getBytes();
            this.pollResult = null;
            this.polling = false;
        }
        return result;
    }

    protected void error(String message, Throwable th) {
        LOGGER.error(message, th);
    }

    public String supportedEncryption() {
        return null;
    }

    public String enabledEncryption() {
        return null;
    }

    public static FilenameFilter getWriteFileNameFilter(boolean considerThread) {
        final String suffix = (String)(considerThread ? "_" + Thread.currentThread().getId() : "") + OUT_NAME_SUFFIX;
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(FileConnector.OUT_NAME_PREFIX) && name.endsWith(suffix);
            }
        };
    }

    public void trigger(ConnectorTriggerQuery query) {
        try {
            this.read();
        }
        catch (IOException e) {
            LOGGER.error("While processing a query trigger: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static class Descriptor
    extends AbstractPluginChannelConnectorDescriptor<byte[], byte[]> {
        public String getName() {
            return FileConnector.NAME;
        }

        public Class<?> getConnectorType() {
            return FileConnector.class;
        }

        protected String initId(String id) {
            return "connector-file";
        }

        protected <O, I, CO, CI, S extends ChannelAdapterSelector<byte[], byte[], CO, CI>, A extends ChannelProtocolAdapter<byte[], byte[], CO, CI>> Connector<byte[], byte[], CO, CI> createConnectorImpl(S selector, Supplier<ConnectorParameter> params, A ... adapter) {
            return new FileConnector(selector, (ChannelProtocolAdapter<byte[], byte[], CO, CI>[])adapter);
        }
    }
}

