/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors.influxv3;

import com.influxdb.v3.client.Point;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.influxv3.InfluxConnector;
import de.iip_ecosphere.platform.connectors.model.AbstractTypeMappingModelAccess;
import de.iip_ecosphere.platform.connectors.model.ModelAccess;
import de.iip_ecosphere.platform.connectors.model.ModelInputConverter;
import de.iip_ecosphere.platform.connectors.model.ModelOutputConverter;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InfluxModelAccess
extends AbstractTypeMappingModelAccess {
    static final String FIELD_TIME = "*T*";
    private static final String SEPARATOR = "_";
    private List<String> nesting = new ArrayList<String>();
    private String prefix = "";
    private List<Point> batch = new ArrayList<Point>(10);
    private InfluxInputConverter inputConverter = new InfluxInputConverter();
    private InfluxOutputConverter outputConverter = new InfluxOutputConverter();
    private InfluxConnector<?, ?> connector;
    private Point writePoint;
    private Instant writePointTime;
    private Map<String, Object> readValues;

    InfluxModelAccess(InfluxConnector<?, ?> connector) {
        super(connector);
        this.connector = connector;
    }

    public ModelInputConverter getInputConverter() {
        return this.inputConverter;
    }

    public ModelOutputConverter getOutputConverter() {
        return this.outputConverter;
    }

    private void initPoint() {
        if (null == this.writePoint) {
            this.writePoint = Point.measurement((String)this.connector.getMeasurement());
            this.writePointTime = null;
        }
    }

    private void clearPoint() {
        this.writePoint = null;
        this.writePointTime = null;
    }

    public void setInt(String qName, int value) throws IOException {
        this.initPoint();
        this.writePoint.setField(this.prefix + qName, (long)value);
    }

    public void setLong(String qName, long value) throws IOException {
        this.initPoint();
        this.writePoint.setField(this.prefix + qName, value);
    }

    public void setLongIndex(String qName, long value) throws IOException {
        this.writePointTime = Instant.ofEpochMilli(value);
    }

    public void setFloatIndex(String qName, float value) throws IOException {
        this.writePointTime = Instant.ofEpochMilli(this.connector.toTimestamp(value));
    }

    public void setByte(String qName, byte value) throws IOException {
        this.initPoint();
        this.writePoint.setField(this.prefix + qName, (long)value);
    }

    public void setShort(String qName, short value) throws IOException {
        this.initPoint();
        this.writePoint.setField(this.prefix + qName, (long)value);
    }

    public void setBoolean(String qName, boolean value) throws IOException {
        this.initPoint();
        this.writePoint.setField(this.prefix + qName, value);
    }

    public void setDouble(String qName, double value) throws IOException {
        this.initPoint();
        this.writePoint.setField(this.prefix + qName, value);
    }

    public void setFloat(String qName, float value) throws IOException {
        this.initPoint();
        this.writePoint.setField(this.prefix + qName, (double)value);
    }

    public void setString(String qName, String value) throws IOException {
        this.initPoint();
        if (this.connector.getTags().contains(qName)) {
            this.writePoint.setTag(this.prefix + qName, value);
        } else {
            this.writePoint.setField(qName, value);
        }
    }

    public Object get(String qName) throws IOException {
        if (null != this.readValues) {
            return this.readValues.get(this.prefix + qName);
        }
        throw new IOException("No data to read");
    }

    public long getLongIndex(String qName) throws IOException {
        Object time;
        Long result = null;
        if (null != this.readValues && (time = this.readValues.get(FIELD_TIME)) instanceof Instant) {
            Instant instant = (Instant)time;
            result = instant.getEpochSecond();
        }
        if (null == result) {
            throw new IOException("No data to read");
        }
        return result;
    }

    public float getFloatIndex(String qName) throws IOException {
        Object time;
        Float result = null;
        if (null != this.readValues && (time = this.readValues.get(FIELD_TIME)) instanceof Instant) {
            Instant instant = (Instant)time;
            result = Float.valueOf(this.connector.fromTimestamp(instant.getEpochSecond()));
        }
        if (null == result) {
            throw new IOException("No data to read");
        }
        return result.floatValue();
    }

    void writeCompleted() {
        if (null != this.writePoint) {
            Instant time = this.writePointTime;
            if (null == this.writePointTime) {
                time = Instant.now();
            }
            this.writePoint.setTimestamp(time);
            int batchSize = this.connector.getBatchSize();
            if (batchSize > 1) {
                if (this.batch.size() == batchSize) {
                    this.connector.getClient().writePoints(this.batch);
                    this.batch.clear();
                } else {
                    this.batch.add(this.writePoint);
                }
            } else {
                this.connector.getClient().writePoint(this.writePoint);
            }
            this.clearPoint();
        }
    }

    void setReadData(Map<String, Object> values) {
        this.readValues = values;
    }

    void readCompleted() {
        this.readValues = null;
    }

    public void dispose() {
        this.writeCompleted();
        this.readCompleted();
    }

    public Object call(String qName, Object ... arg1) throws IOException {
        return null;
    }

    public String getQSeparator() {
        return SEPARATOR;
    }

    public <T> T getStruct(String arg0, Class<T> arg1) throws IOException {
        return null;
    }

    public void monitor(String ... qName) throws IOException {
    }

    public void registerCustomType(Class<?> cls) throws IOException {
    }

    public void setStruct(String arg0, Object arg1) throws IOException {
    }

    public String topInstancesQName() {
        return null;
    }

    public void monitor(int notificationInterval, String ... qNames) throws IOException {
    }

    public void monitorModelChanges(int notificationInterval) throws IOException {
    }

    public ModelAccess stepInto(String name) throws IOException {
        this.nesting.add(name);
        this.prefix = this.prefix + name + SEPARATOR;
        return this;
    }

    public ModelAccess stepOut() {
        if (this.nesting.size() > 0) {
            String last = this.nesting.remove(this.nesting.size() - 1);
            this.prefix = this.prefix.substring(0, this.prefix.length() - last.length() - SEPARATOR.length());
        }
        return this;
    }

    public ConnectorParameter getConnectorParameter() {
        return this.connector.getParameter();
    }

    public class InfluxInputConverter
    extends ModelInputConverter {
        public float toFloat(Object data) throws IOException {
            return ((Double)data).floatValue();
        }

        public int toInteger(Object data) throws IOException {
            return ((Long)data).intValue();
        }

        public byte toByte(Object data) throws IOException {
            return ((Long)data).byteValue();
        }

        public short toShort(Object data) throws IOException {
            return ((Long)data).shortValue();
        }
    }

    public class InfluxOutputConverter
    extends ModelOutputConverter {
    }
}

