/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.v3.client.write;

import com.influxdb.v3.client.config.ClientConfig;
import com.influxdb.v3.client.internal.Arguments;
import com.influxdb.v3.client.write.WritePrecision;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class WriteOptions {
    public static final WritePrecision DEFAULT_WRITE_PRECISION = WritePrecision.NS;
    public static final Integer DEFAULT_GZIP_THRESHOLD = 1000;
    public static final boolean DEFAULT_NO_SYNC = false;
    public static final int DEFAULT_WRITE_TIMEOUT = 10;
    @Deprecated(forRemoval=true)
    public static final WriteOptions DEFAULTS = new WriteOptions(null, DEFAULT_WRITE_PRECISION, DEFAULT_GZIP_THRESHOLD, false, null, null);
    private final String database;
    private final WritePrecision precision;
    private final Integer gzipThreshold;
    private final Boolean noSync;
    private final Map<String, String> defaultTags;
    private final Map<String, String> headers;

    public static WriteOptions defaultWriteOptions() {
        return new WriteOptions(null, DEFAULT_WRITE_PRECISION, DEFAULT_GZIP_THRESHOLD, false, null, null);
    }

    public WriteOptions(@Nullable String database, @Nullable WritePrecision precision, @Nullable Integer gzipThreshold) {
        this(database, precision, gzipThreshold, null, null, null);
    }

    public WriteOptions(@Nullable String database, @Nullable WritePrecision precision, @Nullable Integer gzipThreshold, @Nullable Map<String, String> defaultTags) {
        this(database, precision, gzipThreshold, null, defaultTags, null);
    }

    public WriteOptions(@Nullable String database, @Nullable WritePrecision precision, @Nullable Integer gzipThreshold, @Nullable Boolean noSync) {
        this(database, precision, gzipThreshold, noSync, null, null);
    }

    public WriteOptions(@Nullable Map<String, String> headers) {
        this(null, null, null, null, null, headers);
    }

    public WriteOptions(@Nullable String database, @Nullable WritePrecision precision, @Nullable Integer gzipThreshold, @Nullable Map<String, String> defaultTags, @Nullable Map<String, String> headers) {
        this(database, precision, gzipThreshold, null, defaultTags, headers);
    }

    public WriteOptions(@Nullable String database, @Nullable WritePrecision precision, @Nullable Integer gzipThreshold, @Nullable Boolean noSync, @Nullable Map<String, String> defaultTags, @Nullable Map<String, String> headers) {
        this.database = database;
        this.precision = precision;
        this.gzipThreshold = gzipThreshold;
        this.noSync = noSync;
        this.defaultTags = defaultTags == null ? Map.of() : defaultTags;
        this.headers = headers == null ? Map.of() : headers;
    }

    @Nullable
    public String databaseSafe(@Nonnull ClientConfig config) {
        Arguments.checkNotNull(config, "config");
        return this.isNotDefined(this.database) ? config.getDatabase() : this.database;
    }

    @Nonnull
    public WritePrecision precisionSafe(@Nonnull ClientConfig config) {
        Arguments.checkNotNull(config, "config");
        return this.precision != null ? this.precision : (config.getWritePrecision() != null ? config.getWritePrecision() : DEFAULT_WRITE_PRECISION);
    }

    @Nonnull
    public Map<String, String> defaultTagsSafe(@Nonnull ClientConfig config) {
        Arguments.checkNotNull(config, "config");
        return this.defaultTags.isEmpty() ? (config.getDefaultTags() != null ? config.getDefaultTags() : this.defaultTags) : this.defaultTags;
    }

    @Nonnull
    public Integer gzipThresholdSafe(@Nonnull ClientConfig config) {
        Arguments.checkNotNull(config, "config");
        return this.gzipThreshold != null ? this.gzipThreshold : (config.getGzipThreshold() != null ? config.getGzipThreshold() : DEFAULT_GZIP_THRESHOLD);
    }

    public boolean noSyncSafe(@Nonnull ClientConfig config) {
        Arguments.checkNotNull(config, "config");
        return this.noSync != null ? this.noSync : (config.getWriteNoSync() != null ? config.getWriteNoSync() : false);
    }

    @Nonnull
    public Map<String, String> headersSafe() {
        return this.headers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteOptions that = (WriteOptions)o;
        return Objects.equals(this.database, that.database) && this.precision == that.precision && Objects.equals(this.gzipThreshold, that.gzipThreshold) && Objects.equals(this.noSync, that.noSync) && this.defaultTags.equals(that.defaultTags) && this.headers.equals(that.headers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.database, this.precision, this.gzipThreshold, this.noSync, this.defaultTags, this.headers});
    }

    private boolean isNotDefined(String option) {
        return option == null || option.isEmpty();
    }

    private WriteOptions(@Nonnull Builder builder) {
        this(builder.database, builder.precision, builder.gzipThreshold, builder.noSync, builder.defaultTags, builder.headers);
    }

    public static final class Builder {
        private String database;
        private WritePrecision precision;
        private Integer gzipThreshold;
        private Boolean noSync;
        private Map<String, String> defaultTags = new HashMap<String, String>();
        private Map<String, String> headers = new HashMap<String, String>();

        @Nonnull
        public Builder database(@Nonnull String database) {
            this.database = database;
            return this;
        }

        @Nonnull
        public Builder precision(@Nonnull WritePrecision precision) {
            this.precision = precision;
            return this;
        }

        @Nonnull
        public Builder gzipThreshold(@Nonnull Integer gzipThreshold) {
            this.gzipThreshold = gzipThreshold;
            return this;
        }

        @Nonnull
        public Builder noSync(@Nonnull Boolean noSync) {
            this.noSync = noSync;
            return this;
        }

        @Nonnull
        public Builder defaultTags(@Nonnull Map<String, String> defaultTags) {
            this.defaultTags = defaultTags;
            return this;
        }

        @Nonnull
        public Builder headers(@Nonnull Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        @Nonnull
        public WriteOptions build() {
            return new WriteOptions(this);
        }
    }
}

