/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.auth;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import org.apache.arrow.flight.auth.AuthConstants;
import org.apache.arrow.flight.auth.ClientAuthHandler;

public class ClientAuthInterceptor
implements ClientInterceptor {
    private volatile ClientAuthHandler authHandler = null;

    public void setAuthHandler(ClientAuthHandler authHandler) {
        this.authHandler = authHandler;
    }

    public boolean hasAuthHandler() {
        return this.authHandler != null;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> methodDescriptor, CallOptions callOptions, Channel next) {
        Object call = next.newCall(methodDescriptor, callOptions);
        if (this.authHandler != null) {
            call = new HeaderAttachingClientCall(call);
        }
        return call;
    }

    private final class HeaderAttachingClientCall<ReqT, RespT>
    extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
        private HeaderAttachingClientCall(ClientCall<ReqT, RespT> call) {
            super(call);
        }

        public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
            Metadata authHeaders = new Metadata();
            authHeaders.put(AuthConstants.TOKEN_KEY, (Object)ClientAuthInterceptor.this.authHandler.getCallToken());
            headers.merge(authHeaders);
            super.start(responseListener, headers);
        }
    }
}

