/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.v3.client;

import com.influxdb.v3.client.Point;
import com.influxdb.v3.client.internal.Arguments;
import com.influxdb.v3.client.internal.NanosecondConverter;
import com.influxdb.v3.client.write.WritePrecision;
import java.math.BigInteger;
import java.time.Instant;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class PointValues {
    private String name;
    private final Map<String, String> tags = new TreeMap<String, String>();
    private final Map<String, Object> fields = new TreeMap<String, Object>();
    private Number time;

    @Nonnull
    public static PointValues measurement(@Nonnull String measurementName) {
        Arguments.checkNotNull(measurementName, "measurement");
        return new PointValues().setMeasurement(measurementName);
    }

    @Nullable
    public String getMeasurement() {
        return this.name;
    }

    @Nonnull
    public PointValues setMeasurement(@Nonnull String measurement) {
        Arguments.checkNotNull(measurement, "precision");
        this.name = measurement;
        return this;
    }

    @Nullable
    public Number getTimestamp() {
        return this.time;
    }

    @Nonnull
    public PointValues setTimestamp(@Nullable Instant time) {
        if (time == null) {
            return this.setTimestamp(null, WritePrecision.NS);
        }
        BigInteger convertedTime = NanosecondConverter.convert(time, WritePrecision.NS);
        return this.setTimestamp(convertedTime, WritePrecision.NS);
    }

    @Nonnull
    public PointValues setTimestamp(@Nullable Number time, @Nonnull WritePrecision precision) {
        Arguments.checkNotNull((Object)precision, "precision");
        this.time = NanosecondConverter.convertToNanos(time, precision);
        return this;
    }

    @Nonnull
    public PointValues setTimestamp(@Nullable Long time, @Nonnull WritePrecision precision) {
        return this.setTimestamp((Number)time, precision);
    }

    @Nullable
    public String getTag(@Nonnull String name) {
        Arguments.checkNotNull(name, "tagName");
        return this.tags.get(name);
    }

    @Nonnull
    public PointValues setTag(@Nonnull String key, @Nullable String value) {
        Arguments.checkNotNull(key, "tagName");
        this.tags.put(key, value);
        return this;
    }

    @Nonnull
    public PointValues setTags(@Nonnull Map<String, String> tagsToAdd) {
        Arguments.checkNotNull(tagsToAdd, "tagsToAdd");
        tagsToAdd.forEach(this::setTag);
        return this;
    }

    @Nonnull
    public PointValues removeTag(@Nonnull String name) {
        Arguments.checkNotNull(name, "tagName");
        this.tags.remove(name);
        return this;
    }

    @Nonnull
    public String[] getTagNames() {
        return this.tags.keySet().toArray(new String[0]);
    }

    @Nullable
    public Double getFloatField(@Nonnull String name) throws ClassCastException {
        return this.getField(name, Double.class);
    }

    @Nonnull
    public PointValues setFloatField(@Nonnull String name, double value) {
        return this.putField(name, value);
    }

    @Nullable
    public Long getIntegerField(@Nonnull String name) throws ClassCastException {
        return this.getField(name, Long.class);
    }

    public PointValues setIntegerField(@Nonnull String name, long value) {
        return this.putField(name, value);
    }

    @Nullable
    public String getStringField(@Nonnull String name) throws ClassCastException {
        return this.getField(name, String.class);
    }

    public PointValues setStringField(@Nonnull String name, String value) {
        return this.putField(name, value);
    }

    @Nullable
    public Boolean getBooleanField(@Nonnull String name) throws ClassCastException {
        return this.getField(name, Boolean.class);
    }

    public PointValues setBooleanField(@Nonnull String name, boolean value) {
        return this.putField(name, value);
    }

    @Nullable
    public Object getField(@Nonnull String name) {
        return this.fields.get(name);
    }

    @Nullable
    public <T> T getField(String name, Class<T> type) throws ClassCastException {
        Object field = this.getField(name);
        if (field == null) {
            return null;
        }
        return type.cast(field);
    }

    @Nullable
    public Class<?> getFieldType(@Nonnull String name) {
        Object field = this.getField(name);
        if (field == null) {
            return null;
        }
        return field.getClass();
    }

    @Nonnull
    public PointValues setField(@Nonnull String field, double value) {
        return this.putField(field, value);
    }

    public PointValues setField(@Nonnull String field, long value) {
        return this.putField(field, value);
    }

    @Nonnull
    public PointValues setField(@Nonnull String field, @Nullable Number value) {
        return this.putField(field, value);
    }

    @Nonnull
    public PointValues setField(@Nonnull String field, @Nullable String value) {
        return this.putField(field, value);
    }

    @Nonnull
    public PointValues setField(@Nonnull String field, boolean value) {
        return this.putField(field, value);
    }

    @Nonnull
    public PointValues setField(@Nonnull String field, @Nullable Object value) {
        return this.putField(field, value);
    }

    @Nonnull
    public PointValues setFields(@Nonnull Map<String, Object> fieldsToAdd) {
        Arguments.checkNotNull(fieldsToAdd, "fieldsToAdd");
        fieldsToAdd.forEach(this::putField);
        return this;
    }

    @Nonnull
    public PointValues removeField(@Nonnull String name) {
        this.fields.remove(name);
        return this;
    }

    @Nonnull
    public String[] getFieldNames() {
        return this.fields.keySet().toArray(new String[0]);
    }

    public boolean hasFields() {
        return !this.fields.isEmpty();
    }

    @Nonnull
    public PointValues copy() {
        PointValues copy = new PointValues();
        copy.name = this.name;
        copy.tags.putAll(this.tags);
        copy.fields.putAll(this.fields);
        copy.time = this.time;
        return copy;
    }

    @Nonnull
    public Point asPoint(@Nonnull String measurement) {
        this.setMeasurement(measurement);
        try {
            return this.asPoint();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public Point asPoint() throws Exception {
        return Point.fromValues(this);
    }

    @Nonnull
    private PointValues putField(@Nonnull String field, @Nullable Object value) {
        Arguments.checkNonEmpty(field, "fieldName");
        this.fields.put(field, value);
        return this;
    }
}

