/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.flight.grpc;

import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.flight.CallInfo;
import org.apache.arrow.flight.CallStatus;
import org.apache.arrow.flight.FlightClientMiddleware;
import org.apache.arrow.flight.FlightMethod;
import org.apache.arrow.flight.FlightRuntimeException;
import org.apache.arrow.flight.FlightStatusCode;
import org.apache.arrow.flight.grpc.MetadataAdapter;
import org.apache.arrow.flight.grpc.StatusUtils;

public class ClientInterceptorAdapter
implements ClientInterceptor {
    private final List<FlightClientMiddleware.Factory> factories;

    public ClientInterceptorAdapter(List<FlightClientMiddleware.Factory> factories) {
        this.factories = factories;
    }

    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        ArrayList<FlightClientMiddleware> middleware = new ArrayList<FlightClientMiddleware>();
        CallInfo info = new CallInfo(FlightMethod.fromProtocol(method.getFullMethodName()));
        try {
            for (FlightClientMiddleware.Factory factory : this.factories) {
                middleware.add(factory.onCallStarted(info));
            }
        }
        catch (FlightRuntimeException e) {
            throw e;
        }
        catch (StatusRuntimeException e) {
            throw StatusUtils.fromGrpcRuntimeException(e);
        }
        catch (RuntimeException e) {
            throw StatusUtils.fromThrowable(e);
        }
        return new FlightClientCall(next.newCall(method, callOptions), middleware);
    }

    private static class FlightClientCall<ReqT, RespT>
    extends ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT> {
        private final List<FlightClientMiddleware> middleware;

        public FlightClientCall(ClientCall<ReqT, RespT> clientCall, List<FlightClientMiddleware> middleware) {
            super(clientCall);
            this.middleware = middleware;
        }

        public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
            MetadataAdapter metadataAdapter = new MetadataAdapter(headers);
            this.middleware.forEach(m -> m.onBeforeSendingHeaders(metadataAdapter));
            super.start(new FlightClientCallListener<RespT>(responseListener, this.middleware), headers);
        }

        public void cancel(String message, Throwable cause) {
            CallStatus flightStatus = new CallStatus(FlightStatusCode.CANCELLED, cause, message, null);
            this.middleware.forEach(m -> m.onCallCompleted(flightStatus));
            super.cancel(message, cause);
        }
    }

    private static class FlightClientCallListener<RespT>
    extends ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT> {
        private final List<FlightClientMiddleware> middleware;
        boolean receivedHeaders;

        public FlightClientCallListener(ClientCall.Listener<RespT> responseListener, List<FlightClientMiddleware> middleware) {
            super(responseListener);
            this.middleware = middleware;
            this.receivedHeaders = false;
        }

        public void onHeaders(Metadata headers) {
            this.receivedHeaders = true;
            MetadataAdapter adapter = new MetadataAdapter(headers);
            try {
                this.middleware.forEach(m -> m.onHeadersReceived(adapter));
            }
            finally {
                super.onHeaders(headers);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onClose(Status status, Metadata trailers) {
            try {
                if (!this.receivedHeaders) {
                    MetadataAdapter adapter = new MetadataAdapter(trailers);
                    this.middleware.forEach(m -> m.onHeadersReceived(adapter));
                }
                CallStatus flightStatus = StatusUtils.fromGrpcStatusAndTrailers(status, trailers);
                this.middleware.forEach(m -> m.onCallCompleted(flightStatus));
            }
            finally {
                super.onClose(status, trailers);
            }
        }
    }
}

