/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.connectors.influxv3;

import com.influxdb.v3.client.InfluxDBClient;
import com.influxdb.v3.client.Point;
import com.influxdb.v3.client.PointValues;
import com.influxdb.v3.client.query.QueryOptions;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.events.ConnectorTriggerQuery;
import de.iip_ecosphere.platform.connectors.events.SimpleTimeseriesQuery;
import de.iip_ecosphere.platform.connectors.influxv3.InfluxConnector;
import de.iip_ecosphere.platform.connectors.model.ModelAccess;
import de.iip_ecosphere.platform.connectors.types.ConnectorInputTypeTranslator;
import de.iip_ecosphere.platform.connectors.types.ConnectorOutputTypeTranslator;
import de.iip_ecosphere.platform.connectors.types.ProtocolAdapter;
import de.iip_ecosphere.platform.connectors.types.TranslatingProtocolAdapter;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.identities.IdentityToken;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import test.de.iip_ecosphere.platform.connectors.MachineCommand;
import test.de.iip_ecosphere.platform.connectors.MachineCommandInputTranslator;
import test.de.iip_ecosphere.platform.connectors.MachineData;
import test.de.iip_ecosphere.platform.connectors.MachineDataOutputTranslator;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={InfluxDBClient.class})
public class InfluxConnectorTest {
    private Point written = null;
    private List<MachineData> expectedData = new ArrayList<MachineData>();

    public InfluxConnectorTest() {
        this.expectedData.add(new MachineData(1, 1.24, "DMG"));
        this.expectedData.add(new MachineData(5, 3.12, "Fanuc"));
        this.expectedData.add(new MachineData(2, 0.72, "Kuka"));
    }

    private Stream<PointValues> getDataTable() {
        ArrayList<PointValues> result = new ArrayList<PointValues>();
        Instant now = Instant.now();
        for (MachineData d : this.expectedData) {
            PointValues record = new PointValues();
            record.setTimestamp(now);
            record.setField("start", (Object)now);
            record.setField("stop", (Object)now);
            record.setField("lotSize", (long)d.getLotSize());
            record.setField("powerConsumption", d.getPowerConsumption());
            record.setField("vendor", d.getVendor());
            now = now.plus(500L, ChronoUnit.MILLIS);
            result.add(record);
        }
        return result.stream();
    }

    private MachineCommand toMachineCommand(Point point) {
        MachineCommand result = new MachineCommand();
        result.setStart(point.getBooleanField("start").booleanValue());
        result.setStop(point.getBooleanField("stop").booleanValue());
        result.setLotSize(this.toInt(point, "lotSize", -1));
        return result;
    }

    private int toInt(Point point, String field, int dflt) {
        int result = dflt;
        Long object = point.getIntegerField(field);
        if (object != null) {
            result = object.intValue();
        }
        return result;
    }

    @Test
    public void testInfluxConnector() throws Exception {
        ActiveAasBase.NotificationMode mode = ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)ActiveAasBase.NotificationMode.NONE);
        final ArrayList received = new ArrayList();
        MyCustomizer customizer = new MyCustomizer();
        PowerMockito.mockStatic(InfluxDBClient.class, (Class[])new Class[0]);
        InfluxDBClient dbClientMock = (InfluxDBClient)PowerMockito.mock(InfluxDBClient.class);
        PowerMockito.when((Object)dbClientMock.queryPoints(Mockito.anyString(), (QueryOptions)Mockito.any(QueryOptions.class))).thenReturn(this.getDataTable());
        ((InfluxDBClient)PowerMockito.doAnswer(in -> {
            this.written = (Point)in.getArgument(0, Point.class);
            return null;
        }).doNothing().when((Object)dbClientMock)).writePoint((Point)Mockito.any(Point.class));
        ((InfluxDBClient)PowerMockito.doAnswer(in -> {
            this.written = (Point)in.getArgument(0, Point.class);
            return null;
        }).doNothing().when((Object)dbClientMock)).writePoints(Mockito.anyList());
        ((InfluxDBClient)PowerMockito.doNothing().when((Object)dbClientMock)).close();
        PowerMockito.when((Object)InfluxDBClient.getInstance((String)Mockito.anyString(), (char[])((char[])Mockito.any(char[].class)), (String)Mockito.anyString())).thenReturn((Object)dbClientMock);
        InfluxConnector conn = new InfluxConnector(new ProtocolAdapter[]{new TranslatingProtocolAdapter((ConnectorOutputTypeTranslator)new MachineDataOutputTranslator(false, Object.class, (MachineDataOutputTranslator.OutputCustomizer)customizer), (ConnectorInputTypeTranslator)new MachineCommandInputTranslator(Object.class, (MachineCommandInputTranslator.InputCustomizer)customizer))});
        HashMap<String, IdentityToken> identities = new HashMap<String, IdentityToken>();
        byte[] token = "MyToken".getBytes();
        identities.put("", IdentityToken.IdentityTokenBuilder.newBuilder().setIssuedToken(token, "plain").build());
        ConnectorParameter param = ConnectorParameter.ConnectorParameterBuilder.newBuilder((String)"localhost", (int)1234, (Schema)Schema.HTTP).setSpecificSetting("DATABASE", (Object)"myDatabase").setSpecificSetting("MEASUREMENT", (Object)"machineData").setSpecificSetting("TAGS", (Object)"").setSpecificSetting("BATCH", (Object)"1").setIdentities(identities).build();
        conn.connect(param);
        conn.setReceptionCallback((ReceptionCallback)new ReceptionCallback<MachineData>(){

            public void received(MachineData data) {
                received.add(data);
            }

            public Class<MachineData> getType() {
                return MachineData.class;
            }
        });
        MachineCommand cmd = new MachineCommand();
        cmd.setStart(true);
        cmd.setLotSize(4);
        conn.write((Object)cmd);
        SimpleTimeseriesQuery q = new SimpleTimeseriesQuery(0, SimpleTimeseriesQuery.TimeKind.ABSOLUTE, -1, SimpleTimeseriesQuery.TimeKind.UNSPECIFIED);
        conn.trigger((ConnectorTriggerQuery)q);
        TimeUtils.sleep((int)3000);
        conn.disconnect();
        ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)mode);
        Assert.assertNotNull((Object)this.written);
        Assert.assertEquals((Object)cmd, (Object)this.toMachineCommand(this.written));
        Assert.assertEquals((long)this.expectedData.size(), (long)received.size());
        Assert.assertEquals(this.expectedData, received);
    }

    private class MyCustomizer
    implements MachineDataOutputTranslator.OutputCustomizer,
    MachineCommandInputTranslator.InputCustomizer {
        private MyCustomizer() {
        }

        public String getQNameOperationStartMachine() {
            return null;
        }

        public String getQNameOperationStopMachine() {
            return null;
        }

        public void additionalFromActions(ModelAccess access, MachineCommand data) throws IOException {
        }

        public void initializeModelAccess(ModelAccess access, boolean withNotifications) throws IOException {
        }

        public String getVendor(ModelAccess access) throws IOException {
            return access.getString("vendor");
        }

        public String getTopLevelModelPartName() {
            return "";
        }

        public String getQNameVarLotSize() {
            return "lotSize";
        }

        public String getQNameVarPowerConsumption() {
            return "powerConsumption";
        }

        public boolean assertSetExceptions() {
            return false;
        }

        public boolean assertOperationExceptions() {
            return false;
        }

        public String getQNameStart() {
            return "start";
        }

        public String getQNameStop() {
            return "stop";
        }

        public boolean assertNotExistingProperties() {
            return false;
        }
    }
}

