/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.v3.client.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.influxdb.v3.client.config.ClientConfig;
import com.influxdb.v3.client.internal.Arguments;
import com.influxdb.v3.client.internal.GrpcCallOptions;
import com.influxdb.v3.client.internal.Identity;
import com.influxdb.v3.client.query.QueryType;
import io.grpc.Codec;
import io.grpc.Decompressor;
import io.grpc.DecompressorRegistry;
import io.grpc.HttpConnectProxiedSocketAddress;
import io.grpc.ManagedChannel;
import io.grpc.Metadata;
import io.grpc.ProxyDetector;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.arrow.flight.CallHeaders;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.FlightClient;
import org.apache.arrow.flight.FlightGrpcUtils;
import org.apache.arrow.flight.FlightStream;
import org.apache.arrow.flight.HeaderCallOption;
import org.apache.arrow.flight.Location;
import org.apache.arrow.flight.Ticket;
import org.apache.arrow.flight.grpc.MetadataAdapter;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.util.AutoCloseables;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FlightSqlClient
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(FlightSqlClient.class);
    private final FlightClient client;
    private final Map<String, String> defaultHeaders = new HashMap<String, String>();
    private final ObjectMapper objectMapper = new ObjectMapper();

    FlightSqlClient(@Nonnull ClientConfig config) {
        this(config, null);
    }

    FlightSqlClient(@Nonnull ClientConfig config, @Nullable FlightClient client) {
        Arguments.checkNotNull(config, "config");
        if (config.getToken() != null && config.getToken().length > 0) {
            this.defaultHeaders.put("Authorization", "Bearer " + new String(config.getToken()));
        }
        if (config.getHeaders() != null) {
            this.defaultHeaders.putAll(config.getHeaders());
        }
        this.client = client != null ? client : this.createFlightClient(config);
    }

    @Nonnull
    Stream<VectorSchemaRoot> execute(final @Nonnull String query, final @Nonnull String database, final @Nonnull QueryType queryType, @Nonnull Map<String, Object> queryParameters, @Nonnull Map<String, String> headers, CallOption ... callOptions) {
        String json;
        HashMap<String, Object> ticketData = new HashMap<String, Object>(){
            {
                this.put("database", database);
                this.put("sql_query", query);
                this.put("query_type", queryType.name().toLowerCase());
            }
        };
        if (!queryParameters.isEmpty()) {
            ticketData.put("params", queryParameters);
        }
        try {
            json = this.objectMapper.writeValueAsString((Object)ticketData);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        HeaderCallOption headerCallOption = this.metadataHeader(headers);
        CallOption[] callOptionArray = GrpcCallOptions.mergeCallOptions(callOptions, new CallOption[]{headerCallOption});
        Ticket ticket = new Ticket(json.getBytes(StandardCharsets.UTF_8));
        FlightStream stream = this.client.getStream(ticket, callOptionArray);
        FlightSqlIterator iterator = new FlightSqlIterator(stream);
        Spliterator<VectorSchemaRoot> spliterator = Spliterators.spliteratorUnknownSize(iterator, 256);
        return (Stream)StreamSupport.stream(spliterator, false).onClose(iterator::close);
    }

    @Override
    public void close() throws Exception {
        this.client.close();
    }

    @Nonnull
    private FlightClient createFlightClient(@Nonnull ClientConfig config) {
        URI uri = this.createLocation(config).getUri();
        NettyChannelBuilder nettyChannelBuilder = NettyChannelBuilder.forAddress((String)uri.getHost(), (int)uri.getPort());
        nettyChannelBuilder.userAgent(Identity.getUserAgent());
        if ("grpc+tls".equals(uri.getScheme())) {
            nettyChannelBuilder.useTransportSecurity();
            SslContext nettySslContext = this.createNettySslContext(config);
            nettyChannelBuilder.sslContext(nettySslContext);
        } else {
            nettyChannelBuilder.usePlaintext();
        }
        if (config.getProxyUrl() != null) {
            ProxyDetector proxyDetector = this.createProxyDetector(config.getHost(), config.getProxyUrl());
            nettyChannelBuilder.proxyDetector(proxyDetector);
        }
        if (config.getProxy() != null) {
            LOG.warn("proxy property in ClientConfig will not work in query api, use proxyUrl property instead");
        }
        ((NettyChannelBuilder)nettyChannelBuilder.maxTraceEvents(0)).maxInboundMetadataSize(Integer.MAX_VALUE);
        if (config.getDisableGRPCCompression()) {
            nettyChannelBuilder.decompressorRegistry(DecompressorRegistry.emptyInstance().with((Decompressor)Codec.Identity.NONE, false));
        }
        return FlightGrpcUtils.createFlightClient((BufferAllocator)new RootAllocator(Long.MAX_VALUE), (ManagedChannel)nettyChannelBuilder.build());
    }

    @Nonnull
    SslContext createNettySslContext(@Nonnull ClientConfig config) {
        try {
            SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient();
            if (config.getDisableServerCertificateValidation().booleanValue()) {
                sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
            } else if (config.sslRootsFilePath() != null) {
                try (FileInputStream fileInputStream = new FileInputStream(config.sslRootsFilePath());){
                    sslContextBuilder.trustManager((InputStream)fileInputStream);
                }
            }
            return sslContextBuilder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    private Location createLocation(@Nonnull ClientConfig config) {
        try {
            URI uri = new URI(config.getHost());
            if ("https".equals(uri.getScheme())) {
                return Location.forGrpcTls((String)uri.getHost(), (int)(uri.getPort() != -1 ? uri.getPort() : 443));
            }
            return Location.forGrpcInsecure((String)uri.getHost(), (int)(uri.getPort() != -1 ? uri.getPort() : 80));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    private HeaderCallOption metadataHeader(@Nonnull Map<String, String> requestHeaders) {
        MetadataAdapter metadata = new MetadataAdapter(new Metadata());
        for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
            metadata.insert(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.defaultHeaders.entrySet()) {
            if (metadata.containsKey(entry.getKey())) continue;
            metadata.insert(entry.getKey(), entry.getValue());
        }
        return new HeaderCallOption((CallHeaders)metadata);
    }

    ProxyDetector createProxyDetector(@Nonnull String targetUrl, @Nonnull String proxyUrl) {
        URI targetUri = URI.create(targetUrl);
        URI proxyUri = URI.create(proxyUrl);
        return targetServerAddress -> {
            InetSocketAddress targetAddress = (InetSocketAddress)targetServerAddress;
            if (targetUri.getHost().equals(targetAddress.getHostString()) && targetUri.getPort() == targetAddress.getPort()) {
                return HttpConnectProxiedSocketAddress.newBuilder().setProxyAddress((SocketAddress)new InetSocketAddress(proxyUri.getHost(), proxyUri.getPort())).setTargetAddress(targetAddress).build();
            }
            return null;
        };
    }

    private static final class FlightSqlIterator
    implements Iterator<VectorSchemaRoot>,
    AutoCloseable {
        private final List<AutoCloseable> autoCloseable = new ArrayList<AutoCloseable>();
        private final FlightStream flightStream;

        private FlightSqlIterator(@Nonnull FlightStream flightStream) {
            this.flightStream = flightStream;
        }

        @Override
        public boolean hasNext() {
            return this.flightStream.next();
        }

        @Override
        public VectorSchemaRoot next() {
            if (this.flightStream.getRoot() == null) {
                throw new NoSuchElementException();
            }
            this.autoCloseable.add((AutoCloseable)this.flightStream.getRoot());
            return this.flightStream.getRoot();
        }

        @Override
        public void close() {
            Exception pendingException = null;
            try {
                this.flightStream.close();
            }
            catch (Exception e) {
                LOG.warn("FlightStream close failed: {}", (Object)e.toString());
                pendingException = e;
                try {
                    this.flightStream.close();
                    pendingException = null;
                }
                catch (Exception retryException) {
                    LOG.error("FlightStream close failed even after retry attempt", (Throwable)retryException);
                }
            }
            try {
                AutoCloseables.close(this.autoCloseable);
            }
            catch (Exception e) {
                LOG.error("AutoCloseable close failed", (Throwable)e);
                if (pendingException != null) {
                    pendingException.addSuppressed(e);
                }
                pendingException = e;
            }
            if (pendingException != null) {
                throw new RuntimeException(pendingException);
            }
        }
    }
}

