/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.v3.client.internal;

import io.grpc.Deadline;
import io.grpc.stub.AbstractStub;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.flight.CallOptions;

public final class GrpcCallOptions {
    private final Deadline deadline;
    private final Executor executor;
    private final String compressorName;
    private final Boolean waitForReady;
    private final Integer maxInboundMessageSize;
    private final Integer maxOutboundMessageSize;
    private final CallOption[] callOptions;

    private GrpcCallOptions(@Nonnull Builder builder) {
        this.deadline = builder.deadline;
        this.executor = builder.executor;
        this.compressorName = builder.compressorName;
        this.waitForReady = builder.waitForReady;
        this.maxInboundMessageSize = builder.maxInboundMessageSize;
        this.maxOutboundMessageSize = builder.maxOutboundMessageSize;
        this.callOptions = builder.callOptions.toArray(new CallOption[0]);
    }

    @Nonnull
    public static GrpcCallOptions getDefaultOptions() {
        Builder builder = new Builder();
        return builder.build();
    }

    public static CallOption[] mergeCallOptions(@Nullable CallOption[] baseCallOptions, CallOption ... callOptions) {
        CallOption[] base = baseCallOptions != null ? baseCallOptions : new CallOption[]{};
        CallOption[] additional = callOptions != null ? callOptions : new CallOption[]{};
        CallOption[] merged = new CallOption[base.length + additional.length];
        System.arraycopy(base, 0, merged, 0, base.length);
        System.arraycopy(additional, 0, merged, base.length, additional.length);
        return merged;
    }

    @Nullable
    public Deadline getDeadline() {
        return this.deadline;
    }

    @Nullable
    public Executor getExecutor() {
        return this.executor;
    }

    @Nullable
    public String getCompressorName() {
        return this.compressorName;
    }

    @Nullable
    public Boolean getWaitForReady() {
        return this.waitForReady;
    }

    @Nullable
    public Integer getMaxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    @Nullable
    public Integer getMaxOutboundMessageSize() {
        return this.maxOutboundMessageSize;
    }

    @Nonnull
    public CallOption[] getCallOptions() {
        return this.callOptions;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GrpcCallOptions that = (GrpcCallOptions)o;
        return Objects.equals(this.deadline, that.deadline) && Objects.equals(this.executor, that.executor) && Objects.equals(this.compressorName, that.compressorName) && Objects.equals(this.waitForReady, that.waitForReady) && Objects.equals(this.maxInboundMessageSize, that.maxInboundMessageSize) && Objects.equals(this.maxOutboundMessageSize, that.maxOutboundMessageSize);
    }

    public int hashCode() {
        return Objects.hash(this.deadline, this.executor, this.compressorName, this.waitForReady, this.maxInboundMessageSize, this.maxOutboundMessageSize);
    }

    public String toString() {
        return "GrpcCallOptions{deadline=" + this.deadline + ", executor=" + this.executor + ", compressorName='" + this.compressorName + "', waitForReady=" + this.waitForReady + ", maxInboundMessageSize=" + this.maxInboundMessageSize + ", maxOutboundMessageSize=" + this.maxOutboundMessageSize + "}";
    }

    public static final class Builder {
        private Deadline deadline;
        private Executor executor;
        private String compressorName;
        private Boolean waitForReady;
        private Integer maxInboundMessageSize;
        private Integer maxOutboundMessageSize;
        private final List<CallOption> callOptions = new ArrayList<CallOption>();

        public Builder() {
            this.maxInboundMessageSize = Integer.MAX_VALUE;
        }

        public Builder withDeadline(@Nonnull Deadline deadline) {
            this.deadline = deadline;
            return this;
        }

        public Builder withoutDeadline() {
            this.deadline = null;
            return this;
        }

        public Builder withExecutor(@Nonnull Executor executor) {
            this.executor = executor;
            return this;
        }

        public Builder withCompressorName(@Nonnull String compressorName) {
            this.compressorName = compressorName;
            return this;
        }

        public Builder withWaitForReady() {
            this.waitForReady = true;
            return this;
        }

        public Builder withMaxInboundMessageSize(@Nonnull Integer maxInboundMessageSize) {
            this.maxInboundMessageSize = maxInboundMessageSize;
            return this;
        }

        public Builder fromGrpcCallOptions(@Nonnull GrpcCallOptions grpcCallOptions) {
            if (grpcCallOptions.getDeadline() != null) {
                this.deadline = grpcCallOptions.getDeadline();
            }
            if (grpcCallOptions.getExecutor() != null) {
                this.executor = grpcCallOptions.getExecutor();
            }
            if (grpcCallOptions.getCompressorName() != null) {
                this.compressorName = grpcCallOptions.getCompressorName();
            }
            if (grpcCallOptions.getWaitForReady() != null) {
                this.waitForReady = grpcCallOptions.getWaitForReady();
            }
            if (grpcCallOptions.getMaxInboundMessageSize() != null) {
                this.maxInboundMessageSize = grpcCallOptions.getMaxInboundMessageSize();
            }
            if (grpcCallOptions.getMaxOutboundMessageSize() != null) {
                this.maxOutboundMessageSize = grpcCallOptions.getMaxOutboundMessageSize();
            }
            return this;
        }

        public Builder withMaxOutboundMessageSize(@Nonnull Integer maxOutboundMessageSize) {
            this.maxOutboundMessageSize = maxOutboundMessageSize;
            return this;
        }

        private CallOptions.GrpcCallOption createDeadlineCallOption(final Deadline deadline) {
            return new CallOptions.GrpcCallOption(){

                public <T extends AbstractStub<T>> T wrapStub(T stub) {
                    return (T)stub.withDeadline(deadline);
                }
            };
        }

        private CallOptions.GrpcCallOption createExecutorCallOption(final Executor executor) {
            return new CallOptions.GrpcCallOption(){

                public <T extends AbstractStub<T>> T wrapStub(T stub) {
                    return (T)stub.withExecutor(executor);
                }
            };
        }

        private CallOptions.GrpcCallOption createCompressionCallOption(final String compressorName) {
            return new CallOptions.GrpcCallOption(){

                public <T extends AbstractStub<T>> T wrapStub(T stub) {
                    return (T)stub.withCompression(compressorName);
                }
            };
        }

        private CallOptions.GrpcCallOption createWaitForReadyCallOption() {
            return new CallOptions.GrpcCallOption(){

                public <T extends AbstractStub<T>> T wrapStub(T stub) {
                    return (T)stub.withWaitForReady();
                }
            };
        }

        private CallOptions.GrpcCallOption createMaxInboundMessageSizeCallOption(final Integer maxInboundMessageSize) {
            return new CallOptions.GrpcCallOption(){

                public <T extends AbstractStub<T>> T wrapStub(T stub) {
                    return (T)stub.withMaxInboundMessageSize(maxInboundMessageSize.intValue());
                }
            };
        }

        private CallOptions.GrpcCallOption createMaxOutboundMessageSizeCallOption(final Integer maxOutboundMessageSize) {
            return new CallOptions.GrpcCallOption(){

                public <T extends AbstractStub<T>> T wrapStub(T stub) {
                    return (T)stub.withMaxOutboundMessageSize(maxOutboundMessageSize.intValue());
                }
            };
        }

        public GrpcCallOptions build() {
            CallOptions.GrpcCallOption callOption;
            if (this.deadline != null) {
                callOption = this.createDeadlineCallOption(this.deadline);
                this.callOptions.add((CallOption)callOption);
            }
            if (this.executor != null) {
                callOption = this.createExecutorCallOption(this.executor);
                this.callOptions.add((CallOption)callOption);
            }
            if (this.compressorName != null) {
                callOption = this.createCompressionCallOption(this.compressorName);
                this.callOptions.add((CallOption)callOption);
            }
            if (this.waitForReady != null) {
                callOption = this.createWaitForReadyCallOption();
                this.callOptions.add((CallOption)callOption);
            }
            if (this.maxInboundMessageSize != null) {
                callOption = this.createMaxInboundMessageSizeCallOption(this.maxInboundMessageSize);
                this.callOptions.add((CallOption)callOption);
            }
            if (this.maxOutboundMessageSize != null) {
                callOption = this.createMaxOutboundMessageSizeCallOption(this.maxOutboundMessageSize);
                this.callOptions.add((CallOption)callOption);
            }
            return new GrpcCallOptions(this);
        }
    }
}

