/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.v3.client.internal;

import com.influxdb.v3.client.InfluxDBApiException;
import com.influxdb.v3.client.InfluxDBApiHttpException;
import com.influxdb.v3.client.InfluxDBClient;
import com.influxdb.v3.client.Point;
import com.influxdb.v3.client.PointValues;
import com.influxdb.v3.client.config.ClientConfig;
import com.influxdb.v3.client.internal.Arguments;
import com.influxdb.v3.client.internal.FlightSqlClient;
import com.influxdb.v3.client.internal.GrpcCallOptions;
import com.influxdb.v3.client.internal.RestClient;
import com.influxdb.v3.client.internal.VectorSchemaRootConverter;
import com.influxdb.v3.client.query.QueryOptions;
import com.influxdb.v3.client.write.WriteOptions;
import com.influxdb.v3.client.write.WritePrecision;
import com.influxdb.v3.client.write.WritePrecisionConverter;
import io.grpc.Deadline;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.arrow.flight.CallOption;
import org.apache.arrow.vector.VectorSchemaRoot;

public final class InfluxDBClientImpl
implements InfluxDBClient {
    private static final Logger LOG = Logger.getLogger(InfluxDBClientImpl.class.getName());
    private static final String DATABASE_REQUIRED_MESSAGE = "Please specify the 'Database' as a method parameter or use default configuration at 'ClientConfig.database'.";
    private static final Map<String, Object> NO_PARAMETERS = Map.of();
    private static final List<Class<?>> ALLOWED_NAMED_PARAMETER_TYPES = List.of(String.class, Integer.class, Long.class, Float.class, Double.class, Boolean.class);
    private boolean closed = false;
    private final ClientConfig config;
    private final RestClient restClient;
    private final FlightSqlClient flightSqlClient;
    private final WriteOptions emptyWriteOptions;

    public InfluxDBClientImpl(@Nonnull ClientConfig config) {
        this(config, null, null);
    }

    InfluxDBClientImpl(@Nonnull ClientConfig config, @Nullable RestClient restClient, @Nullable FlightSqlClient flightSqlClient) {
        Arguments.checkNotNull(config, "config");
        config.validate();
        this.config = config;
        this.restClient = restClient != null ? restClient : new RestClient(config);
        this.flightSqlClient = flightSqlClient != null ? flightSqlClient : new FlightSqlClient(config);
        this.emptyWriteOptions = new WriteOptions(null);
    }

    @Override
    public void writeRecord(@Nullable String record) {
        this.writeRecord(record, this.emptyWriteOptions);
    }

    @Override
    public void writeRecord(@Nullable String record, @Nonnull WriteOptions options) {
        if (record == null) {
            return;
        }
        this.writeRecords(Collections.singletonList(record), options);
    }

    @Override
    public void writeRecords(@Nonnull List<String> records) {
        this.writeRecords(records, this.emptyWriteOptions);
    }

    @Override
    public void writeRecords(@Nonnull List<String> records, @Nonnull WriteOptions options) {
        this.writeData(records, options);
    }

    @Override
    public void writePoint(@Nullable Point point) {
        this.writePoint(point, this.emptyWriteOptions);
    }

    @Override
    public void writePoint(@Nullable Point point, @Nonnull WriteOptions options) {
        if (point == null) {
            return;
        }
        this.writePoints(Collections.singletonList(point), options);
    }

    @Override
    public void writePoints(@Nonnull List<Point> points) {
        this.writePoints(points, this.emptyWriteOptions);
    }

    @Override
    public void writePoints(@Nonnull List<Point> points, @Nonnull WriteOptions options) {
        this.writeData(points, options);
    }

    @Override
    @Nonnull
    public Stream<Object[]> query(@Nonnull String query) {
        return this.query(query, NO_PARAMETERS, QueryOptions.defaultQueryOptions());
    }

    @Override
    @Nonnull
    public Stream<Object[]> query(@Nonnull String query, @Nonnull QueryOptions options) {
        return this.query(query, NO_PARAMETERS, options);
    }

    @Override
    @Nonnull
    public Stream<Object[]> query(@Nonnull String query, @Nonnull Map<String, Object> parameters) {
        return this.query(query, parameters, QueryOptions.defaultQueryOptions());
    }

    @Override
    @Nonnull
    public Stream<Object[]> query(@Nonnull String query, @Nonnull Map<String, Object> parameters, @Nonnull QueryOptions options) {
        return this.queryDataAndProcess(query, parameters, options, VectorSchemaRootConverter.INSTANCE::getArrayObjectFromVectorSchemaRoot);
    }

    @Override
    @Nonnull
    public Stream<Map<String, Object>> queryRows(@Nonnull String query) {
        return this.queryRows(query, NO_PARAMETERS, QueryOptions.defaultQueryOptions());
    }

    @Override
    @Nonnull
    public Stream<Map<String, Object>> queryRows(@Nonnull String query, @Nonnull Map<String, Object> parameters) {
        return this.queryRows(query, parameters, QueryOptions.defaultQueryOptions());
    }

    @Override
    @Nonnull
    public Stream<Map<String, Object>> queryRows(@Nonnull String query, @Nonnull QueryOptions options) {
        return this.queryRows(query, NO_PARAMETERS, options);
    }

    @Override
    @Nonnull
    public Stream<Map<String, Object>> queryRows(@Nonnull String query, @Nonnull Map<String, Object> parameters, @Nonnull QueryOptions options) {
        return this.queryDataAndProcess(query, parameters, options, VectorSchemaRootConverter.INSTANCE::getMapFromVectorSchemaRoot);
    }

    @Override
    @Nonnull
    public Stream<PointValues> queryPoints(@Nonnull String query) {
        return this.queryPoints(query, QueryOptions.defaultQueryOptions());
    }

    @Override
    @Nonnull
    public Stream<PointValues> queryPoints(@Nonnull String query, @Nonnull QueryOptions options) {
        return this.queryPoints(query, NO_PARAMETERS, options);
    }

    @Override
    @Nonnull
    public Stream<PointValues> queryPoints(@Nonnull String query, @Nonnull Map<String, Object> parameters) {
        return this.queryPoints(query, parameters, QueryOptions.defaultQueryOptions());
    }

    @Override
    @Nonnull
    public Stream<PointValues> queryPoints(@Nonnull String query, @Nonnull Map<String, Object> parameters, @Nonnull QueryOptions options) {
        return this.queryDataAndProcess(query, parameters, options, (vector, rowNumber) -> {
            List fieldVectors = vector.getFieldVectors();
            return VectorSchemaRootConverter.INSTANCE.toPointValues((int)rowNumber, fieldVectors);
        });
    }

    @Override
    @Nonnull
    public Stream<VectorSchemaRoot> queryBatches(@Nonnull String query) {
        return this.queryBatches(query, QueryOptions.defaultQueryOptions());
    }

    @Override
    @Nonnull
    public Stream<VectorSchemaRoot> queryBatches(@Nonnull String query, @Nonnull QueryOptions options) {
        return this.queryBatches(query, NO_PARAMETERS, options);
    }

    @Override
    @Nonnull
    public Stream<VectorSchemaRoot> queryBatches(@Nonnull String query, @Nonnull Map<String, Object> parameters) {
        return this.queryBatches(query, parameters, QueryOptions.defaultQueryOptions());
    }

    @Override
    @Nonnull
    public Stream<VectorSchemaRoot> queryBatches(@Nonnull String query, @Nonnull Map<String, Object> parameters, @Nonnull QueryOptions options) {
        return this.queryData(query, parameters, options);
    }

    @Override
    public String getServerVersion() {
        return this.restClient.getServerVersion();
    }

    @Override
    public void close() throws Exception {
        this.restClient.close();
        this.flightSqlClient.close();
        this.closed = true;
    }

    private <T> void writeData(@Nonnull List<T> data, @Nonnull WriteOptions options) {
        HashMap<String, String> queryParams;
        String path;
        Arguments.checkNotNull(data, "data");
        Arguments.checkNotNull(options, "options");
        if (this.closed) {
            throw new IllegalStateException("InfluxDBClient has been closed.");
        }
        final String database = options.databaseSafe(this.config);
        if (database == null || database.isEmpty()) {
            throw new IllegalStateException(DATABASE_REQUIRED_MESSAGE);
        }
        final WritePrecision precision = options.precisionSafe(this.config);
        boolean noSync = options.noSyncSafe(this.config);
        if (noSync) {
            path = "api/v3/write_lp";
            queryParams = new HashMap<String, String>(){
                {
                    this.put("org", InfluxDBClientImpl.this.config.getOrganization());
                    this.put("db", database);
                    this.put("precision", WritePrecisionConverter.toV3ApiString(precision));
                    this.put("no_sync", "true");
                }
            };
        } else {
            path = "api/v2/write";
            queryParams = new HashMap<String, String>(){
                {
                    this.put("org", InfluxDBClientImpl.this.config.getOrganization());
                    this.put("bucket", database);
                    this.put("precision", WritePrecisionConverter.toV2ApiString(precision));
                }
            };
        }
        Map<String, String> defaultTags = options.defaultTagsSafe(this.config);
        String lineProtocol = data.stream().map(item -> {
            if (item == null) {
                return null;
            }
            if (item instanceof Point) {
                for (String key : defaultTags.keySet()) {
                    ((Point)item).setTag(key, (String)defaultTags.get(key));
                }
                return ((Point)item).toLineProtocol();
            }
            return item.toString();
        }).filter(it -> it != null && !it.isEmpty()).collect(Collectors.joining("\n"));
        if (lineProtocol.isEmpty()) {
            LOG.warning("No data to write, please check your input data.");
            return;
        }
        HashMap<String, String> headers = new HashMap<String, String>(Map.of("Content-Type", "text/plain; charset=utf-8"));
        byte[] body = lineProtocol.getBytes(StandardCharsets.UTF_8);
        if (lineProtocol.length() >= options.gzipThresholdSafe(this.config)) {
            try {
                body = this.gzipData(lineProtocol.getBytes(StandardCharsets.UTF_8));
                headers.put("Content-Encoding", "gzip");
            }
            catch (IOException e) {
                throw new InfluxDBApiException(e);
            }
        }
        headers.putAll(options.headersSafe());
        try {
            this.restClient.request(path, HttpMethod.POST, body, (Map<String, String>)queryParams, headers);
        }
        catch (InfluxDBApiHttpException e) {
            if (noSync && e.statusCode() == HttpResponseStatus.METHOD_NOT_ALLOWED.code()) {
                throw new InfluxDBApiHttpException("Server doesn't support write with NoSync=true (supported by InfluxDB 3 Core/Enterprise servers only).", e.headers(), e.statusCode());
            }
            throw e;
        }
    }

    @Nonnull
    private <T> Stream<T> queryDataAndProcess(@Nonnull String query, @Nonnull Map<String, Object> parameters, @Nonnull QueryOptions options, @Nonnull BiFunction<VectorSchemaRoot, Integer, T> processor) {
        return this.queryData(query, parameters, options).flatMap(vector -> (Stream)IntStream.range(0, vector.getRowCount()).mapToObj(rowNumber -> processor.apply((VectorSchemaRoot)vector, rowNumber)).onClose(() -> ((VectorSchemaRoot)vector).close()));
    }

    @Nonnull
    private Stream<VectorSchemaRoot> queryData(@Nonnull String query, @Nonnull Map<String, Object> parameters, @Nonnull QueryOptions options) {
        Arguments.checkNonEmpty(query, "query");
        Arguments.checkNotNull(parameters, "parameters");
        Arguments.checkNotNull(options, "options");
        if (this.closed) {
            throw new IllegalStateException("InfluxDBClient has been closed.");
        }
        String database = options.databaseSafe(this.config);
        if (database == null || database.isEmpty()) {
            throw new IllegalStateException(DATABASE_REQUIRED_MESSAGE);
        }
        parameters.forEach((k, v) -> {
            if (!Objects.isNull(v) && !ALLOWED_NAMED_PARAMETER_TYPES.contains(v.getClass())) {
                throw new IllegalArgumentException(String.format("The parameter %s value has unsupported type: %s", k, v.getClass()));
            }
        });
        GrpcCallOptions.Builder builder = new GrpcCallOptions.Builder().fromGrpcCallOptions(options.grpcCallOptions());
        if (this.config.getQueryTimeout() == null) {
            if (options.grpcCallOptions().getDeadline() != null && options.grpcCallOptions().getDeadline().timeRemaining(TimeUnit.MILLISECONDS) <= 0L) {
                LOG.warning("Query timeout " + options.grpcCallOptions().getDeadline() + " is 0 or negative and will be ignored.");
                builder.withoutDeadline();
            }
        } else if (options.grpcCallOptions().getDeadline() == null) {
            builder.withDeadline(Deadline.after((long)this.config.getQueryTimeout().toMillis(), (TimeUnit)TimeUnit.MILLISECONDS));
        } else if (options.grpcCallOptions().getDeadline().timeRemaining(TimeUnit.MILLISECONDS) <= 0L) {
            LOG.warning("Query timeout " + options.grpcCallOptions().getDeadline() + " is 0 or negative. Using config.queryTimeout " + this.config.getQueryTimeout() + " instead.");
            builder.withDeadline(Deadline.after((long)this.config.getQueryTimeout().toMillis(), (TimeUnit)TimeUnit.MILLISECONDS));
        }
        CallOption[] callOptions = builder.build().getCallOptions();
        return this.flightSqlClient.execute(query, database, options.queryTypeSafe(), parameters, options.headersSafe(), callOptions);
    }

    @Nonnull
    private byte[] gzipData(@Nonnull byte[] data) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        GZIPOutputStream gzip = new GZIPOutputStream(out);
        gzip.write(data);
        gzip.close();
        return out.toByteArray();
    }
}

