/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors.opcuav1;

import de.iip_ecosphere.platform.connectors.AbstractConnector;
import de.iip_ecosphere.platform.connectors.AbstractPluginConnectorDescriptor;
import de.iip_ecosphere.platform.connectors.AdapterSelector;
import de.iip_ecosphere.platform.connectors.Connector;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.MachineConnector;
import de.iip_ecosphere.platform.connectors.events.ConnectorTriggerQuery;
import de.iip_ecosphere.platform.connectors.model.AbstractModelAccess;
import de.iip_ecosphere.platform.connectors.model.ModelAccess;
import de.iip_ecosphere.platform.connectors.model.ModelInputConverter;
import de.iip_ecosphere.platform.connectors.model.ModelOutputConverter;
import de.iip_ecosphere.platform.connectors.opcuav1.DataItem;
import de.iip_ecosphere.platform.connectors.types.ProtocolAdapter;
import de.iip_ecosphere.platform.support.Schema;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.identities.IdentityStore;
import de.iip_ecosphere.platform.support.identities.IdentityToken;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.api.config.OpcUaClientConfigBuilder;
import org.eclipse.milo.opcua.sdk.client.api.identity.AnonymousProvider;
import org.eclipse.milo.opcua.sdk.client.api.identity.IdentityProvider;
import org.eclipse.milo.opcua.sdk.client.api.identity.SignedIdentityToken;
import org.eclipse.milo.opcua.sdk.client.api.identity.UsernameProvider;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaMonitoredItem;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaSubscription;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableNode;
import org.eclipse.milo.opcua.stack.client.DiscoveryClient;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.Stack;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.DataTypeCodec;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.DataTypeEncoding;
import org.eclipse.milo.opcua.stack.core.types.OpcUaDefaultBinaryEncoding;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.ULong;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UNumber;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MonitoringMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.AnonymousIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.CallMethodRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.EventFilter;
import org.eclipse.milo.opcua.stack.core.types.structured.IssuedIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoredItemCreateRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.MonitoringParameters;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.SignatureData;
import org.eclipse.milo.opcua.stack.core.types.structured.SimpleAttributeOperand;
import org.eclipse.milo.opcua.stack.core.types.structured.UserIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.UserNameIdentityToken;
import org.eclipse.milo.opcua.stack.core.types.structured.X509IdentityToken;
import org.eclipse.milo.opcua.stack.core.util.EndpointUtil;

@MachineConnector(specificSettings={})
public class OpcUaConnector<CO, CI>
extends AbstractConnector<DataItem, Object, CO, CI> {
    public static final String NAME = "OPC UA v1";
    public static final String TOP_OBJECTS = "Objects";
    public static final String TOP_TYPES = "Types";
    public static final String TOP_VIEWS = "Views";
    public static final char SEPARATOR_CHAR = '/';
    public static final String SEPARATOR_STRING = "/";
    private static final Logger LOGGER = LoggerFactory.getLogger(OpcUaConnector.class);
    private static final DataItem DUMMY = new DataItem(null, null);
    private static final String FIELD_BINARY_ENCODING_ID = "BINARY_ENCODING_ID";
    private OpcUaClient client;
    private ConnectorParameter params;

    @SafeVarargs
    public OpcUaConnector(ProtocolAdapter<DataItem, Object, CO, CI> ... adapter) {
        this((AdapterSelector<DataItem, Object, CO, CI>)null, adapter);
    }

    @SafeVarargs
    public OpcUaConnector(AdapterSelector<DataItem, Object, CO, CI> selector, ProtocolAdapter<DataItem, Object, CO, CI> ... adapter) {
        super(selector, adapter);
        this.configureModelAccess((ModelAccess)new OpcUaModelAccess());
    }

    private DataValue createWriteDataValue(Variant value) {
        return new DataValue(value, null, null, null);
    }

    private String getEndpointUrl(ConnectorParameter params) {
        Object schema = Schema.TCP == params.getSchema() ? "opc." + params.getSchema().toUri() : params.getSchema().toUri();
        return (String)schema + params.getHost() + ":" + params.getPort() + SEPARATOR_STRING + params.getEndpointPath();
    }

    protected void connectImpl(ConnectorParameter params) throws IOException {
        if (null == this.client) {
            this.params = params;
            String endpointURL = this.getEndpointUrl(params);
            LOGGER.info("OPC UA connecting to {}", (Object)endpointURL);
            try {
                this.client = OpcUaClient.create((String)endpointURL, endpoints -> endpoints.stream().filter(this.endpointFilter(params)).findFirst(), configBuilder -> this.configure((OpcUaClientConfigBuilder)configBuilder).build());
                this.client.connect().get();
                LOGGER.info("OPC UA connected to {}", (Object)endpointURL);
            }
            catch (InterruptedException | ExecutionException | UaException e) {
                this.client = null;
                LOGGER.info("OPC UA connection failed: {}", (Object)e.getMessage());
                throw new IOException(e);
            }
        }
    }

    protected Predicate<EndpointDescription> endpointFilter(ConnectorParameter params) {
        return e -> params.isFeasibleEndpoint(e.getEndpointUrl(), e.getSecurityLevel().byteValue());
    }

    private OpcUaClientConfigBuilder configure(OpcUaClientConfigBuilder configBuilder) {
        configBuilder.setApplicationName(LocalizedText.english((String)this.params.getApplicationDescription())).setApplicationUri(this.params.getApplicationId()).setIdentityProvider(this.getIdentityProvider(this.params)).setRequestTimeout(Unsigned.uint((int)this.params.getRequestTimeout()));
        try {
            List endpoints = (List)DiscoveryClient.getEndpoints((String)this.getEndpointUrl(this.params)).get();
            EndpointDescription configEndpoint = EndpointUtil.updateUrl((EndpointDescription)((EndpointDescription)endpoints.get(0)), (String)this.params.getHost(), (int)this.params.getPort());
            LOGGER.info("Configured for security policy {}", (Object)configEndpoint.getSecurityPolicyUri());
            configBuilder.setEndpoint(configEndpoint);
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.info("Cannot adjust endpoint of {}. Staying with original.", (Object)this.getEndpointUrl(this.params));
        }
        if (OpcUaConnector.useTls((ConnectorParameter)this.params)) {
            try {
                LOGGER.info("Opening keystore via identity store key {}", (Object)this.params.getKeystoreKey());
                KeyStore keystore = IdentityStore.getInstance().getKeystoreFile(this.params.getKeystoreKey(), new String[0]);
                String alias = this.params.getKeyAlias();
                if (null == alias) {
                    try {
                        alias = keystore.aliases().nextElement();
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        // empty catch block
                    }
                }
                if (null != alias) {
                    Certificate cert = keystore.getCertificate(alias);
                    LOGGER.info("Certificate for alias {} is of type {}", (Object)alias, null == cert ? null : cert.getType() + SEPARATOR_STRING + cert.getClass().getName());
                    if (cert instanceof X509Certificate) {
                        try {
                            Key key = IdentityStore.getInstance().getKeystoreKey(this.params.getKeystoreKey(), keystore, alias, new String[0]);
                            LOGGER.info("Private key for alias {} is private key ({}) of type {}", new Object[]{alias, key instanceof PrivateKey, null == key ? null : key.getClass().getName()});
                            if (key instanceof PrivateKey) {
                                configBuilder.setKeyPair(new KeyPair(cert.getPublicKey(), (PrivateKey)key));
                            } else {
                                configBuilder.setKeyPair(new KeyPair(cert.getPublicKey(), null));
                            }
                            configBuilder.setCertificate((X509Certificate)cert);
                        }
                        catch (IOException e) {
                            LOGGER.error("Cannot read private key alias '{}': {}: Trying without TLS.", (Object)alias, (Object)e.getMessage());
                        }
                    } else {
                        LOGGER.error("Certificate for alias '{}' is not of type X509 ({}). Is keystore type supported? Trying without TLS.", (Object)alias, (Object)cert);
                    }
                } else {
                    LOGGER.error("No certificate found, no alias given. Trying without TLS.");
                }
            }
            catch (IOException | KeyStoreException e) {
                LOGGER.error("Cannot read from keystore '{}': {} Trying without TLS.", (Object)this.params.getKeystoreKey(), (Object)e.getMessage());
            }
        }
        return configBuilder;
    }

    private IdentityToken getIdToken(String endpointUrl) {
        IdentityToken idToken = this.params.getIdentityToken(endpointUrl);
        if (null == idToken) {
            idToken = this.params.getIdentityToken("");
        }
        return idToken;
    }

    protected IdentityProvider getIdentityProvider(ConnectorParameter params) {
        Object identityProvider;
        if (params.isAnonymousIdentity()) {
            identityProvider = new AnonymousProvider();
        } else {
            IdentityToken idToken = this.getIdToken(this.getEndpointUrl(params));
            if (IdentityToken.TokenType.USERNAME == idToken.getType()) {
                String pw = new String(idToken.getTokenData(), StandardCharsets.UTF_8);
                identityProvider = new UsernameProvider(idToken.getUserName(), pw);
            } else {
                identityProvider = new FallbackIdentityProder();
            }
        }
        return identityProvider;
    }

    protected void disconnectImpl() throws IOException {
        if (null != this.client) {
            try {
                this.client.disconnect().get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IOException(e);
            }
        }
    }

    public String getName() {
        return NAME;
    }

    public void dispose() {
        Stack.releaseSharedResources();
    }

    protected void writeImpl(Object data) throws IOException {
    }

    protected DataItem read() throws IOException {
        return DUMMY;
    }

    public void trigger(ConnectorTriggerQuery query) {
        if (null != query) {
            try {
                this.received("", new DataItem(query), true);
            }
            catch (IOException e) {
                LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error("Cannot trigger connector {}: {}", (Object)this.getName(), (Object)e.getMessage());
            }
        }
    }

    protected void error(String message, Throwable th) {
        LOGGER.error(message, th);
    }

    public String supportedEncryption() {
        return null;
    }

    public String enabledEncryption() {
        return null;
    }

    static {
        TimeUtils.registerConverter((TimeUtils.DateConverter)new TimeUtils.AbstractDateConverter<DateTime>(DateTime.class){

            public Date toDate(DateTime data) {
                return data.getJavaDate();
            }
        });
    }

    protected class OpcUaModelAccess
    extends AbstractModelAccess {
        private Map<String, NodeCacheEntry> nodes;
        private NodeCacheEntry base;
        private String basePath;
        private OpcUaModelAccess parent;
        private OpcInputConverter inputConverter;
        private OpcOutputConverter outputConverter;

        protected OpcUaModelAccess() {
            super((AbstractModelAccess.NotificationChangedListener)OpcUaConnector.this);
            this.inputConverter = new OpcInputConverter();
            this.outputConverter = new OpcOutputConverter();
            this.nodes = new HashMap<String, NodeCacheEntry>();
            this.basePath = "";
        }

        protected OpcUaModelAccess(NodeCacheEntry base, String basePath, OpcUaModelAccess parent, Map<String, NodeCacheEntry> nodes) {
            this();
            this.base = base;
            this.parent = parent;
            this.nodes = nodes;
            this.basePath = basePath;
        }

        public String topInstancesQName() {
            return OpcUaConnector.TOP_OBJECTS;
        }

        public String getQSeparator() {
            return OpcUaConnector.SEPARATOR_STRING;
        }

        public ModelInputConverter getInputConverter() {
            return this.inputConverter;
        }

        public ModelOutputConverter getOutputConverter() {
            return this.outputConverter;
        }

        public Object call(String qName, Object ... args) throws IOException {
            Object callResult;
            int pos = qName.lastIndexOf(47);
            if (pos > 1) {
                Variant[] a = new Variant[args.length];
                for (int i = 0; i < args.length; ++i) {
                    a[i] = new Variant(args[i]);
                }
                try {
                    String nodeName = qName.substring(0, pos);
                    UaNode node = this.retrieveCacheEntry((String)nodeName).node;
                    String methodName = qName.substring(pos + 1);
                    UaNode methodNode = this.retrieveNode(node, methodName, methodName);
                    if (null == methodNode) {
                        throw new IOException("Method " + methodName + " does not exist on " + nodeName);
                    }
                    CallMethodRequest request = new CallMethodRequest(node.getNodeId(), methodNode.getNodeId(), a);
                    Variant cr = (Variant)((CompletableFuture)OpcUaConnector.this.client.call(request).thenCompose(result -> {
                        StatusCode statusCode = result.getStatusCode();
                        if (statusCode.isGood()) {
                            Variant[] results = result.getOutputArguments();
                            Variant res = 0 == results.length ? null : result.getOutputArguments()[0];
                            return CompletableFuture.completedFuture(res);
                        }
                        CompletableFuture f = new CompletableFuture();
                        f.completeExceptionally(new UaException(statusCode));
                        return f;
                    })).get();
                    if (null != cr) {
                        callResult = cr.getValue();
                    }
                    callResult = null;
                }
                catch (InterruptedException | ExecutionException | UaException e) {
                    throw new IOException(e);
                }
            } else {
                throw new IOException("Cannot access top level operation '" + qName + "'");
            }
            return callResult;
        }

        private void browseNode(String indent, NodeId browseRoot) {
            try {
                List nodes = OpcUaConnector.this.client.getAddressSpace().browseNodes(browseRoot);
                for (UaNode node : nodes) {
                    LOGGER.info("{} Node={} Id={}", new Object[]{indent, node.getBrowseName().getName(), node.getNodeId().getIdentifier()});
                    this.browseNode(indent + "  ", node.getNodeId());
                }
            }
            catch (UaException e) {
                LOGGER.error("Browsing nodeId={} failed: {}", new Object[]{browseRoot, e.getMessage(), e});
            }
        }

        private UaVariableNode retrieveVariableNode(String qName, NodeCacheEntry entry) throws UaException, IOException {
            UaNode n;
            UaVariableNode result = null;
            UaNode uaNode = n = null == entry ? null : entry.node;
            if (!(n instanceof UaVariableNode)) {
                throw new IOException("'" + qName + "' does not point to a variable");
            }
            result = (UaVariableNode)n;
            return result;
        }

        private NodeCacheEntry retrieveCacheEntry(String qName) throws UaException, IOException {
            NodeCacheEntry cached = this.nodes.get(qName);
            boolean isNodeId = qName.contains(",");
            if (!isNodeId && null == cached && this.basePath.length() > 0) {
                cached = this.nodes.get(this.basePath + OpcUaConnector.SEPARATOR_STRING + qName);
            }
            if (null == cached) {
                UaNode result = null;
                result = isNodeId ? this.retrieveNode(qName) : (qName.contains(OpcUaConnector.SEPARATOR_STRING) ? this.retrieveNode(null == this.base ? null : this.base.node, qName, qName) : this.retrieveNode(null == this.base ? null : this.base.node, qName, this.basePath + OpcUaConnector.SEPARATOR_STRING + qName));
                if (null == result) {
                    throw new IOException("No node found for " + qName);
                }
                cached = new NodeCacheEntry(result);
            }
            return cached;
        }

        private UaNode retrieveNode(String qName) throws UaException {
            UaNode result = null;
            int pos = qName.indexOf(",");
            if (pos > 0) {
                String ns = qName.substring(0, pos);
                ns = ns.substring(ns.indexOf("=") + 2);
                String id = qName.substring(pos);
                id = id.substring(id.indexOf("=") + 2);
                NodeId nodeId = new NodeId(Integer.valueOf(ns).intValue(), Integer.valueOf(id).intValue());
                result = OpcUaConnector.this.client.getAddressSpace().getNode(nodeId);
                if (result != null && !this.nodes.containsKey(qName)) {
                    this.nodes.put(qName, new NodeCacheEntry(result));
                    List childNodes = result.browseNodes();
                    if (!childNodes.isEmpty()) {
                        this.retrieveChildsOfChildNodes(childNodes);
                    }
                }
            }
            return result;
        }

        private UaNode retrieveNode(UaNode current, String qName, String constqName) throws UaException {
            String nodeName;
            UaNode result = null;
            int pos = qName.indexOf(47);
            String remainder = null;
            if (pos > 0) {
                nodeName = qName.substring(0, pos);
                if (pos + 1 < qName.length()) {
                    remainder = qName.substring(pos + 1);
                }
            } else {
                nodeName = qName;
            }
            if ((pos = constqName.lastIndexOf(qName)) >= 0) {
                String currentPath = constqName.substring(0, pos);
                List nodes = null == current ? OpcUaConnector.this.client.getAddressSpace().browseNodes(Identifiers.RootFolder) : current.browseNodes();
                for (int n = 0; null == result && n < nodes.size(); ++n) {
                    UaNode tmp = (UaNode)nodes.get(n);
                    String nn = tmp.getBrowseName().getName();
                    String qn = currentPath + nn;
                    if (!this.nodes.containsKey(qn) && qn.contains(qName)) {
                        this.nodes.put(qn, new NodeCacheEntry(tmp));
                    }
                    if (!nodeName.equals(tmp.getBrowseName().getName())) continue;
                    if (null == remainder) {
                        List childNodes = tmp.browseNodes();
                        if (!childNodes.isEmpty()) {
                            this.retrieveChildsOfChildNodes(qn, childNodes);
                        }
                        result = tmp;
                        continue;
                    }
                    result = this.retrieveNode(tmp, remainder, constqName);
                }
            }
            return result;
        }

        public void retrieveChildsOfChildNodes(String currentPath, List<? extends UaNode> parentNodes) {
            for (UaNode uaNode : parentNodes) {
                String child = uaNode.getBrowseName().getName();
                this.nodes.put(currentPath + OpcUaConnector.SEPARATOR_STRING + child, new NodeCacheEntry(uaNode));
                try {
                    List childsOfChild;
                    if (uaNode instanceof UaVariableNode || (childsOfChild = uaNode.browseNodes()).isEmpty()) continue;
                    this.retrieveChildsOfChildNodes(currentPath + OpcUaConnector.SEPARATOR_STRING + child, childsOfChild);
                }
                catch (UaException e) {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Caching/retrieving child nodes: {}", (Object)e.getMessage());
                    e.printStackTrace();
                }
            }
        }

        private void retrieveChildsOfChildNodes(List<? extends UaNode> parentNodes) {
            for (UaNode uaNode : parentNodes) {
                UShort ns = uaNode.getNodeId().getNamespaceIndex();
                Object id = uaNode.getNodeId().getIdentifier();
                this.nodes.put("nameSpaceIndex = " + String.valueOf(ns) + ", identifier = " + String.valueOf(id), new NodeCacheEntry(uaNode));
                try {
                    List childsOfChild;
                    if (uaNode instanceof UaVariableNode || (childsOfChild = uaNode.browseNodes()).isEmpty()) continue;
                    this.retrieveChildsOfChildNodes(childsOfChild);
                }
                catch (UaException e) {
                    LoggerFactory.getLogger(((Object)((Object)this)).getClass()).warn("Caching/retrieving child nodes: {}", (Object)e.getMessage());
                }
            }
        }

        public Object get(String qName) throws IOException {
            return this.get(qName, 0);
        }

        public Object get(String qName, int lifetime) throws IOException {
            Object result;
            block20: {
                result = null;
                try {
                    NodeCacheEntry cached = this.retrieveCacheEntry(qName);
                    result = cached.getValue();
                    if (null == result) {
                        UaVariableNode node = this.retrieveVariableNode(qName, cached);
                        DataValue value = node.readValue();
                        Variant valueValue = value.getValue();
                        if (null != valueValue) {
                            result = valueValue.getValue();
                            if (result instanceof UNumber) {
                                result = ((UNumber)result).intValue();
                            } else if (result instanceof NodeId) {
                                result = result.toString();
                            }
                            cached.setValue(result, lifetime);
                        } else {
                            result = null;
                        }
                    }
                }
                catch (UaException e) {
                    throw new IOException(e);
                }
                catch (IOException e) {
                    result = DUMMY;
                    int pos = qName.lastIndexOf(47);
                    String slot = qName;
                    try {
                        UaVariableNode node;
                        DataValue value;
                        Variant valueValue;
                        Object tmp;
                        NodeCacheEntry cached;
                        String nodeName;
                        if (pos > 0) {
                            slot = qName.substring(pos + 1);
                            nodeName = qName.substring(0, pos);
                            cached = this.retrieveCacheEntry(nodeName);
                        } else {
                            cached = this.base;
                            nodeName = this.basePath;
                        }
                        Object object = tmp = null == cached ? null : cached.getValue();
                        if (null == tmp && null != (valueValue = (value = (node = this.retrieveVariableNode(nodeName, cached)).getValue()).getValue())) {
                            tmp = valueValue.getValue();
                        }
                        if (tmp instanceof LocalizedText) {
                            LocalizedText txt = (LocalizedText)tmp;
                            if (slot.equals("locale")) {
                                result = txt.getLocale();
                            } else if (slot.equals("text")) {
                                result = txt.getText();
                            }
                            if (null != result) {
                                NodeCacheEntry ent = new NodeCacheEntry();
                                ent.setValue(result, lifetime);
                                this.nodes.put(qName, ent);
                            }
                        } else {
                            cached.setValue(tmp, lifetime);
                        }
                    }
                    catch (UaException uaException) {
                        // empty catch block
                    }
                    if (DUMMY != result) break block20;
                    throw e;
                }
            }
            return result;
        }

        public void set(String qName, Object value) throws IOException {
            try {
                NodeCacheEntry cached = this.retrieveCacheEntry(qName);
                cached.setValue(value);
                UaVariableNode node = this.retrieveVariableNode(qName, cached);
                node.writeValue(OpcUaConnector.this.createWriteDataValue(new Variant(value)));
            }
            catch (UaException e) {
                throw new IOException("While setting " + qName + ":" + String.valueOf((Object)e));
            }
        }

        public <T> T getStruct(String qName, Class<T> type) throws IOException {
            try {
                NodeCacheEntry cached = this.retrieveCacheEntry(qName);
                UaVariableNode node = this.retrieveVariableNode(qName, cached);
                DataValue value = node.readValue();
                Variant variant = value.getValue();
                ExtensionObject xo = (ExtensionObject)variant.getValue();
                T decoded = type.cast(xo.decode(OpcUaConnector.this.client.getDynamicSerializationContext()));
                return decoded;
            }
            catch (UaException e) {
                throw new IOException(e);
            }
        }

        public void setStruct(String qName, Object value) throws IOException {
            try {
                ExpandedNodeId encodingId = this.getEncodingId(value.getClass());
                NodeCacheEntry cached = this.retrieveCacheEntry(qName);
                UaVariableNode node = this.retrieveVariableNode(qName, cached);
                ExtensionObject modifiedXo = ExtensionObject.encode((SerializationContext)OpcUaConnector.this.client.getDynamicSerializationContext(), (Object)value, (ExpandedNodeId)encodingId, (DataTypeEncoding)OpcUaDefaultBinaryEncoding.getInstance());
                node.writeValue(new DataValue(new Variant((Object)modifiedXo)));
            }
            catch (UaException e) {
                throw new IOException(e);
            }
        }

        private ExpandedNodeId getEncodingId(Class<?> cls) throws IOException {
            ExpandedNodeId encodingId;
            try {
                Field bei = cls.getField(OpcUaConnector.FIELD_BINARY_ENCODING_ID);
                encodingId = (ExpandedNodeId)bei.get(null);
            }
            catch (ClassCastException e) {
                throw new IOException("Field BINARY_ENCODING_ID in class " + cls.getName() + " is not of type " + String.valueOf(ExpandedNodeId.class));
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new IOException("Class " + cls.getName() + " does not declare a publicly accessible static field BINARY_ENCODING_ID providing the encoding id.");
            }
            return encodingId;
        }

        public void registerCustomType(Class<?> cls) throws IOException {
            Class<?>[] declared;
            ExpandedNodeId encodingId = this.getEncodingId(cls);
            NodeId binaryEncodingId = (NodeId)encodingId.toNodeId(OpcUaConnector.this.client.getNamespaceTable()).orElseThrow(() -> new IOException("Client namespace not found"));
            GenericDataTypeCodec codec = null;
            for (Class<?> cl : declared = cls.getDeclaredClasses()) {
                if (!cl.getSimpleName().equals("Codec") || !GenericDataTypeCodec.class.isAssignableFrom(cl)) continue;
                try {
                    codec = (GenericDataTypeCodec)cl.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (NoSuchMethodException e) {
                    throw new IOException("Cannot instantiate codec in " + cls.getName() + ": No accessible no-arg constructor declared");
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    throw new IOException("Cannot instantiate codec in " + cls.getName() + ": " + e.getMessage(), e);
                }
            }
            if (null == codec) {
                throw new IOException("No inner class Codec extending " + String.valueOf(GenericDataTypeCodec.class) + " found in " + cls.getName());
            }
            OpcUaConnector.this.client.getDynamicDataTypeManager().registerCodec(binaryEncodingId, (DataTypeCodec)codec.asBinaryCodec());
        }

        public ConnectorParameter getConnectorParameter() {
            return OpcUaConnector.this.params;
        }

        public void monitor(int notificationInterval, String ... qName) throws IOException {
            try {
                UaSubscription subscription = (UaSubscription)OpcUaConnector.this.client.getSubscriptionManager().createSubscription((double)notificationInterval).get();
                UInteger clientHandle = subscription.nextClientHandle();
                MonitoringParameters parameters = new MonitoringParameters(clientHandle, Double.valueOf(OpcUaConnector.this.params.getNotificationInterval()), null, Unsigned.uint((int)10), Boolean.valueOf(true));
                ArrayList<MonitoredItemCreateRequest> requests = new ArrayList<MonitoredItemCreateRequest>();
                for (String n : qName) {
                    UaNode node = this.retrieveCacheEntry((String)n).node;
                    ReadValueId readValueId = new ReadValueId(node.getNodeId(), AttributeId.Value.uid(), null, QualifiedName.NULL_VALUE);
                    MonitoredItemCreateRequest request = new MonitoredItemCreateRequest(readValueId, MonitoringMode.Reporting, parameters);
                    requests.add(request);
                }
                UaSubscription.ItemCreationCallback onItemCreated = (item, id) -> item.setValueConsumer(this::onSubscriptionValue);
                List items = (List)subscription.createMonitoredItems(TimestampsToReturn.Both, requests, onItemCreated).get();
                for (UaMonitoredItem item2 : items) {
                    if (item2.getStatusCode().isGood()) {
                        LOGGER.info("Monitoring for nodeId={} activated", (Object)item2.getReadValueId().getNodeId());
                        continue;
                    }
                    LOGGER.warn("Monitoring: Failed to create item for nodeId={} (status={})", (Object)item2.getReadValueId().getNodeId(), (Object)item2.getStatusCode());
                }
            }
            catch (InterruptedException | ExecutionException | UaException e) {
                throw new IOException(e);
            }
        }

        public void monitorModelChanges(int notificationInterval) throws IOException {
            try {
                UaSubscription subscription = (UaSubscription)OpcUaConnector.this.client.getSubscriptionManager().createSubscription((double)notificationInterval).get();
                UInteger clientHandle = subscription.nextClientHandle();
                EventFilter eventFilter = new EventFilter(new SimpleAttributeOperand[]{new SimpleAttributeOperand(Identifiers.BaseModelChangeEventType, new QualifiedName[]{new QualifiedName(0, "Severity")}, AttributeId.Value.uid(), null)}, new ContentFilter(null));
                MonitoringParameters parameters = new MonitoringParameters(clientHandle, Double.valueOf(OpcUaConnector.this.params.getNotificationInterval()), ExtensionObject.encode((SerializationContext)OpcUaConnector.this.client.getDynamicSerializationContext(), (UaStructure)eventFilter), Unsigned.uint((int)10), Boolean.valueOf(true));
                ArrayList<MonitoredItemCreateRequest> requests = new ArrayList<MonitoredItemCreateRequest>();
                ReadValueId readValueId = new ReadValueId(Identifiers.Server, AttributeId.EventNotifier.uid(), null, QualifiedName.NULL_VALUE);
                MonitoredItemCreateRequest request = new MonitoredItemCreateRequest(readValueId, MonitoringMode.Reporting, parameters);
                requests.add(request);
                UaSubscription.ItemCreationCallback onItemCreated = (item, id) -> item.setEventConsumer(this::onEvent);
                List items = (List)subscription.createMonitoredItems(TimestampsToReturn.Both, requests, onItemCreated).get();
                for (UaMonitoredItem item2 : items) {
                    if (item2.getStatusCode().isGood()) {
                        LOGGER.info("Monitoring for nodeId={} activated", (Object)item2.getReadValueId().getNodeId());
                        continue;
                    }
                    LOGGER.warn("Monitoring: Failed to create item for nodeId={} (status={})", (Object)item2.getReadValueId().getNodeId(), (Object)item2.getStatusCode());
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IOException(e);
            }
        }

        private void onSubscriptionValue(UaMonitoredItem item, DataValue value) {
            try {
                DataItem details;
                if (this.isDetailNotifiedItemEnabled()) {
                    Object nodeId = item.getReadValueId().getNodeId().getIdentifier();
                    details = new DataItem(nodeId, value.getValue());
                } else {
                    details = null;
                }
                OpcUaConnector.this.received("", details);
            }
            catch (IOException e) {
                LOGGER.info("While triggering reception", (Throwable)e);
            }
        }

        private void onEvent(UaMonitoredItem item, Variant[] var) {
            try {
                OpcUaConnector.this.received("", null);
            }
            catch (IOException e) {
                LOGGER.info("While triggering reception", (Throwable)e);
            }
        }

        public OpcUaModelAccess stepInto(String name) throws IOException {
            OpcUaModelAccess result = null;
            try {
                if (name.contains(",")) {
                    result = new OpcUaModelAccess(this.retrieveCacheEntry(name), null, this, this.nodes);
                } else {
                    Object tmpName = this.basePath;
                    tmpName = ((String)tmpName).length() == 0 ? name : (String)tmpName + OpcUaConnector.SEPARATOR_STRING + name;
                    result = new OpcUaModelAccess(this.retrieveCacheEntry(name), (String)tmpName, this, this.nodes);
                }
                return result;
            }
            catch (UaException e) {
                throw new IOException(e);
            }
        }

        public OpcUaModelAccess stepOut() {
            return this.parent;
        }
    }

    private class FallbackIdentityProder
    implements IdentityProvider {
        private FallbackIdentityProder() {
        }

        public SignedIdentityToken getIdentityToken(EndpointDescription endpoint, ByteString serverNonce) throws Exception {
            AnonymousIdentityToken uiToken;
            SignedIdentityToken token = null;
            IdentityToken idToken = OpcUaConnector.this.getIdToken(endpoint.getEndpointUrl());
            if (null != idToken) {
                switch (idToken.getType()) {
                    case ISSUED: {
                        uiToken = new IssuedIdentityToken(idToken.getTokenPolicyId(), new ByteString(idToken.getTokenData()), idToken.getTokenEncryptionAlgorithm());
                        break;
                    }
                    case USERNAME: {
                        uiToken = new UserNameIdentityToken(idToken.getTokenPolicyId(), idToken.getUserName(), new ByteString(idToken.getTokenData()), idToken.getTokenEncryptionAlgorithm());
                        break;
                    }
                    case X509: {
                        uiToken = new X509IdentityToken(idToken.getTokenPolicyId(), new ByteString(idToken.getTokenData()));
                        break;
                    }
                    default: {
                        uiToken = new AnonymousIdentityToken(idToken.getTokenPolicyId());
                    }
                }
            } else {
                throw new Exception("No token information configured");
            }
            token = new SignedIdentityToken((UserIdentityToken)uiToken, new SignatureData(idToken.getSignatureAlgorithm(), new ByteString(idToken.getSignature())));
            return token;
        }
    }

    private static class OpcOutputConverter
    extends ModelOutputConverter {
        private OpcOutputConverter() {
        }

        public Object fromLocalDateTime(LocalDateTime data, String format) throws IOException {
            return new DateTime((Date)this.fromDate(TimeUtils.toDate((LocalDateTime)data), format));
        }

        public Object fromLong(long data) throws IOException {
            return ULong.valueOf((long)data);
        }

        public Object fromByte(byte data) throws IOException {
            return UByte.valueOf((byte)data);
        }

        public Object fromShort(short data) throws IOException {
            return UShort.valueOf((short)data);
        }
    }

    private static class OpcInputConverter
    extends ModelInputConverter {
        private OpcInputConverter() {
        }

        public long toLong(Object data) throws IOException {
            if (data.getClass() == Long.class) {
                return (Long)data;
            }
            if (data.getClass() == Integer.class) {
                return ((Integer)data).intValue();
            }
            if (data instanceof Number) {
                return ((Number)data).longValue();
            }
            return 0L;
        }

        public byte toByte(Object data) throws IOException {
            if (data.getClass() == Byte.class) {
                return (Byte)data;
            }
            if (data instanceof Number) {
                return ((Number)data).byteValue();
            }
            return 0;
        }

        public short toShort(Object data) throws IOException {
            if (data.getClass() == Short.class) {
                return (Short)data;
            }
            if (data instanceof Number) {
                return ((Number)data).shortValue();
            }
            return 0;
        }
    }

    private static class NodeCacheEntry {
        private UaNode node;
        private long valueLifetime = 0L;
        private long valueTimestamp;
        private Object value;

        private NodeCacheEntry() {
        }

        private NodeCacheEntry(UaNode node) {
            this.node = node;
        }

        private void setValue(Object value) {
            if (this.valueLifetime != 0L) {
                this.value = value;
                this.valueTimestamp = System.currentTimeMillis();
            }
        }

        private void setValue(Object value, int lifetime) {
            this.valueLifetime = lifetime;
            this.setValue(value);
        }

        private Object getValue() {
            Object result = null;
            if (this.valueLifetime < 0L) {
                result = this.value;
            } else if (this.valueLifetime > 0L) {
                if (System.currentTimeMillis() - this.valueTimestamp < this.valueLifetime) {
                    result = this.value;
                } else {
                    this.value = null;
                }
            }
            return result;
        }
    }

    public static class Descriptor
    extends AbstractPluginConnectorDescriptor<DataItem, Object> {
        public String getName() {
            return OpcUaConnector.NAME;
        }

        public Class<?> getConnectorType() {
            return OpcUaConnector.class;
        }

        protected String initId(String id) {
            return "connector-opcua";
        }

        protected List<String> additionalIds() {
            return List.of("connector-opcua-v1");
        }

        protected <O, I, CO, CI, S extends AdapterSelector<DataItem, Object, CO, CI>, A extends ProtocolAdapter<DataItem, Object, CO, CI>> Connector<DataItem, Object, CO, CI> createConnectorImpl(S selector, Supplier<ConnectorParameter> params, A ... adapter) {
            return new OpcUaConnector(selector, (ProtocolAdapter<DataItem, Object, CO, CI>[])adapter);
        }
    }
}

