/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.connectors.opcuav1;

import com.google.common.collect.Sets;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import org.eclipse.milo.opcua.sdk.server.util.HostnameUtil;
import org.eclipse.milo.opcua.stack.core.util.SelfSignedCertificateBuilder;
import org.eclipse.milo.opcua.stack.core.util.SelfSignedCertificateGenerator;

class ServerKeystoreLoader {
    private static final Pattern IP_ADDR_PATTERN = Pattern.compile("^(([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.){3}([01]?\\d\\d?|2[0-4]\\d|25[0-5])$");
    private static final String SERVER_ALIAS = "server-ai";
    private static final char[] PASSWORD = "password".toCharArray();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private X509Certificate[] serverCertificateChain;
    private X509Certificate serverCertificate;
    private KeyPair serverKeyPair;

    ServerKeystoreLoader() {
    }

    ServerKeystoreLoader load(File baseDir) throws ExecutionException {
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            File serverKeyStore = baseDir.toPath().resolve("example-server.pfx").toFile();
            this.logger.info("Creating RSA 2048 KeyStore at {}", (Object)serverKeyStore);
            if (!serverKeyStore.exists()) {
                keyStore.load(null, PASSWORD);
                KeyPair keyPair = SelfSignedCertificateGenerator.generateRsaKeyPair((int)2048);
                String applicationUri = "urn:eclipse:milo:examples:server:" + String.valueOf(UUID.randomUUID());
                SelfSignedCertificateBuilder builder = new SelfSignedCertificateBuilder(keyPair).setCommonName("Eclipse Milo Example Server").setOrganization("digitalpetri").setOrganizationalUnit("dev").setLocalityName("Folsom").setStateName("CA").setCountryCode("US").setApplicationUri(applicationUri);
                Sets.SetView hostnames = Sets.union((Set)Sets.newHashSet((Object[])new String[]{HostnameUtil.getHostname()}), (Set)HostnameUtil.getHostnames((String)"0.0.0.0", (boolean)false));
                for (String hostname : hostnames) {
                    if (IP_ADDR_PATTERN.matcher(hostname).matches()) {
                        builder.addIpAddress(hostname);
                        continue;
                    }
                    builder.addDnsName(hostname);
                }
                X509Certificate certificate = builder.build();
                keyStore.setKeyEntry(SERVER_ALIAS, keyPair.getPrivate(), PASSWORD, new X509Certificate[]{certificate});
                keyStore.store(new FileOutputStream(serverKeyStore), PASSWORD);
            } else {
                keyStore.load(new FileInputStream(serverKeyStore), PASSWORD);
            }
            Key serverPrivateKey = keyStore.getKey(SERVER_ALIAS, PASSWORD);
            if (serverPrivateKey instanceof PrivateKey) {
                this.serverCertificate = (X509Certificate)keyStore.getCertificate(SERVER_ALIAS);
                this.serverCertificateChain = (X509Certificate[])Arrays.stream(keyStore.getCertificateChain(SERVER_ALIAS)).map(X509Certificate.class::cast).toArray(X509Certificate[]::new);
                PublicKey serverPublicKey = this.serverCertificate.getPublicKey();
                this.serverKeyPair = new KeyPair(serverPublicKey, (PrivateKey)serverPrivateKey);
            }
            return this;
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    X509Certificate getServerCertificate() {
        return this.serverCertificate;
    }

    public X509Certificate[] getServerCertificateChain() {
        return this.serverCertificateChain;
    }

    KeyPair getServerKeyPair() {
        return this.serverKeyPair;
    }
}

