/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.connectors.opcuav1.simpleMachineNamespace;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaSerializationException;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.StructureType;
import org.eclipse.milo.opcua.stack.core.types.structured.StructureDefinition;
import org.eclipse.milo.opcua.stack.core.types.structured.StructureDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.StructureField;
import test.de.iip_ecosphere.platform.connectors.opcuav1.DataTypeDictionaryManager;

public class VendorStruct
implements UaStructure {
    public static final String TYPE_NAME = "VendorStructType";
    public static final String TYPE_QNAME = "DataType.VendorStructType";
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse((String)String.format("nsu=%s;s=%s", "urn:eclipse:milo:hello-world", "DataType.VendorStructType"));
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse((String)String.format("nsu=%s;s=%s", "urn:eclipse:milo:hello-world", "DataType.VendorStructType.BinaryEncoding"));
    private final String vendor;
    private final UInteger year;
    private final boolean opcUa;

    public VendorStruct() {
        this(null, 0, false);
    }

    public VendorStruct(String vendor, int year, boolean opcUa) {
        this(vendor, Unsigned.uint((int)year), opcUa);
    }

    private VendorStruct(String vendor, UInteger year, boolean opcUa) {
        this.vendor = vendor;
        this.year = year;
        this.opcUa = opcUa;
    }

    public String getVendor() {
        return this.vendor;
    }

    public int getYear() {
        return this.year.intValue();
    }

    public boolean isOpcUa() {
        return this.opcUa;
    }

    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public ExpandedNodeId getXmlEncodingId() {
        return ExpandedNodeId.NULL_VALUE;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        VendorStruct that = (VendorStruct)obj;
        return this.opcUa == that.opcUa && Objects.equal((Object)this.vendor, (Object)that.vendor) && Objects.equal((Object)this.year, (Object)that.year);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.vendor, this.year, this.opcUa});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("vendor", (Object)this.vendor).add("year", (Object)this.year).add("opcUa", this.opcUa).toString();
    }

    public static void registerType(OpcUaServer server, UShort namespaceIndex, DataTypeDictionaryManager dictionaryManager) throws Exception {
        NodeId dataTypeId = TYPE_ID.toNodeIdOrThrow(server.getNamespaceTable());
        NodeId binaryEncodingId = BINARY_ENCODING_ID.toNodeIdOrThrow(server.getNamespaceTable());
        dictionaryManager.registerStructureCodec(new Codec().asBinaryCodec(), TYPE_NAME, dataTypeId, binaryEncodingId);
        StructureField[] fields = new StructureField[]{new StructureField("vendor", LocalizedText.NULL_VALUE, Identifiers.String, Integer.valueOf(-1), null, server.getConfig().getLimits().getMaxStringLength(), Boolean.valueOf(false)), new StructureField("year", LocalizedText.NULL_VALUE, Identifiers.UInt32, Integer.valueOf(-1), null, Unsigned.uint((int)0), Boolean.valueOf(false)), new StructureField("opcUa", LocalizedText.NULL_VALUE, Identifiers.Boolean, Integer.valueOf(-1), null, Unsigned.uint((int)0), Boolean.valueOf(false))};
        StructureDefinition definition = new StructureDefinition(binaryEncodingId, Identifiers.Structure, StructureType.Structure, fields);
        StructureDescription description = new StructureDescription(dataTypeId, new QualifiedName(namespaceIndex, TYPE_NAME), definition);
        dictionaryManager.registerStructureDescription(description, binaryEncodingId);
    }

    public static class Codec
    extends GenericDataTypeCodec<VendorStruct> {
        public Class<VendorStruct> getType() {
            return VendorStruct.class;
        }

        public VendorStruct decode(SerializationContext context, UaDecoder decoder) throws UaSerializationException {
            String vendor = decoder.readString("vendor");
            UInteger year = decoder.readUInt32("year");
            boolean opcUa = decoder.readBoolean("opcUa");
            return new VendorStruct(vendor, year, opcUa);
        }

        public void encode(SerializationContext context, UaEncoder encoder, VendorStruct value) throws UaSerializationException {
            encoder.writeString("vendor", value.vendor);
            encoder.writeUInt32("year", value.year);
            encoder.writeBoolean("opcUa", Boolean.valueOf(value.opcUa));
        }
    }
}

