/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors;

import de.iip_ecosphere.platform.connectors.AbstractConnector;
import de.iip_ecosphere.platform.connectors.AdapterSelector;
import de.iip_ecosphere.platform.connectors.ChannelAdapterSelector;
import de.iip_ecosphere.platform.connectors.types.ChannelProtocolAdapter;
import de.iip_ecosphere.platform.connectors.types.ProtocolAdapter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractChannelConnector<O, I, CO, CI>
extends AbstractConnector<O, I, CO, CI> {
    private String[] outputChannels;
    private ChannelAdapterSelector<O, I, CO, CI> selector = (ChannelAdapterSelector)super.getSelector();

    @SafeVarargs
    protected AbstractChannelConnector(ChannelProtocolAdapter<O, I, CO, CI> ... adapter) {
        this((ChannelAdapterSelector<O, I, CO, CI>)null, adapter);
    }

    @SafeVarargs
    protected AbstractChannelConnector(ChannelAdapterSelector<O, I, CO, CI> selector, ChannelProtocolAdapter<O, I, CO, CI> ... adapter) {
        super(AbstractChannelConnector.ensureAdapterSelector(selector), adapter);
        this.outputChannels = new String[adapter.length];
        for (int a = 0; a < adapter.length; ++a) {
            this.outputChannels[a] = adapter[a].getOutputChannel();
        }
    }

    private static <O, I, CO, CI> ChannelAdapterSelector<O, I, CO, CI> ensureAdapterSelector(ChannelAdapterSelector<O, I, CO, CI> selector) {
        ChannelAdapterSelector result = selector;
        if (null == result) {
            result = new ChannelAdapterSelector<O, I, CO, CI>(){
                private Map<String, ChannelProtocolAdapter<O, I, CO, CI>> channelProvider = new HashMap();
                private ChannelProtocolAdapter<O, I, CO, CI> fallback;

                @Override
                public ChannelProtocolAdapter<O, I, CO, CI> selectSouthOutput(String channel, O data) {
                    ChannelProtocolAdapter result = this.channelProvider.get(channel);
                    if (null == result) {
                        result = this.fallback;
                    }
                    return result;
                }

                @Override
                public ChannelProtocolAdapter<O, I, CO, CI> selectNorthInput(CI data) {
                    return this.fallback;
                }

                @Override
                public void init(ChannelAdapterSelector.ChannelAdapterProvider<O, I, CO, CI> provider) {
                    this.fallback = provider.getAdapter(0);
                    int size = provider.getAdapterCount();
                    for (int i = 0; i < size; ++i) {
                        ProtocolAdapter tmp = provider.getAdapter(i);
                        String outChannel = tmp.getOutputChannel();
                        if (this.channelProvider.containsKey(outChannel)) continue;
                        this.channelProvider.put(outChannel, (ChannelProtocolAdapter)tmp);
                    }
                }
            };
        }
        return result;
    }

    @Override
    protected void initSelector(AdapterSelector<O, I, CO, CI> selector) {
        selector.init(new ChannelAdapterProvider());
    }

    @Override
    protected ChannelAdapterSelector<O, I, CO, CI> getSelector() {
        return this.selector;
    }

    @Override
    public CO request(String channel, boolean notifyCallback) throws IOException {
        return super.request(channel, notifyCallback);
    }

    @Override
    public void write(CI data) throws IOException {
        ProtocolAdapter adapter = this.selector.selectNorthInput((Object)data);
        this.writeImpl(adapter.adaptInput(data), adapter.getInputChannel());
    }

    @Override
    protected final void writeImpl(I data) throws IOException {
    }

    protected abstract void writeImpl(I var1, String var2) throws IOException;

    protected String[] getOutputChannels() {
        return (String[])this.outputChannels.clone();
    }

    private class ChannelAdapterProvider
    extends AbstractConnector.BasicAdapterProvider
    implements ChannelAdapterSelector.ChannelAdapterProvider<O, I, CO, CI> {
        private ChannelAdapterProvider() {
            super(AbstractChannelConnector.this);
        }

        @Override
        public ChannelProtocolAdapter<O, I, CO, CI> getAdapter(int index) {
            return (ChannelProtocolAdapter)super.getAdapter(index);
        }
    }
}

