/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors;

import de.iip_ecosphere.platform.support.Builder;
import java.io.PrintStream;
import java.util.List;
import java.util.function.Function;

public class ConnectorField {
    private String name;
    private String path;
    private String nativeType;
    private String nativeId;

    private ConnectorField() {
    }

    public static ConnectorFieldBuilder builder(String name) {
        return new ConnectorFieldBuilder(name);
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getNativeType() {
        return this.nativeType;
    }

    public String getNativeId() {
        return this.nativeId;
    }

    public static void printFields(List<ConnectorField> fields, PrintStream out) {
        ConnectorField.printFields(fields, f -> "- " + f.getPath() + ", " + f.getNativeType() + ", " + f.getNativeId(), out);
    }

    public static void printFields(List<ConnectorField> fields, Function<ConnectorField, String> formatter, PrintStream out) {
        if (null != fields) {
            for (ConnectorField f : fields) {
                out.println(formatter.apply(f));
            }
        }
    }

    public static class ConnectorFieldBuilder
    implements Builder<ConnectorField> {
        private String name;
        private String path;
        private String nativeType;
        private String nativeId;

        public ConnectorFieldBuilder(String name) {
            this.name = name;
            this.path = name;
        }

        public ConnectorFieldBuilder setPath(String path) {
            this.path = path;
            return this;
        }

        public ConnectorFieldBuilder setNativeType(String nativeType) {
            this.nativeType = nativeType;
            return this;
        }

        public ConnectorFieldBuilder setNativeTypeIfNotNull(String nativeType) {
            if (null != nativeType) {
                this.setNativeType(nativeType);
            }
            return this;
        }

        public ConnectorFieldBuilder setNativeId(String nativeId) {
            this.nativeId = nativeId;
            return this;
        }

        public ConnectorField build() {
            ConnectorField result = new ConnectorField();
            result.name = this.name;
            result.path = this.path;
            result.nativeType = this.nativeType;
            result.nativeId = this.nativeId;
            return result;
        }
    }
}

