/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors.events;

import de.iip_ecosphere.platform.connectors.events.ConnectorInputHandler;
import de.iip_ecosphere.platform.connectors.events.DataTimeDifferenceProvider;
import de.iip_ecosphere.platform.support.ClassLoaderUtils;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import java.lang.reflect.InvocationTargetException;

public class ConnectorEventUtils {
    public static <T> ConnectorInputHandler<T> createInputHandlerInstance(ClassLoader loader, String className, Class<T> type) {
        ConnectorInputHandler result = null;
        try {
            Class<?> handlerClass = loader.loadClass(className);
            Object instance = handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            result = (ConnectorInputHandler)instance;
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            String loaders = ClassLoaderUtils.hierarchyToString((ClassLoader)loader);
            LoggerFactory.getLogger(ConnectorEventUtils.class).error("Cannot instantiate input handler of type '{} via {}': {} {}. Events of type {} will not be handled!", new Object[]{className, loaders, e.getClass().getSimpleName(), e.getMessage(), type.getName()});
        }
        return result;
    }

    public static <T> DataTimeDifferenceProvider<T> createDataTimeDifferenceProvider(ClassLoader loader, String className, Class<T> type) {
        DataTimeDifferenceProvider result = null;
        try {
            Class<?> handlerClass = loader.loadClass(className);
            Object instance = handlerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            result = (DataTimeDifferenceProvider)instance;
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            String loaders = ClassLoaderUtils.hierarchyToString((ClassLoader)loader);
            LoggerFactory.getLogger(ConnectorEventUtils.class).error("Cannot instantiate data time difference provider of type '{} via {}': {} {}. Data instances of type {} will not be considered!", new Object[]{className, loaders, e.getClass().getSimpleName(), e.getMessage(), type.getName()});
        }
        return result;
    }
}

