/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors.model;

import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.model.ModelAccess;
import java.io.IOException;

public abstract class AbstractModelAccess
implements ModelAccess {
    private boolean detailNotifications = false;
    private Boolean useNotifications;
    private NotificationChangedListener notificationChangedListener;

    protected AbstractModelAccess(NotificationChangedListener notificationChangedListener) {
        this.notificationChangedListener = notificationChangedListener;
    }

    protected final boolean isDetailNotifiedItemEnabled() {
        return this.detailNotifications;
    }

    @Override
    public final void setDetailNotifiedItem(boolean detail) {
        this.detailNotifications = detail;
    }

    protected final boolean useNotifications() {
        return null == this.useNotifications ? false : this.useNotifications;
    }

    @Override
    public final void useNotifications(boolean useNotifications) {
        Boolean old = this.useNotifications;
        this.useNotifications = useNotifications;
        if ((null == old || old != useNotifications) && this.notificationChangedListener != null) {
            this.notificationChangedListener.notificationsChanged(useNotifications);
        }
    }

    private String qName(String init, String ... names) {
        Object result = "";
        String sep = this.getQSeparator();
        for (int n = 0; n < names.length; ++n) {
            if (names[n].length() <= 0) continue;
            if (((String)result).length() == 0) {
                result = init;
            }
            if (((String)result).length() > 0) {
                result = (String)result + sep;
            }
            result = (String)result + names[n];
        }
        return result;
    }

    @Override
    public String qName(String ... names) {
        return this.qName("", names);
    }

    @Override
    public String iqName(String ... names) {
        return this.qName(this.topInstancesQName(), names);
    }

    @Override
    public void monitor(String ... qNames) throws IOException {
        this.monitor(this.getConnectorParameter().getNotificationInterval(), qNames);
    }

    @Override
    public void monitorModelChanges() throws IOException {
        this.monitorModelChanges(this.getConnectorParameter().getNotificationInterval());
    }

    public abstract ConnectorParameter getConnectorParameter();

    public static interface NotificationChangedListener {
        public void notificationsChanged(boolean var1);
    }
}

