/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors.parser;

import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.function.IOConsumer;
import de.iip_ecosphere.platform.transport.serialization.IipEnum;
import de.iip_ecosphere.platform.transport.serialization.QualifiedElement;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

public interface InputParser<T> {
    public static final char SEPARATOR = '.';

    public ParseResult<T> parse(byte[] var1) throws IOException;

    public InputConverter<T> getConverter();

    public static interface InputConverter<T> {
        public byte toByte(T var1) throws IOException;

        public int toInteger(T var1) throws IOException;

        public long toLong(T var1) throws IOException;

        public short toShort(T var1) throws IOException;

        public String toString(T var1) throws IOException;

        public double toDouble(T var1) throws IOException;

        public float toFloat(T var1) throws IOException;

        public BigInteger toBigInteger(T var1) throws IOException;

        public BigDecimal toBigDecimal(T var1) throws IOException;

        public boolean toBoolean(T var1) throws IOException;

        public int[] toIntegerArray(T var1) throws IOException;

        public String[] toStringArray(T var1) throws IOException;

        public double[] toDoubleArray(T var1) throws IOException;

        public byte[] toByteArray(T var1) throws IOException;

        default public Date toDate(T data, String format) throws IOException {
            return TimeUtils.parse(data, (String)format);
        }

        default public LocalDateTime toLocalDateTime(T data, String format) throws IOException {
            return TimeUtils.toLocalDateTime((Date)this.toDate(data, format));
        }

        default public <E extends Enum<E>> E toEnum(T data, Class<E> enumType) throws IOException {
            Enum result = null;
            try {
                result = IipEnum.valueByModelOrdinal(enumType, (int)this.toInteger(data));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (null == result) {
                try {
                    result = Enum.valueOf(enumType, this.toString(data));
                }
                catch (IllegalArgumentException e) {
                    throw new IOException("Cannot convert to enum " + enumType.getName() + ": " + e.getMessage());
                }
                catch (NullPointerException e) {
                    throw new IOException("Cannot convert to enum " + enumType.getName());
                }
            }
            return (E)result;
        }

        public <E> List<E> toList(T var1, Class<E> var2) throws IOException;

        public <E> List<QualifiedElement<E>> toElementList(T var1, Class<E> var2) throws IOException;

        public Object toObject(T var1) throws IOException;

        public long toLongIndex(T var1) throws IOException;

        public float toFloatIndex(T var1) throws IOException;
    }

    public static interface ParseResult<T> {
        public int getDataCount();

        public T getData(String var1, int ... var2) throws IOException;

        public void getData(IOConsumer<T> var1, String var2, int ... var3) throws IOException;

        public T getLocalData(String var1, int ... var2) throws IOException;

        public void getLocalData(IOConsumer<T> var1, String var2, int ... var3) throws IOException;

        public ParseResult<T> stepInto(String var1, int var2) throws IOException;

        public ParseResult<T> stepOut();

        public int getArraySize();

        default public String getFieldName(int ... indexes) {
            try {
                return this.getFieldName(null, indexes);
            }
            catch (IOException e) {
                return "";
            }
        }

        public String getFieldName(IOConsumer<T> var1, int ... var2) throws IOException;
    }
}

