/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.connectors;

import de.iip_ecosphere.platform.connectors.Connector;
import de.iip_ecosphere.platform.connectors.ConnectorDescriptor;
import de.iip_ecosphere.platform.connectors.ConnectorField;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.types.ProtocolAdapter;
import de.iip_ecosphere.platform.connectors.types.TranslatingProtocolAdapter;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.logging.Logger;
import de.iip_ecosphere.platform.support.logging.LoggerFactory;
import de.iip_ecosphere.platform.transport.connectors.ReceptionCallback;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import test.de.iip_ecosphere.platform.connectors.ConnectorTest;
import test.de.iip_ecosphere.platform.connectors.MachineCommand;
import test.de.iip_ecosphere.platform.connectors.MachineCommandInputTranslator;
import test.de.iip_ecosphere.platform.connectors.MachineData;
import test.de.iip_ecosphere.platform.connectors.MachineDataOutputTranslator;

public abstract class AbstractInformationModelConnectorTest<D>
implements MachineCommandInputTranslator.InputCustomizer,
MachineDataOutputTranslator.OutputCustomizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractInformationModelConnectorTest.class);
    private Class<? extends D> dataType;

    protected AbstractInformationModelConnectorTest(Class<? extends D> dataType) {
        this.dataType = dataType;
    }

    protected abstract Class<? extends ConnectorDescriptor> getConnectorDescriptor();

    protected abstract void assertAdditionalProperties(Step var1, MachineData var2);

    protected abstract void afterActions(Connector<D, Object, MachineData, MachineCommand> var1);

    protected abstract Connector<D, Object, MachineData, MachineCommand> createConnector(ProtocolAdapter<D, Object, MachineData, MachineCommand> var1);

    protected abstract ConnectorParameter getConnectorParameter();

    protected String getEnumPathToFields() {
        return "";
    }

    public void testConnector(boolean withNotifications) throws IOException {
        ConnectorTest.assertDescriptorRegistration(this.getConnectorDescriptor());
        final AtomicReference md = new AtomicReference();
        final AtomicInteger count = new AtomicInteger(0);
        Connector<D, Object, MachineData, MachineCommand> connector = this.createConnector((ProtocolAdapter<D, Object, MachineData, MachineCommand>)new TranslatingProtocolAdapter(new MachineDataOutputTranslator<D>(withNotifications, this.dataType, this), new MachineCommandInputTranslator<Object>(Object.class, this)));
        ConnectorTest.assertInstance(connector, false);
        ConnectorTest.assertConnectorProperties(connector);
        connector.setReceptionCallback((ReceptionCallback)new ReceptionCallback<MachineData>(){

            public void received(MachineData data) {
                md.set(data);
                count.incrementAndGet();
            }

            public Class<MachineData> getType() {
                return MachineData.class;
            }
        });
        connector.connect(this.getConnectorParameter());
        ConnectorTest.assertInstance(connector, true);
        LOGGER.info("Connector '" + connector.getName() + "' started");
        this.block(count, 2);
        MachineData tmp = (MachineData)md.get();
        Assert.assertNotNull((String)"We shall have received some data although the machine is not running", (Object)tmp);
        Assert.assertEquals((long)1L, (long)tmp.getLotSize());
        Assert.assertTrue((tmp.getPowerConsumption() < 1.0 ? 1 : 0) != 0);
        this.assertAdditionalProperties(Step.MACHINE_DATA_SENT, tmp);
        MachineCommand cmd = new MachineCommand();
        cmd.setStart(true);
        connector.write((Object)cmd);
        this.block(count, 3);
        tmp = (MachineData)md.get();
        Assert.assertEquals((long)1L, (long)tmp.getLotSize());
        Assert.assertTrue((tmp.getPowerConsumption() > 5.0 ? 1 : 0) != 0);
        this.assertAdditionalProperties(Step.START_COMMAND_SENT, tmp);
        cmd = new MachineCommand();
        cmd.setLotSize(5);
        connector.write((Object)cmd);
        this.block(count, 4);
        tmp = (MachineData)md.get();
        Assert.assertEquals((long)5L, (long)tmp.getLotSize());
        Assert.assertTrue((tmp.getPowerConsumption() > 5.0 ? 1 : 0) != 0);
        this.assertAdditionalProperties(Step.LOT_SIZE_CHANGED, tmp);
        cmd = new MachineCommand();
        cmd.setStop(true);
        connector.write((Object)cmd);
        this.block(count, 6);
        tmp = (MachineData)md.get();
        Assert.assertEquals((long)1L, (long)tmp.getLotSize());
        Assert.assertTrue((tmp.getPowerConsumption() < 1.0 ? 1 : 0) != 0);
        this.assertAdditionalProperties(Step.STOP_COMMAND_SENT, tmp);
        ConnectorTest.assertInstance(connector, true);
        ConnectorField.printFields((List)connector.enumerateFields(this.getEnumPathToFields()), (PrintStream)System.out);
        connector.disconnect();
        ConnectorTest.assertInstance(connector, false);
        LOGGER.info("Connector '" + connector.getName() + "' disconnected");
        this.afterActions(connector);
    }

    protected void block(AtomicInteger count, int receptions) {
        int max;
        for (max = 20; count.get() < receptions && max > 0; --max) {
            TimeUtils.sleep((int)200);
        }
        Assert.assertTrue((String)"Operation took too long", (max > 0 ? 1 : 0) != 0);
    }

    protected static enum Step {
        MACHINE_DATA_SENT,
        START_COMMAND_SENT,
        LOT_SIZE_CHANGED,
        STOP_COMMAND_SENT;

    }
}

