/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors.formatter;

import de.iip_ecosphere.platform.connectors.formatter.MachineFormatter;
import de.iip_ecosphere.platform.connectors.formatter.OutputFormatter;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.function.IOConsumer;
import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.support.json.JsonGenerator;
import de.iip_ecosphere.platform.transport.serialization.QualifiedElement;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import java.util.Stack;

@MachineFormatter
public class JsonOutputFormatter
implements OutputFormatter<IOConsumer<JsonGenerator>> {
    private StringWriter writer;
    private JsonGenerator gen;
    private String parentName = "";
    private Stack<StructureType> structures = new Stack();

    private void cleanNesting(String parent) throws IOException {
        while (this.parentName.length() > 0 && !parent.equals(this.parentName)) {
            this.gen.writeEndObject();
            int pos = this.parentName.lastIndexOf(46);
            if (pos > 0) {
                this.parentName = this.parentName.substring(0, pos);
                continue;
            }
            this.parentName = "";
        }
    }

    private void initialize() throws IOException {
        if (null == this.gen) {
            this.writer = new StringWriter();
            this.gen = Json.createGenerator((Writer)this.writer);
            this.gen.writeStartObject();
        }
    }

    @Override
    public void add(String name, IOConsumer<JsonGenerator> func) throws IOException {
        this.initialize();
        String fieldName = name;
        if (name.indexOf(46) > 0) {
            int pos = name.lastIndexOf(46);
            fieldName = name.substring(pos + 1);
            String parent = name.substring(0, pos);
            this.cleanNesting(parent);
            int startPos = this.parentName.length() + 1;
            while (!this.parentName.equals(parent)) {
                pos = parent.indexOf(46, startPos);
                if (pos < 0) {
                    this.gen.writeFieldName(parent);
                    this.gen.writeStartObject();
                    this.parentName = parent;
                    break;
                }
                String pathPartName = parent.substring(startPos, pos);
                this.gen.writeFieldName(pathPartName);
                this.gen.writeStartObject();
                if (this.parentName.length() > 0) {
                    this.parentName = this.parentName + ".";
                }
                this.parentName = this.parentName + pathPartName;
            }
        } else {
            this.cleanNesting("");
            this.parentName = "";
        }
        this.gen.writeFieldName(fieldName);
        func.accept((Object)this.gen);
    }

    @Override
    public void startArrayStructure(String name) throws IOException {
        this.initialize();
        this.structures.push(StructureType.ARRAY);
        if (null != name) {
            this.gen.writeFieldName(name);
        }
        this.gen.writeStartArray();
    }

    @Override
    public void startObjectStructure(String name) throws IOException {
        this.initialize();
        this.structures.push(StructureType.OBJECT);
        if (null != name) {
            this.gen.writeFieldName(name);
        }
        this.gen.writeStartObject();
    }

    @Override
    public void endStructure() throws IOException {
        if (this.structures.isEmpty()) {
            throw new IOException("No structure to close");
        }
        switch (this.structures.pop().ordinal()) {
            case 0: {
                this.gen.writeEndArray();
                break;
            }
            case 1: {
                this.gen.writeEndObject();
                break;
            }
        }
    }

    @Override
    public byte[] chunkCompleted() throws IOException {
        byte[] res = null;
        if (this.gen != null) {
            this.cleanNesting("");
            this.gen.writeEndObject();
            this.gen.close();
            res = this.writer.toString().getBytes();
            this.gen = null;
        }
        return res;
    }

    public JsonOutputConverter getConverter() {
        return new JsonOutputConverter();
    }

    private static enum StructureType {
        ARRAY,
        OBJECT;

    }

    public static class JsonOutputConverter
    implements OutputFormatter.OutputConverter<IOConsumer<JsonGenerator>> {
        @Override
        public IOConsumer<JsonGenerator> fromInteger(int data) throws IOException {
            return g -> g.writeNumber(data);
        }

        @Override
        public IOConsumer<JsonGenerator> fromByte(byte data) throws IOException {
            return g -> g.writeNumber((short)data);
        }

        @Override
        public IOConsumer<JsonGenerator> fromLong(long data) throws IOException {
            return g -> g.writeNumber(data);
        }

        @Override
        public IOConsumer<JsonGenerator> fromString(String data) throws IOException {
            return g -> g.writeString(data);
        }

        @Override
        public IOConsumer<JsonGenerator> fromShort(short data) throws IOException {
            return g -> g.writeNumber(data);
        }

        @Override
        public IOConsumer<JsonGenerator> fromDouble(double data) throws IOException {
            return g -> g.writeNumber(data);
        }

        @Override
        public IOConsumer<JsonGenerator> fromFloat(float data) throws IOException {
            return g -> g.writeNumber(data);
        }

        @Override
        public IOConsumer<JsonGenerator> fromBoolean(boolean data) throws IOException {
            return g -> g.writeBoolean(data);
        }

        @Override
        public IOConsumer<JsonGenerator> fromIntegerArray(int[] data) throws IOException {
            return g -> g.writeArray(data, 0, data.length);
        }

        @Override
        public IOConsumer<JsonGenerator> fromDoubleArray(double[] data) throws IOException {
            return g -> g.writeArray(data, 0, data.length);
        }

        @Override
        public IOConsumer<JsonGenerator> fromStringArray(String[] data) throws IOException {
            return g -> {
                if (null == data) {
                    g.writeNull();
                } else {
                    g.writeArray(data, 0, data.length);
                }
            };
        }

        @Override
        public IOConsumer<JsonGenerator> fromByteArray(byte[] data) throws IOException {
            return g -> {
                if (null == data) {
                    g.writeNull();
                } else {
                    int[] tmp = new int[data.length];
                    for (int i = 0; i < data.length; ++i) {
                        tmp[i] = data[i];
                    }
                    g.writeArray(tmp, 0, tmp.length);
                }
            };
        }

        @Override
        public IOConsumer<JsonGenerator> fromList(List<?> data) throws IOException {
            return g -> {
                g.writeStartArray();
                for (Object o : data) {
                    if (o instanceof QualifiedElement) {
                        o = ((QualifiedElement)o).getValue();
                    }
                    g.writeObject(o);
                }
                g.writeEndArray();
            };
        }

        @Override
        public <E> IOConsumer<JsonGenerator> fromElementList(List<QualifiedElement<E>> data) throws IOException {
            return g -> {
                g.writeStartArray();
                for (QualifiedElement e : data) {
                    g.writeObject(e.getValue());
                }
                g.writeEndArray();
            };
        }

        @Override
        public IOConsumer<JsonGenerator> fromObject(Object data) throws IOException {
            return g -> g.writeObject(data);
        }

        @Override
        public IOConsumer<JsonGenerator> fromDate(Date data, String format) throws IOException {
            return g -> g.writeString(TimeUtils.format((Date)data, (String)format));
        }

        @Override
        public IOConsumer<JsonGenerator> fromBigInteger(BigInteger data) throws IOException {
            return g -> g.writeNumber(data);
        }

        @Override
        public IOConsumer<JsonGenerator> fromBigDecimal(BigDecimal data) throws IOException {
            return g -> g.writeNumber(data);
        }

        @Override
        public IOConsumer<JsonGenerator> fromLongIndex(long data) throws IOException {
            return g -> g.writeNumber(data);
        }

        @Override
        public IOConsumer<JsonGenerator> fromFloatIndex(float data) throws IOException {
            return g -> g.writeNumber(data);
        }
    }
}

