/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.connectors.formatter;

import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.transport.serialization.IipEnum;
import de.iip_ecosphere.platform.transport.serialization.QualifiedElement;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

public interface OutputFormatter<T> {
    public static final char SEPARATOR = '.';

    public void add(String var1, T var2) throws IOException;

    public void startArrayStructure(String var1) throws IOException;

    public void startObjectStructure(String var1) throws IOException;

    public void endStructure() throws IOException;

    public byte[] chunkCompleted() throws IOException;

    public OutputConverter<T> getConverter();

    public static interface OutputConverter<T> {
        public T fromByte(byte var1) throws IOException;

        public T fromInteger(int var1) throws IOException;

        public T fromLong(long var1) throws IOException;

        public T fromString(String var1) throws IOException;

        public T fromShort(short var1) throws IOException;

        public T fromDouble(double var1) throws IOException;

        public T fromFloat(float var1) throws IOException;

        public T fromBigInteger(BigInteger var1) throws IOException;

        public T fromBigDecimal(BigDecimal var1) throws IOException;

        public T fromBoolean(boolean var1) throws IOException;

        public T fromIntegerArray(int[] var1) throws IOException;

        public T fromDoubleArray(double[] var1) throws IOException;

        public T fromStringArray(String[] var1) throws IOException;

        public T fromByteArray(byte[] var1) throws IOException;

        public T fromDate(Date var1, String var2) throws IOException;

        default public T fromLocalDateTime(LocalDateTime data, String format) throws IOException {
            return this.fromDate(TimeUtils.toDate((LocalDateTime)data), format);
        }

        default public T fromEnum(IipEnum data) throws IOException {
            return this.fromInteger(data.getModelOrdinal());
        }

        default public T fromEnumAsName(Enum<?> data) throws IOException {
            return this.fromString(data.name());
        }

        public T fromList(List<?> var1) throws IOException;

        public <E> T fromElementList(List<QualifiedElement<E>> var1) throws IOException;

        public T fromObject(Object var1) throws IOException;

        public T fromLongIndex(long var1) throws IOException;

        public T fromFloatIndex(float var1) throws IOException;
    }
}

