/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.connectors;

import de.iip_ecosphere.platform.connectors.AbstractThreadedConnector;
import de.iip_ecosphere.platform.connectors.ConnectorParameter;
import de.iip_ecosphere.platform.connectors.model.AbstractModelAccess;
import de.iip_ecosphere.platform.connectors.model.ModelAccess;
import de.iip_ecosphere.platform.connectors.types.ConnectorInputTypeTranslator;
import de.iip_ecosphere.platform.connectors.types.ConnectorOutputTypeTranslator;
import de.iip_ecosphere.platform.connectors.types.ProtocolAdapter;
import de.iip_ecosphere.platform.connectors.types.TranslatingProtocolAdapter;
import de.iip_ecosphere.platform.support.TimeUtils;
import de.iip_ecosphere.platform.support.iip_aas.ActiveAasBase;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import test.de.iip_ecosphere.platform.connectors.IdentityInputTranslator;
import test.de.iip_ecosphere.platform.connectors.IdentityOutputTranslator;

public class AbstractThreadedConnectorTest {
    private int disposed;

    @Test
    public void testConnector() throws IOException {
        ActiveAasBase.NotificationMode mode = ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)ActiveAasBase.NotificationMode.NONE);
        MyConnector conn = new MyConnector();
        conn.connect(ConnectorParameter.ConnectorParameterBuilder.newBuilder((String)"localhost", (int)1234).build());
        System.out.println("Main thread read/write");
        conn.write(new Object());
        conn.request(true);
        Assert.assertEquals((long)0L, (long)this.disposed);
        new Thread(() -> {
            try {
                System.out.println("Additional thread read/write");
                conn.write(new Object());
                conn.request(true);
                TimeUtils.sleep((int)500);
            }
            catch (IOException e) {
                Assert.fail((String)"No exception expected.");
            }
        }).start();
        System.out.println("Waiting for cleanup/disposal... >5s");
        TimeUtils.sleep((int)(conn.getCleanupPeriod() + 2000));
        Assert.assertEquals((long)1L, (long)this.disposed);
        conn.disconnect();
        ActiveAasBase.setNotificationMode((ActiveAasBase.NotificationMode)mode);
    }

    private class MyConnector
    extends AbstractThreadedConnector<Object, Object, Object, Object, MyModelAccess> {
        protected MyConnector() {
            super(new ProtocolAdapter[]{new TranslatingProtocolAdapter((ConnectorOutputTypeTranslator)new IdentityOutputTranslator(), (ConnectorInputTypeTranslator)new IdentityInputTranslator())});
            this.setModelAccessSupplier(() -> new MyModelAccess());
        }

        public String supportedEncryption() {
            return null;
        }

        public String enabledEncryption() {
            return null;
        }

        public String getName() {
            return null;
        }

        protected void connectImpl(ConnectorParameter params) throws IOException {
        }

        protected void disconnectImpl() throws IOException {
        }

        protected void writeImpl(Object data) throws IOException {
        }

        protected Object read() throws IOException {
            return new Object();
        }

        protected void error(String message, Throwable th) {
        }
    }

    private class MyModelAccess
    extends AbstractModelAccess {
        protected MyModelAccess() {
            super(null);
        }

        public String topInstancesQName() {
            return null;
        }

        public String getQSeparator() {
            return null;
        }

        public Object call(String qName, Object ... args) throws IOException {
            return null;
        }

        public Object get(String qName) throws IOException {
            return null;
        }

        public void set(String qName, Object value) throws IOException {
        }

        public <T> T getStruct(String qName, Class<T> type) throws IOException {
            return null;
        }

        public void setStruct(String qName, Object value) throws IOException {
        }

        public void registerCustomType(Class<?> cls) throws IOException {
        }

        public void monitor(int notificationInterval, String ... qNames) throws IOException {
        }

        public void monitorModelChanges(int notificationInterval) throws IOException {
        }

        public ModelAccess stepInto(String name) throws IOException {
            return null;
        }

        public ModelAccess stepOut() {
            return null;
        }

        public ConnectorParameter getConnectorParameter() {
            return null;
        }

        public void dispose() {
            ++AbstractThreadedConnectorTest.this.disposed;
        }
    }
}

