/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.tools.maven.dependencies;

import de.iip_ecosphere.platform.tools.maven.dependencies.BuildClasspathMojo;
import de.iip_ecosphere.platform.tools.maven.dependencies.Layers;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="build-plugin-classpath", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class BuildPluginClasspathMojo
extends BuildClasspathMojo {
    public static final String KEY_PREFIX = "# prefix: ";
    public static final String KEY_UNPACK_MODE = "# unpackMode: ";
    public static final String KEY_SETUP_DESCRIPTOR = "# setupDescriptor: ";
    public static final String KEY_PLUGIN_IDS = "# pluginIds: ";
    public static final String KEY_SEQUENCE_NR = "# sequenceNr: ";
    private final String prefix = "target/jars";
    @Parameter(property="mdep.addTestArtifact", defaultValue="false")
    private boolean addTestArtifact;
    @Parameter(property="mdep.unpackMode", defaultValue="jars")
    private String unpackMode;
    @Parameter(property="mdep.setupDescriptor", defaultValue="FolderClasspath")
    private String setupDescriptor;
    @Parameter(property="mdep.pluginIds", defaultValue="")
    private List<String> pluginIds;
    @Parameter(property="mdep.resolvedFile", defaultValue="*")
    private String resolvedFile;
    @Parameter(required=false)
    private boolean asTest;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File targetDirectory;
    @Parameter(property="mdep.validateJsl", defaultValue="INFO")
    private JslMode validateJsl;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepositories;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Component
    private RepositorySystem repoSystem;

    private String getRelTargetDirectory() {
        String result = this.targetDirectory.getName();
        File home = new File(System.getProperty("user.dir"));
        String homePath = home.getAbsolutePath();
        String targetPath = this.targetDirectory.getAbsolutePath();
        try {
            homePath = home.getCanonicalPath();
            targetPath = this.targetDirectory.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (targetPath.startsWith(homePath)) {
            result = targetPath.substring(homePath.length() + 1);
        }
        return result;
    }

    private String composeMyArtifact(String classifier, String extension) {
        Object object = classifier = null == classifier ? "" : classifier;
        if (((String)classifier).length() > 0 && !((String)classifier).startsWith("-")) {
            classifier = "-" + (String)classifier;
        }
        Object object2 = extension = null == extension || ((String)extension).length() == 0 ? "jar" : extension;
        if (!((String)extension).startsWith(".")) {
            extension = "." + (String)extension;
        }
        return this.getRelTargetDirectory() + "/" + this.getProject().getGroupId() + "." + this.getProject().getArtifactId() + "-" + this.getProject().getVersion() + (String)classifier + (String)extension;
    }

    @Override
    protected void doExecute() throws MojoExecutionException {
        this.excludeArtifactIds = Layers.getExcludeArtifactIds(this.getProject().getArtifactId(), this.excludeArtifactIds, this.asTest, this.getLog());
        this.setOutputFile(new File(this.targetDirectory, "jars" + (this.asTest ? "-test" : "") + "/classpath"));
        this.setPrependGroupId(true);
        this.overWriteIfNewer = true;
        this.setLocalRepoProperty("target/jars");
        this.setPrefix("target/jars");
        this.setFileSeparator("/");
        this.setPathSeparator(":");
        if (null == this.includeScope || this.includeScope.length() == 0) {
            this.includeScope = this.addTestArtifact || this.asTest ? "test" : "compile";
        }
        ArrayList<String> prepends = new ArrayList<String>();
        prepends.add(this.composeMyArtifact("", "jar"));
        if (this.addTestArtifact || this.asTest) {
            prepends.add(this.composeMyArtifact("tests", "jar"));
        }
        this.setPrepends(prepends);
        this.composeBefores(null);
        super.doExecute();
        if (this.validateJsl != JslMode.OFF) {
            switch (this.validateJsl.ordinal()) {
                case 4: {
                    if (this.validateJsl(s -> this.getLog().error((CharSequence)s))) break;
                    throw new MojoExecutionException("Cannot validate existence of JSL services. See messages above.");
                }
                case 3: {
                    this.validateJsl(s -> this.getLog().error((CharSequence)s));
                    break;
                }
                case 2: {
                    this.validateJsl(s -> this.getLog().warn((CharSequence)s));
                    break;
                }
                case 1: {
                    this.validateJsl(s -> this.getLog().info((CharSequence)s));
                    break;
                }
            }
        }
    }

    private boolean validateJsl(Consumer<String> logConsumer) {
        File classes = new File(this.targetDirectory, "classes");
        File testClasses = new File(this.targetDirectory, "test-classes");
        boolean result = true;
        result &= this.validateJsl(new File("src/main/resources"), logConsumer, classes);
        return result &= this.validateJsl(new File("src/test/resources"), logConsumer, classes, testClasses);
    }

    private boolean validateJsl(File descParent, Consumer<String> logConsumer, File ... classDir) {
        File[] descs;
        boolean result = true;
        ArrayList<File> classDirList = new ArrayList<File>();
        Collections.addAll(classDirList, classDir);
        File jslDir = new File(descParent, "META-INF/services");
        if (jslDir.isDirectory() && null != (descs = jslDir.listFiles(f -> f.isFile()))) {
            for (File desc : descs) {
                try {
                    List<String> lines = Files.readAllLines(desc.toPath());
                    for (String line : lines) {
                        result &= this.validateJsl(desc, logConsumer, line, classDirList);
                    }
                }
                catch (IOException e) {
                    logConsumer.accept("Cannot read JSL descriptor " + String.valueOf(desc) + ": " + e.getMessage());
                    result = false;
                }
            }
        }
        return result;
    }

    private boolean validateJsl(File desc, Consumer<String> logConsumer, String descClass, List<File> classDirList) {
        boolean result = true;
        for (File cDir : classDirList) {
            File clsFile = new File(cDir, descClass.replace(".", "/") + ".class");
            if (clsFile.isFile()) continue;
            logConsumer.accept("Class '" + descClass + "' (" + String.valueOf(clsFile) + ") in JSL descriptor " + String.valueOf(desc) + " not found in " + String.valueOf(classDirList));
            result = false;
        }
        return result;
    }

    @Override
    public void adjustTo(Function<String, String> func) {
        this.composeBefores(func);
    }

    private void composeBefores(Function<String, String> func) {
        ArrayList<String> befores = new ArrayList<String>();
        befores.add(KEY_PREFIX + (null != func ? func.apply("target/jars") : "target/jars"));
        befores.add(KEY_UNPACK_MODE + this.unpackMode);
        befores.add(KEY_SETUP_DESCRIPTOR + this.setupDescriptor);
        if (this.pluginIds != null && this.pluginIds.size() > 0) {
            befores.add(KEY_PLUGIN_IDS + String.join((CharSequence)", ", this.pluginIds));
        }
        this.setBefores(befores);
    }

    public static enum JslMode {
        OFF,
        INFO,
        WARN,
        ERROR,
        FAIL;

    }
}

