/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.tools.maven.dependencies;

import de.iip_ecosphere.platform.tools.maven.dependencies.CleaningUnpackMojo;
import de.iip_ecosphere.platform.tools.maven.dependencies.Resolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.dependency.fromConfiguration.ArtifactItem;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.model.fileset.FileSet;
import org.codehaus.plexus.components.io.filemappers.FileMapper;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResolutionException;

@Mojo(name="unpack-plugins", defaultPhase=LifecyclePhase.TEST_COMPILE, requiresProject=false, threadSafe=true, requiresDependencyResolution=ResolutionScope.RUNTIME, requiresDependencyCollection=ResolutionScope.RUNTIME)
public class UnpackPluginMojo
extends CleaningUnpackMojo {
    private static final String NAME_CLASSPATH_FILE = "classpath";
    @Parameter(property="unpack.plugins", required=false)
    private List<PluginItem> plugins;
    @Parameter(property="unpack.version", required=false, defaultValue="")
    private String version;
    @Parameter(property="unpack.relocate", required=false, defaultValue="false")
    private boolean relocate;
    @Parameter(property="unpack.always", required=false, defaultValue="false")
    private boolean always;
    @Parameter(property="unpack.relocateTarget", required=false, defaultValue="jars")
    private File relocateTarget;
    @Parameter(property="unpack.forceResolve", required=false, defaultValue="false")
    private boolean forceResolve;
    @Parameter(property="unpack.resolveAndCopy", required=false, defaultValue="false")
    private boolean resolveAndCopy;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File targetDirectory;
    @Parameter(property="mdep.writeResolved", defaultValue="false")
    private boolean writeResolved;
    @Parameter(property="mdep.resolvedFile", defaultValue="*")
    private String resolvedFile;
    private List<ClasspathFile> classpathFiles = new ArrayList<ClasspathFile>();
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> remoteArtifactRepositories;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepositories;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    private MavenSession session;
    @Component
    private RepositorySystem repoSystem;
    private Map<String, List<String>> pluginAppends = new HashMap<String, List<String>>();
    private Resolver resolver;

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        this.resolver = new Resolver(this.repoSystem, this.repoSession, this.remoteRepositories, this.getLog());
        File targetDir = this.getOutputDir(null);
        this.setForceCleanup(true);
        FileSet cleanup = new FileSet();
        cleanup.setDirectory(targetDir.toString());
        this.setCleanup(cleanup);
        if (!this.relocate) {
            if (!this.always) {
                File skipIfExists = new File("../../support/support");
                if (!skipIfExists.exists()) {
                    skipIfExists = new File("../support");
                }
                if (skipIfExists.exists()) {
                    this.setSkipIfExists(skipIfExists);
                }
            }
        } else {
            this.relocateTarget.mkdirs();
            this.setForce(true);
        }
        if (this.plugins != null && this.plugins.size() > 0) {
            ArrayList<ArtifactItem> artifactItems = new ArrayList<ArtifactItem>();
            for (PluginItem pl : this.plugins) {
                ArtifactItem item = this.toArtifactItem(pl);
                String artId = item.getArtifactId();
                this.getLog().info((CharSequence)("Configuring plugin '" + artId + "' -> " + String.valueOf(item.getOutputDirectory())));
                item.setFileMappers(new FileMapper[]{new RelocatingFileMapper(artId, "-" + this.getActualVersion(pl), true)});
                artifactItems.add(item);
            }
            this.setArtifactItems(artifactItems);
        }
        super.doExecute();
        this.handleSetupDescriptors();
        if (this.skipIfExists() == null || !this.skipIfExists().exists()) {
            this.handleAppends();
        } else if (this.plugins.stream().anyMatch(p -> p.hasAppends())) {
            this.getLog().info((CharSequence)"Running in shortcut local test mode, cannot handle appends");
        }
        this.relocate();
        this.storeResolved();
    }

    private String getActualVersion(PluginItem pl) {
        return StringUtils.isBlank((CharSequence)this.version) ? pl.getVersion() : this.version;
    }

    private ArtifactItem toArtifactItem(PluginItem pl) {
        ArtifactItem item = new ArtifactItem();
        String artId = pl.getArtifactId();
        if (StringUtils.isBlank((CharSequence)pl.getGroupId())) {
            item.setGroupId("de.iip-ecosphere.platform");
        } else {
            item.setGroupId(pl.getGroupId());
        }
        item.setArtifactId(artId);
        item.setVersion(this.getActualVersion(pl));
        item.setType("zip");
        item.setClassifier("plugin" + (pl.asTest ? "-test" : ""));
        item.setOverWrite(String.valueOf(true));
        item.setOutputDirectory(this.getOutputDir(artId));
        item.setDestFileName(artId + ".zip");
        return item;
    }

    private void storeResolved() throws MojoExecutionException {
        if (this.writeResolved && this.plugins != null && this.plugins.size() > 0) {
            File file = null;
            if (this.resolvedFile == null || this.resolvedFile.equals("*")) {
                file = new File(this.targetDirectory, "classes/resolved");
            } else if (this.resolvedFile.length() > 0) {
                file = new File(this.resolvedFile);
            }
            if (file != null) {
                Resolver resolver = new Resolver(this.repoSystem, this.repoSession, this.remoteRepositories, this.getLog());
                try (PrintStream out = new PrintStream(new FileOutputStream(file));){
                    out.println("[");
                    boolean first = true;
                    for (PluginItem p : this.plugins) {
                        String urlPath = resolver.resolveToUrl(this.toArtifactItem(p));
                        if (null == urlPath || urlPath.length() <= 0) continue;
                        if (!first) {
                            out.println(",");
                        }
                        out.print("  {\"url\":\"" + urlPath + "\", \"name\":\"" + p.getArtifactId() + "-" + this.getActualVersion(p) + "\"}");
                        first = false;
                    }
                    if (!first) {
                        out.println();
                    }
                    out.println("]");
                    this.getLog().info((CharSequence)("Wrote resolution file " + String.valueOf(file)));
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)("While writing resolution file " + String.valueOf(file) + ": " + e.getMessage()));
                }
            } else {
                this.getLog().info((CharSequence)"Skipping resolution file as disabled");
            }
        }
    }

    private File getOutputDir(String name) {
        Object oktoSuffix = "";
        if (name != null && name.length() > 0) {
            oktoSuffix = "/" + name;
        }
        return this.relocate ? this.relocateTarget : new File(this.targetDirectory, "oktoPlugins" + (String)oktoSuffix);
    }

    private File getCpFile(String name) {
        return new File(this.getOutputDir(name), this.relocate ? name : NAME_CLASSPATH_FILE);
    }

    private void handleAppends() {
        for (PluginItem pl : this.plugins) {
            if (!pl.hasAppends()) continue;
            ArrayList<String> result = new ArrayList<String>();
            for (String name : pl.appends) {
                File cpFile = this.getCpFile(name);
                try (FileInputStream fis = new FileInputStream(cpFile);){
                    List contents = IOUtils.readLines((InputStream)fis, (Charset)Charset.defaultCharset());
                    String prefix = null;
                    for (String line : contents) {
                        if (line.startsWith("#")) {
                            prefix = UnpackPluginMojo.extractSuffix("# prefix: ", line, prefix);
                            continue;
                        }
                        Tokenizer tokenizer = new Tokenizer(line);
                        prefix = this.fixPrefix(prefix, tokenizer);
                        while (tokenizer.hasMoreTokens()) {
                            Object token = tokenizer.nextToken();
                            if (!this.relocate) {
                                token = "../" + name + "/" + (String)token;
                            }
                            result.add((String)token);
                        }
                    }
                }
                catch (IOException e) {
                    this.getLog().error((CharSequence)("Cannot locate append plugin '" + name + "' - ignoring: " + e.getMessage()));
                }
            }
            this.pluginAppends.put(pl.getArtifactId(), result);
        }
    }

    private void handleSetupDescriptors() {
        for (PluginItem pl : this.plugins) {
            if (!pl.hasSetupDescriptor()) continue;
            String name = pl.getArtifactId();
            File cpFile = this.getCpFile(name);
            List contents = null;
            try (FileInputStream fis = new FileInputStream(cpFile);){
                contents = IOUtils.readLines((InputStream)fis, (Charset)Charset.defaultCharset());
                for (int l = 0; l < contents.size(); ++l) {
                    String line = (String)contents.get(l);
                    if (!line.startsWith("# setupDescriptor: ")) continue;
                    contents.set(l, "# setupDescriptor: " + pl.setupDescriptor);
                }
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Cannot read plugin '" + name + "' - ignoring: " + e.getMessage()));
            }
            if (null == contents) continue;
            try (FileOutputStream fos = new FileOutputStream(cpFile);){
                IOUtils.writeLines((Collection)contents, (String)"\n", (OutputStream)fos, (Charset)Charset.defaultCharset());
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Cannot read plugin '" + name + "' - ignoring: " + e.getMessage()));
            }
        }
    }

    private void mergeFiles(File src, File tgt) throws IOException {
        File[] srcFiles = src.listFiles();
        if (null != srcFiles) {
            for (File f : srcFiles) {
                File t = new File(tgt, f.getName());
                if (t.exists() || !f.isFile()) continue;
                FileUtils.moveFile((File)f, (File)t);
            }
        }
    }

    private static String extractSuffix(String prefix, String line, String dflt) {
        String result = dflt;
        if (null != prefix && line.startsWith(prefix)) {
            result = line.substring(prefix.length()).trim();
        }
        return result;
    }

    private String fixPrefix(String prefix, Tokenizer tokenizer) {
        String pathSep;
        String string = pathSep = tokenizer.win ? "\\" : "/";
        if (null != prefix && !((String)prefix).endsWith(pathSep)) {
            prefix = (String)prefix + pathSep;
        }
        return prefix;
    }

    private String stripPrefix(String prefix, String cpToken) {
        cpToken = UnpackPluginMojo.extractSuffix(prefix, cpToken, cpToken);
        cpToken = UnpackPluginMojo.extractSuffix("target/jars", cpToken, cpToken);
        return UnpackPluginMojo.extractSuffix("target/", cpToken, cpToken);
    }

    private void relocate() throws MojoExecutionException, MojoFailureException {
        File pluginDir = null;
        if (this.relocate) {
            File tgtDir = this.relocateTarget;
            pluginDir = new File(this.relocateTarget, "../plugins");
            this.getLog().info((CharSequence)"Flattening jars/target/jars and jars/target to jars");
            try {
                this.mergeFiles(new File(tgtDir, "target/jars"), tgtDir);
                this.mergeFiles(new File(tgtDir, "target"), tgtDir);
            }
            catch (IOException e) {
                throw new MojoFailureException("Cannot move unpacked files: " + e.getMessage());
            }
            FileUtils.deleteQuietly((File)new File(tgtDir, "target"));
        }
        int seqNr = 1;
        for (ClasspathFile cf : this.classpathFiles) {
            File tgt;
            File src;
            cf.preprocess(this.getOutputDir(null));
            String cpFile = cf.getName();
            if (this.relocate) {
                src = new File(this.relocateTarget, cpFile);
                tgt = new File(pluginDir, cpFile);
                tgt.mkdirs();
                this.getLog().info((CharSequence)("Rewriting classpath file " + String.valueOf(src) + " to " + String.valueOf(tgt)));
            } else {
                tgt = src = this.getOutputDir(cpFile);
                this.getLog().info((CharSequence)("Rewriting classpath file " + String.valueOf(src)));
            }
            try {
                if (this.relocate) {
                    FileUtils.deleteQuietly((File)tgt);
                    FileUtils.moveFile((File)src, (File)tgt);
                }
                FileInputStream fis = new FileInputStream(tgt);
                List contents = IOUtils.readLines((InputStream)fis, (Charset)Charset.defaultCharset());
                fis.close();
                PrintStream out = new PrintStream(new FileOutputStream(tgt));
                out.println("# sequenceNr: " + seqNr);
                String prefix = null;
                String mode = null;
                for (String line : contents) {
                    if (line.startsWith("#")) {
                        prefix = UnpackPluginMojo.extractSuffix("# prefix: ", line, prefix);
                        mode = UnpackPluginMojo.extractSuffix("# unpackMode: ", line, mode);
                        out.println(line);
                        continue;
                    }
                    Tokenizer tokenizer = new Tokenizer(line);
                    prefix = this.fixPrefix(prefix, tokenizer);
                    if (this.relocate) {
                        this.processCpLineRelocation(cpFile, mode, out, tokenizer, prefix, this.relocateTarget);
                    } else {
                        this.processCpLineNoRelocation(cpFile, mode, line, out, tokenizer, prefix);
                    }
                    out.println();
                }
                out.close();
                if (this.relocate) {
                    FileUtils.deleteQuietly((File)src);
                }
            }
            catch (IOException e) {
                throw new MojoFailureException("Cannot postprocess " + String.valueOf(src) + ": " + e.getMessage());
            }
            ++seqNr;
        }
    }

    private void processCpLineRelocation(String name, String mode, PrintStream out, Tokenizer tokenizer, String prefix, File jarFolder) {
        ArrayList<String> tokens = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        HashSet knownTokens = new HashSet(tokens);
        List<String> plAppends = this.pluginAppends.get(name);
        if (null != plAppends) {
            for (String cp : plAppends) {
                if (knownTokens.contains(cp)) continue;
                tokens.add(cp);
            }
        }
        Iterator tokenIter = tokens.iterator();
        while (tokenIter.hasNext()) {
            String token = (String)tokenIter.next();
            token = this.rewriteToken(token, mode, prefix, jarFolder, tokenizer);
            out.print(token);
            if (!tokenIter.hasNext()) continue;
            out.print(tokenizer.sep);
        }
    }

    private void processCpLineNoRelocation(String name, String mode, String line, PrintStream out, Tokenizer tokenizer, String prefix) {
        ArrayList<String> tokens = new ArrayList<String>();
        HashSet<String> knownTokens = new HashSet<String>();
        while (tokenizer.hasMoreTokens()) {
            String tok = tokenizer.nextToken();
            knownTokens.add(tok);
            tokens.add(tok);
        }
        if (this.isModeResolve(mode)) {
            this.handleAppends(name, knownTokens, cp -> tokens.add((String)cp));
            List processedTokens = tokens.stream().map(token -> this.rewriteToken((String)token, mode, prefix, null, tokenizer)).collect(Collectors.toList());
            out.print(String.join((CharSequence)tokenizer.sep, processedTokens));
        } else {
            out.print(line);
            int pos = name.indexOf("/");
            if (pos > 0) {
                name = name.substring(0, pos);
            }
            this.handleAppends(name, knownTokens, cp -> {
                out.print(tokenizer.sep);
                out.print((String)cp);
            });
        }
    }

    private String rewriteToken(String token, String mode, String prefix, File jarFolder, Tokenizer tokenizer) {
        if (tokenizer.win) {
            token = token.replace("target\\jars\\", "jars\\");
            token = token.replace("target\\", "jars\\");
        } else {
            token = token.replace("target/jars/", "jars/");
            token = token.replace("target/", "jars/");
        }
        if (this.isModeResolve(mode)) {
            token = this.stripPrefix(prefix, token);
            token = this.resolve(token, jarFolder);
        }
        return token;
    }

    private boolean isModeResolve(String mode) {
        return null != mode && mode.equalsIgnoreCase("resolve") || this.forceResolve;
    }

    private void handleAppends(String name, Set<String> knownTokens, Consumer<String> handler) {
        List<String> plAppends = this.pluginAppends.get(name);
        if (null != plAppends) {
            for (String cp : plAppends) {
                if (knownTokens.contains(cp)) continue;
                handler.accept(cp);
                knownTokens.add(cp);
            }
        }
    }

    private DefaultArtifact parsePath(String path) {
        String groupId = "";
        String artifactId = "";
        Object version = "";
        String type = "";
        String classifier = "";
        int pos = path.lastIndexOf(47);
        if (pos > 0) {
            path = path.substring(pos + 1);
        }
        if ((pos = (artifactId = path).lastIndexOf(46)) > 0) {
            type = artifactId.substring(pos + 1);
            artifactId = artifactId.substring(0, pos);
        }
        if ((pos = path.lastIndexOf(45)) > 0) {
            classifier = artifactId.substring(pos + 1);
            artifactId = artifactId.substring(0, pos);
            if (Character.isDigit(classifier.charAt(0))) {
                version = classifier;
                classifier = "";
            } else {
                pos = artifactId.lastIndexOf(45);
                if (pos > 0) {
                    if (!Character.isDigit(artifactId.charAt(pos + 1))) {
                        pos = artifactId.lastIndexOf(45, pos - 1);
                    }
                    if (pos > 0) {
                        version = artifactId.substring(pos + 1);
                        artifactId = artifactId.substring(0, pos);
                    }
                }
                if (classifier.equals("SNAPSHOT")) {
                    classifier = "";
                    version = (String)version + "-SNAPSHOT";
                }
            }
        }
        if ((pos = this.findArtifactId(artifactId)) > 0) {
            groupId = artifactId.substring(0, pos);
            artifactId = artifactId.substring(pos + 1);
        }
        return new DefaultArtifact(groupId, artifactId, classifier, type, (String)version);
    }

    private int findArtifactId(String name) {
        String iipPrefix = "de.iip-ecosphere.platform.";
        if (name.startsWith("de.iip-ecosphere.platform.")) {
            return "de.iip-ecosphere.platform.".length() - 1;
        }
        return name.lastIndexOf(46);
    }

    private String resolve(String path, File jarFolder) {
        String resolved = path;
        try {
            DefaultArtifact artifact = this.parsePath(path);
            File res = this.resolver.resolve(artifact);
            if (this.resolveAndCopy && jarFolder != null) {
                File tgt = new File(jarFolder, res.getName());
                if (!res.exists()) {
                    try {
                        FileUtils.copyFile((File)res, (File)tgt);
                    }
                    catch (IOException e) {
                        this.getLog().error((CharSequence)("Cannot copy resolved artifact '" + String.valueOf(artifact) + "' from '" + String.valueOf(res) + "' to '" + String.valueOf(tgt) + "' - ignoring: " + e.getMessage()));
                    }
                }
            } else {
                resolved = res.getAbsolutePath();
            }
        }
        catch (ArtifactResolutionException e) {
            this.getLog().warn((CharSequence)("Cannot resolve to artifact, keeping path: " + path));
        }
        return resolved;
    }

    public ProjectBuildingRequest newResolveArtifactProjectBuildingRequest() {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        buildingRequest.setRemoteRepositories(this.remoteArtifactRepositories);
        return buildingRequest;
    }

    public static class PluginItem
    extends ArtifactItem {
        @Parameter(required=false)
        private List<String> appends;
        private boolean asTest;
        private String setupDescriptor;

        private boolean hasAppends() {
            return null != this.appends && !this.appends.isEmpty();
        }

        private boolean hasSetupDescriptor() {
            return null != this.setupDescriptor && this.setupDescriptor.length() > 0;
        }
    }

    private class RelocatingFileMapper
    implements FileMapper {
        private String targetName;
        private String pathSuffix;
        private boolean collectIfNotRelocate;

        private RelocatingFileMapper(String targetName, String pathSuffix, boolean collectIfNotRelocate) {
            this.targetName = targetName;
            this.pathSuffix = pathSuffix;
            this.collectIfNotRelocate = collectIfNotRelocate;
        }

        public String getMappedFileName(String pName) {
            Object name = pName;
            if (((String)name).startsWith(UnpackPluginMojo.NAME_CLASSPATH_FILE)) {
                if (UnpackPluginMojo.this.relocate) {
                    name = ((String)name).length() == UnpackPluginMojo.NAME_CLASSPATH_FILE.length() ? this.targetName : this.targetName + ((String)name).substring(UnpackPluginMojo.NAME_CLASSPATH_FILE.length());
                    UnpackPluginMojo.this.classpathFiles.add(new ClasspathFile((String)name));
                } else if (this.collectIfNotRelocate) {
                    UnpackPluginMojo.this.classpathFiles.add(new ClasspathFile(this.targetName + "/" + (String)name, this.targetName, this.pathSuffix));
                }
            }
            return name;
        }
    }

    private static class Tokenizer {
        private String sep = ":";
        private boolean win = false;
        private StringTokenizer tokenizer;

        private Tokenizer(String line) {
            this.tokenizer = new StringTokenizer(line, this.sep);
            if (this.tokenizer.countTokens() <= 1) {
                this.sep = ";";
                this.tokenizer = new StringTokenizer(line, this.sep);
                this.win = true;
            }
        }

        private boolean hasMoreTokens() {
            return this.tokenizer.hasMoreTokens();
        }

        private String nextToken() {
            return this.tokenizer.nextToken();
        }
    }

    private static class ClasspathFile {
        private String name;
        private String origPath;
        private String pathSuffix;

        private ClasspathFile(String name) {
            this.name = name;
        }

        private ClasspathFile(String name, String origPath, String pathSuffix) {
            this.name = name;
            this.origPath = origPath;
            this.pathSuffix = pathSuffix;
        }

        private String getName() {
            return this.name;
        }

        private void preprocess(File targetDir) throws MojoFailureException {
            if (null != this.origPath && null != this.pathSuffix) {
                int pos;
                File orig = new File(targetDir, this.origPath);
                File target = new File(targetDir, this.origPath + this.pathSuffix);
                if (orig.exists() && !target.exists()) {
                    try {
                        FileUtils.moveDirectory((File)new File(targetDir, this.origPath), (File)new File(targetDir, this.origPath + this.pathSuffix));
                    }
                    catch (IOException e) {
                        throw new MojoFailureException("Cannot move unpacked files: " + e.getMessage());
                    }
                }
                if ((pos = this.name.lastIndexOf("/")) > 0) {
                    this.name = this.name.substring(0, pos) + this.pathSuffix + this.name.substring(pos);
                }
            }
        }
    }
}

