/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.tools.maven.dependencies;

import de.iip_ecosphere.platform.tools.maven.dependencies.Resolver;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingRequest;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;

@Mojo(name="copy-dependencies", requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.PROCESS_SOURCES, threadSafe=true)
public class CopyDependenciesMojo
extends org.apache.maven.plugins.dependency.fromDependencies.CopyDependenciesMojo {
    @Parameter(property="mdep.addAppLoader", defaultValue="false")
    private boolean addAppLoader;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepositories;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> remoteArtifactRepositories;
    @Component
    private RepositorySystem repoSystem;

    protected void doExecute() throws MojoExecutionException {
        Resolver resolver;
        File file;
        super.doExecute();
        if (this.addAppLoader && null != (file = (resolver = new Resolver(this.repoSystem, this.repoSession, this.remoteRepositories, this.getLog())).resolveSpringBootLoader(this.getProject()))) {
            try {
                Files.copy(file.toPath(), new File(this.outputDirectory, file.getName()).toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Cannot copy: " + e.getMessage()));
            }
        }
    }

    public ProjectBuildingRequest newResolveArtifactProjectBuildingRequest() {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
        buildingRequest.setRemoteRepositories(this.remoteArtifactRepositories);
        return buildingRequest;
    }
}

