/*
 * Decompiled with CFR 0.152.
 */
package test.de.iip_ecosphere.platform.tools.maven.dependencies;

import de.iip_ecosphere.platform.tools.maven.dependencies.CleaningUnpackMojo;
import java.io.File;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.logging.Log;
import org.junit.Assert;
import org.junit.Test;

public class CleaningUnpackMojoTest {
    private static final Log LOG = new Log(){

        public void warn(CharSequence content, Throwable error) {
            System.out.println(content);
        }

        public void warn(Throwable error) {
            System.out.println(error.getMessage());
        }

        public void warn(CharSequence content) {
            System.out.println(content);
        }

        public boolean isWarnEnabled() {
            return true;
        }

        public boolean isInfoEnabled() {
            return true;
        }

        public boolean isErrorEnabled() {
            return true;
        }

        public boolean isDebugEnabled() {
            return true;
        }

        public void info(CharSequence content, Throwable error) {
            System.out.println(content);
        }

        public void info(Throwable error) {
            System.out.println(error.getMessage());
        }

        public void info(CharSequence content) {
            System.out.println(content);
        }

        public void error(CharSequence content, Throwable error) {
            System.out.println(content);
        }

        public void error(Throwable error) {
            System.out.println(error.getMessage());
        }

        public void error(CharSequence content) {
            System.out.println(content);
        }

        public void debug(CharSequence content, Throwable error) {
            System.out.println(content);
        }

        public void debug(Throwable error) {
            System.out.println(error.getMessage());
        }

        public void debug(CharSequence content) {
            System.out.println(content);
        }
    };

    @Test
    public void testInitiallyAllowedString() {
        Set allowed = CleaningUnpackMojo.getInitiallyAllowed((String)"test.ivml;a*.ivml:b*.*;apps/App*.*;types\\Type*.*", null, (Log)LOG);
        CleaningUnpackMojoTest.doAssert(allowed);
    }

    @Test
    public void testInitiallyAllowedFile() {
        Set allowed = CleaningUnpackMojo.getInitiallyAllowed(null, (File)new File("src/test/resources/initiallyAllowed.txt"), (Log)LOG);
        CleaningUnpackMojoTest.doAssert(allowed);
    }

    @Test
    public void testInitiallyAllowedFileMixed() {
        Set allowed = CleaningUnpackMojo.getInitiallyAllowed((String)"test.ivml;cde.fgh", (File)new File("src/test/resources/initiallyAllowed.txt"), (Log)LOG);
        CleaningUnpackMojoTest.doAssert(allowed);
    }

    private static void doAssert(Set<String> allowed) {
        Assert.assertTrue((boolean)allowed.contains(FilenameUtils.normalize((String)"test.ivml")));
        Assert.assertTrue((boolean)allowed.contains(FilenameUtils.normalize((String)"a*.ivml")));
        Assert.assertTrue((boolean)allowed.contains(FilenameUtils.normalize((String)"b*.*")));
        Assert.assertTrue((boolean)allowed.contains(FilenameUtils.normalize((String)"apps/App*.*")));
        Assert.assertTrue((boolean)allowed.contains(FilenameUtils.normalize((String)"types/Type*.*")));
        Assert.assertTrue((boolean)CleaningUnpackMojo.matches((File)new File("test.ivml"), allowed));
        Assert.assertFalse((boolean)CleaningUnpackMojo.matches((File)new File("test.text"), allowed));
        Assert.assertTrue((boolean)CleaningUnpackMojo.matches((File)new File("aber.ivml"), allowed));
        Assert.assertFalse((boolean)CleaningUnpackMojo.matches((File)new File("aber.text"), allowed));
        Assert.assertTrue((boolean)CleaningUnpackMojo.matches((File)new File("boah.ivml"), allowed));
        Assert.assertTrue((boolean)CleaningUnpackMojo.matches((File)new File("boah.text"), allowed));
        Assert.assertFalse((boolean)CleaningUnpackMojo.matches((File)new File("AppOld.text"), allowed));
        Assert.assertTrue((boolean)CleaningUnpackMojo.matches((File)new File("apps/AppOld.text"), allowed));
        Assert.assertTrue((boolean)CleaningUnpackMojo.matches((File)new File("types/TypeNew.ivml"), allowed));
    }
}

