/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.tools.maven.dependencies;

import java.util.Arrays;
import org.apache.maven.plugin.logging.Log;

public class Layers {
    public static final String DEFAULT_UNPACK_MODE = "jars";
    private static final String[] LAYERS = new String[]{"support.boot", "support", "support.aas", "support.iip-aas", "transport", "connectors", "services.environment", "services", "deviceMgt", "ecsRuntime", "monitoring", "configuration.interface", "configuration", "platform"};

    public static String getExcludeArtifactIds(String artifactId, String excludeIds, boolean asTest, Log log) {
        String result = excludeIds;
        if (null == result || result.length() == 0) {
            int last = -1;
            for (int l = 0; l < LAYERS.length; ++l) {
                if (!artifactId.startsWith(LAYERS[l] + ".")) continue;
                last = l;
            }
            if (last >= 0) {
                result = String.join((CharSequence)", ", Arrays.copyOfRange(LAYERS, 0, last + 1));
            }
            result = Layers.append(result, "maven-python");
        }
        if (asTest) {
            result = Layers.append(result, "junit", "junit-jupiter-api", "junit-jupiter-engine", "junit-jupiter-params", "junit-platform-commons", "junit-platform-engine");
        }
        if (log != null && result != null && result.length() > 0) {
            log.info((CharSequence)("Using excludeArtifactIds: " + result));
        }
        return result;
    }

    private static String append(String text, String ... addition) {
        Object result = text;
        if (result == null) {
            result = "";
        }
        for (String a : addition) {
            if (((String)result).length() > 0) {
                result = (String)result + ", ";
            }
            result = (String)result + a;
        }
        return result;
    }
}

