/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.tools.maven.dependencies;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="split-classpath", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class SplitClasspathMojo
extends AbstractMojo {
    @Parameter(property="mdep.archiveFile", defaultValue="", required=true)
    private List<File> archiveFiles;
    @Parameter(property="mdep.skip", defaultValue="false", required=false)
    private boolean skip;
    @Parameter(required=false)
    private List<String> mainPatterns;
    @Parameter(required=false)
    private List<String> keepClasses;

    private boolean isMainFile(String name, boolean includeSpringLoader) {
        boolean found = false;
        for (String m : this.mainPatterns) {
            if (!name.contains(m)) continue;
            found = true;
            break;
        }
        if (includeSpringLoader && !found) {
            found = name.contains("spring-boot-loader-");
        }
        return found;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.skip) {
            if (this.mainPatterns == null) {
                this.mainPatterns = new ArrayList<String>();
            }
            if (this.mainPatterns.isEmpty()) {
                Collections.addAll(this.mainPatterns, "maven-python", "transport-", "support-", "support.boot-", "support.aas-", "support.iip-aas-", "connectors-", "services.environment-", "services.spring.loader-");
                Collections.addAll(this.mainPatterns, "commons-io", "commons-lang3", "jackson-", "joda-", "jsoniter");
            }
            for (File f : this.archiveFiles) {
                if (null == f) continue;
                this.processFile(f);
            }
            this.cleanup();
        } else {
            this.getLog().info((CharSequence)"Skipping.");
        }
    }

    private boolean isCompressed(File file) {
        boolean compressed = false;
        try {
            JarFile jf = new JarFile(file);
            Enumeration<JarEntry> enm = jf.entries();
            while (enm.hasMoreElements()) {
                JarEntry ent = enm.nextElement();
                if (!ent.getName().endsWith(".jar")) continue;
                compressed = ent.getMethod() == 8;
                break;
            }
            jf.close();
        }
        catch (IOException e) {
            this.getLog().warn((CharSequence)("While checking Jar file: " + e.getMessage() + " Assuming no compression."));
        }
        return compressed;
    }

    private void processFile(File file) throws MojoExecutionException {
        boolean compressed = this.isCompressed(file);
        this.getLog().info((CharSequence)("Using compression: " + compressed));
        try (FileSystem fs = FileSystems.newFileSystem(file.toPath(), Map.of("compressionMethod", compressed ? "DEFLATED" : "STORED"));){
            Path appPath = null;
            StringBuilder main = new StringBuilder();
            StringBuilder app = new StringBuilder();
            Path mainPath = fs.getPath("/classpath", new String[0]);
            if (Files.exists(mainPath, new LinkOption[0])) {
                this.getLog().info((CharSequence)("Processing " + String.valueOf(file) + " as classpath JAR archive"));
                appPath = fs.getPath("/classpath-app", new String[0]);
                List lines = IOUtils.readLines((InputStream)Files.newInputStream(mainPath, new OpenOption[0]), (Charset)Charset.defaultCharset());
                for (String line : lines) {
                    if (line.startsWith("#")) {
                        main.append(line);
                        main.append("\n");
                        app.append(line);
                        app.append("\n");
                        continue;
                    }
                    String sep = ":";
                    StringTokenizer tokenizer = new StringTokenizer(line, sep);
                    boolean firstMain = true;
                    boolean firstApp = true;
                    while (tokenizer.hasMoreTokens()) {
                        boolean sepBefore;
                        StringBuilder target;
                        String token = tokenizer.nextToken();
                        if (this.isMainFile(token, true)) {
                            target = main;
                            sepBefore = !firstMain;
                            firstMain = false;
                        } else {
                            target = app;
                            sepBefore = !firstApp;
                            firstApp = false;
                        }
                        if (sepBefore) {
                            target.append(sep);
                        }
                        target.append(token);
                    }
                    main.append("\n");
                    app.append("\n");
                }
            } else {
                mainPath = fs.getPath("/BOOT-INF/classpath.idx", new String[0]);
                if (Files.exists(mainPath, new LinkOption[0])) {
                    this.getLog().info((CharSequence)("Processing " + String.valueOf(file) + " as spring app JAR archive"));
                    appPath = fs.getPath("/BOOT-INF/classpath-app.idx", new String[0]);
                    Path libAppPath = fs.getPath("/BOOT-INF/lib-app", new String[0]);
                    if (!Files.isDirectory(libAppPath, new LinkOption[0])) {
                        Files.createDirectory(libAppPath, new FileAttribute[0]);
                    }
                    List lines = IOUtils.readLines((InputStream)Files.newInputStream(mainPath, new OpenOption[0]), (Charset)Charset.defaultCharset());
                    for (String line : lines) {
                        StringBuilder target;
                        if (this.isMainFile(line, false)) {
                            target = main;
                        } else {
                            target = app;
                            line = this.processSpringLine(fs, line);
                        }
                        target.append(line);
                        target.append("\n");
                    }
                    this.postProcessSpringJar(fs);
                }
            }
            if (null != appPath) {
                Files.writeString(mainPath, (CharSequence)main.toString(), new OpenOption[0]);
                Files.writeString(appPath, (CharSequence)app.toString(), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private void cleanup() {
        File[] main = new File("").listFiles(f -> f.getName().startsWith("zipfstmp") && f.getName().endsWith(".tmp"));
        if (null != main) {
            for (File f2 : main) {
                FileUtils.deleteQuietly((File)f2);
            }
        }
    }

    private String processSpringLine(FileSystem fs, String line) throws IOException {
        if (((String)line).startsWith("- \"") && ((String)line).endsWith("\"")) {
            String src = ((String)line).substring(3, ((String)line).length() - 1);
            String tgt = src.replace("BOOT-INF/lib/", "BOOT-INF/lib-app/");
            Path srcPath = fs.getPath(src, new String[0]);
            Path tgtPath = fs.getPath(tgt, new String[0]);
            Files.move(srcPath, tgtPath, StandardCopyOption.REPLACE_EXISTING);
            line = "- \"" + tgt + "\"";
        }
        return line;
    }

    private void postProcessSpringJar(FileSystem fs) throws IOException {
        Path srcPath = fs.getPath("BOOT-INF/classes/", new String[0]);
        Path tgtPath = fs.getPath("BOOT-INF/classes-app/", new String[0]);
        Predicate<Path> filter = null;
        if (null != this.keepClasses && this.keepClasses.size() > 0) {
            filter = p -> {
                String path = p.toString();
                return !this.keepClasses.stream().anyMatch(k -> path.contains((CharSequence)k));
            };
        }
        this.moveAll(srcPath, tgtPath, true, filter);
    }

    public void moveAll(Path sourcePath, Path destPath, boolean keepSourcePath, Predicate<Path> filter) throws IOException {
        boolean initialNoFilter;
        boolean bl = initialNoFilter = filter == null;
        if (initialNoFilter) {
            filter = p -> true;
        }
        if (!Files.exists(destPath, new LinkOption[0])) {
            Files.createDirectories(destPath, new FileAttribute[0]);
        }
        Files.walk(sourcePath, new FileVisitOption[0]).filter(filter).forEach(source -> {
            try {
                Path destination;
                Path destParent = destination = destPath.resolve(sourcePath.relativize((Path)source));
                if (Files.isRegularFile(source, new LinkOption[0])) {
                    destParent = destination.getParent();
                }
                if (Files.notExists(destParent, new LinkOption[0])) {
                    Files.createDirectories(destParent, new FileAttribute[0]);
                }
                if (Files.isRegularFile(source, new LinkOption[0])) {
                    Files.move(source, destination, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("In Jar: Failed to move " + String.valueOf(source) + ": " + e.getClass().getSimpleName() + " " + e.getMessage()));
            }
        });
        try {
            Files.walk(sourcePath, new FileVisitOption[0]).filter(filter).sorted(Comparator.reverseOrder()).forEach(path -> {
                block3: {
                    try {
                        if (!keepSourcePath || keepSourcePath && !path.equals(sourcePath)) {
                            Files.delete(path);
                        }
                    }
                    catch (IOException e) {
                        if (!initialNoFilter) break block3;
                        this.getLog().error((CharSequence)("In Jar: Failed to delete : " + e.getClass().getSimpleName() + " " + e.getMessage()));
                    }
                }
            });
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("In Jar: Failed to delete source directory: " + e.getMessage()));
        }
    }
}

