/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.tools.maven.dependencies;

import de.iip_ecosphere.platform.tools.maven.dependencies.Resolver;
import de.iip_ecosphere.platform.tools.maven.python.FilesetUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.model.fileset.FileSet;

@Mojo(name="assemble-plugin", inheritByDefault=false, requiresDependencyResolution=ResolutionScope.TEST, defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class AssemblePluginMojo
extends AbstractMojo {
    @Parameter(property="mdep.addTestArtifact", defaultValue="false")
    private boolean addTestArtifact;
    @Parameter(property="mdep.unpackMode", defaultValue="JARS")
    private Resolver.UnpackMode unpackMode;
    @Parameter(required=false)
    private boolean asTest;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(required=false)
    private FileSet furtherFiles;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    private File targetDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String namePrefix = this.project.getArtifactId() + "-" + this.project.getVersion();
        File outputFile = new File(this.targetDirectory, namePrefix + "-plugin" + (this.asTest ? "-test" : "") + ".zip");
        File jarsDir = new File(this.targetDirectory, "jars" + (this.asTest ? "-test" : ""));
        this.getLog().info((CharSequence)("Building " + String.valueOf(outputFile)));
        FileUtils.deleteQuietly((File)outputFile);
        try (ZipOutputStream out = new ZipOutputStream(new FileOutputStream(outputFile));){
            File resolv;
            File targetClasses = new File(this.targetDirectory, "classes");
            if (!this.addClasspathFiles(out, jarsDir)) {
                this.addClasspathFiles(out, targetClasses);
            }
            if ((resolv = new File(targetClasses, "resolved")).exists()) {
                this.addFile(out, resolv, "", false);
            }
            if (Resolver.include(this.unpackMode, namePrefix)) {
                this.addFile(out, this.prependGroup(new File(this.targetDirectory, namePrefix + ".jar")), "target/", false);
                if (this.addTestArtifact || this.asTest) {
                    this.addFile(out, this.prependGroup(new File(this.targetDirectory, namePrefix + "-tests.jar")), "target/", false);
                }
            }
            HashSet excluded = new HashSet();
            FilesetUtils.determineFiles((FileSet)this.furtherFiles, (boolean)false, f -> excluded.add(f));
            this.getLog().info((CharSequence)("Adding dependencies jars from " + String.valueOf(jarsDir)));
            File[] jars = jarsDir.listFiles();
            if (null != jars) {
                for (File f2 : jars) {
                    if (!f2.getName().endsWith(".jar") || excluded.contains(f2) || !Resolver.include(this.unpackMode, f2)) continue;
                    this.addFile(out, f2, "target/jars/", false);
                }
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("While packaging '" + String.valueOf(outputFile) + "': " + e.getMessage()));
        }
        this.projectHelper.attachArtifact(this.project, "zip", "plugin" + (this.asTest ? "-test" : ""), outputFile);
    }

    private File prependGroup(File file) {
        File result = new File(file.getParent(), this.project.getGroupId() + "." + file.getName());
        try {
            Files.copy(file.toPath(), result.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)("While prepending groupId: " + e.getClass().getSimpleName() + " " + e.getMessage()));
        }
        return result;
    }

    private boolean addClasspathFiles(ZipOutputStream out, File dir) {
        boolean done = false;
        File cpFile = new File(dir, "classpath");
        if (cpFile.exists()) {
            this.addFile(out, cpFile, "", false);
            done = true;
            File[] jars = dir.listFiles();
            if (null != jars) {
                for (File f : jars) {
                    if (!f.getName().startsWith("classpath-")) continue;
                    this.addFile(out, f, "", false);
                }
            }
        }
        return done;
    }

    private void addFile(ZipOutputStream out, File file, String prefix, boolean deleteAfter) {
        if (file.exists()) {
            try (FileInputStream fis = new FileInputStream(file);){
                String name = prefix + file.getName();
                ZipEntry entry = new ZipEntry(name);
                entry.setTime(file.lastModified());
                out.putNextEntry(entry);
                IOUtils.copy((InputStream)fis, (OutputStream)out);
                this.getLog().debug((CharSequence)(" - Added " + String.valueOf(file) + " as " + name));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)("Cannot open " + String.valueOf(file) + ": " + e.getMessage()));
            }
        }
        if (deleteAfter) {
            FileUtils.deleteQuietly((File)file);
        }
    }
}

