/*
 * Decompiled with CFR 0.152.
 */
package de.iip_ecosphere.platform.deviceMgt.basicReg;

import de.iip_ecosphere.platform.deviceMgt.DeviceDescriptor;
import de.iip_ecosphere.platform.deviceMgt.basicReg.BasicRegistryDeviceDescriptor;
import de.iip_ecosphere.platform.deviceMgt.registry.DeviceRegistrationResponse;
import de.iip_ecosphere.platform.deviceMgt.registry.DeviceRegistry;
import de.iip_ecosphere.platform.support.json.Json;
import de.iip_ecosphere.platform.support.json.JsonObject;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;

public class BasicDeviceRegistry
implements DeviceRegistry {
    public static final int PAGE_SIZE = 10;
    public static final String DEVICE_TYPE = "ecs";
    private Map<String, BasicRegistryDeviceDescriptor> devices = Collections.synchronizedMap(new HashMap());

    public Set<String> getIds() {
        return this.devices.keySet();
    }

    public Set<String> getManagedIds() {
        return this.devices.keySet();
    }

    public Collection<? extends DeviceDescriptor> getDevices() {
        return this.devices.values();
    }

    public BasicRegistryDeviceDescriptor getDevice(String id) {
        return null == id ? null : this.devices.get(id);
    }

    public BasicRegistryDeviceDescriptor getDeviceByManagedId(String id) {
        return null == id ? null : this.devices.get(id);
    }

    public DeviceRegistrationResponse addDevice(String id, String ip) {
        DeviceRegistrationResponse result = new DeviceRegistrationResponse();
        if (id == null || id.isEmpty() || ip == null || ip.isEmpty()) {
            result.setSuccessful(false);
            result.setMessage("No id given");
            return result;
        }
        this.devices.put(id, new BasicRegistryDeviceDescriptor(id, ip));
        result.setSuccessful(true);
        return result;
    }

    public void removeDevice(String id) {
        if (id == null || id.isEmpty()) {
            return;
        }
        this.devices.remove(id);
    }

    public void imAlive(String id) throws ExecutionException {
        this.sendTelemetry(id, "{\"active\": true}");
    }

    public void sendTelemetry(String id, String telemetryData) throws ExecutionException {
        try {
            JsonObject telemetry = Json.createObject((String)telemetryData);
            BasicRegistryDeviceDescriptor desc = this.getDevice(id);
            if (null != desc) {
                desc.saveEntityTelemetry(telemetry);
            }
        }
        catch (IOException e) {
            throw new ExecutionException("TelemetryData is not json: ", e);
        }
    }
}

