/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thingsboard.server.common.data.TbResourceInfo;
import org.thingsboard.server.common.data.id.TbResourceId;
import org.thingsboard.server.common.data.validation.NoXss;

public class TbResource
extends TbResourceInfo {
    private static final Logger log = LoggerFactory.getLogger(TbResource.class);
    private static final long serialVersionUID = 7379609705527272306L;
    @NoXss
    private String fileName;
    private String data;

    public TbResource() {
    }

    public TbResource(TbResourceId id) {
        super(id);
    }

    public TbResource(TbResourceInfo resourceInfo) {
        super(resourceInfo);
    }

    public TbResource(TbResource resource) {
        super(resource);
        this.data = resource.getData();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Resource [tenantId=");
        builder.append(this.getTenantId());
        builder.append(", id=");
        builder.append(this.getUuidId());
        builder.append(", createdTime=");
        builder.append(this.createdTime);
        builder.append(", title=");
        builder.append(this.getTitle());
        builder.append(", resourceType=");
        builder.append((Object)this.getResourceType());
        builder.append(", resourceKey=");
        builder.append(this.getResourceKey());
        builder.append(", fileName=");
        builder.append(this.fileName);
        builder.append(", data=");
        builder.append(this.data);
        builder.append("]");
        return builder.toString();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getData() {
        return this.data;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setData(String data) {
        this.data = data;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TbResource)) {
            return false;
        }
        TbResource other = (TbResource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TbResource;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }
}

