/*
 * Decompiled with CFR 0.152.
 */
package org.thingsboard.server.common.data.oauth2;

import java.util.List;
import org.thingsboard.server.common.data.HasName;
import org.thingsboard.server.common.data.SearchTextBasedWithAdditionalInfo;
import org.thingsboard.server.common.data.id.OAuth2ClientRegistrationTemplateId;
import org.thingsboard.server.common.data.oauth2.OAuth2MapperConfig;

public class OAuth2ClientRegistrationTemplate
extends SearchTextBasedWithAdditionalInfo<OAuth2ClientRegistrationTemplateId>
implements HasName {
    private String providerId;
    private OAuth2MapperConfig mapperConfig;
    private String authorizationUri;
    private String accessTokenUri;
    private List<String> scope;
    private String userInfoUri;
    private String userNameAttributeName;
    private String jwkSetUri;
    private String clientAuthenticationMethod;
    private String comment;
    private String loginButtonIcon;
    private String loginButtonLabel;
    private String helpLink;

    public OAuth2ClientRegistrationTemplate(OAuth2ClientRegistrationTemplate clientRegistrationTemplate) {
        super(clientRegistrationTemplate);
        this.providerId = clientRegistrationTemplate.providerId;
        this.mapperConfig = clientRegistrationTemplate.mapperConfig;
        this.authorizationUri = clientRegistrationTemplate.authorizationUri;
        this.accessTokenUri = clientRegistrationTemplate.accessTokenUri;
        this.scope = clientRegistrationTemplate.scope;
        this.userInfoUri = clientRegistrationTemplate.userInfoUri;
        this.userNameAttributeName = clientRegistrationTemplate.userNameAttributeName;
        this.jwkSetUri = clientRegistrationTemplate.jwkSetUri;
        this.clientAuthenticationMethod = clientRegistrationTemplate.clientAuthenticationMethod;
        this.comment = clientRegistrationTemplate.comment;
        this.loginButtonIcon = clientRegistrationTemplate.loginButtonIcon;
        this.loginButtonLabel = clientRegistrationTemplate.loginButtonLabel;
        this.helpLink = clientRegistrationTemplate.helpLink;
    }

    @Override
    public String getName() {
        return this.providerId;
    }

    @Override
    public String getSearchText() {
        return this.getName();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuth2ClientRegistrationTemplate)) {
            return false;
        }
        OAuth2ClientRegistrationTemplate other = (OAuth2ClientRegistrationTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$providerId = this.getProviderId();
        String other$providerId = other.getProviderId();
        if (this$providerId == null ? other$providerId != null : !this$providerId.equals(other$providerId)) {
            return false;
        }
        OAuth2MapperConfig this$mapperConfig = this.getMapperConfig();
        OAuth2MapperConfig other$mapperConfig = other.getMapperConfig();
        if (this$mapperConfig == null ? other$mapperConfig != null : !((Object)this$mapperConfig).equals(other$mapperConfig)) {
            return false;
        }
        String this$authorizationUri = this.getAuthorizationUri();
        String other$authorizationUri = other.getAuthorizationUri();
        if (this$authorizationUri == null ? other$authorizationUri != null : !this$authorizationUri.equals(other$authorizationUri)) {
            return false;
        }
        String this$accessTokenUri = this.getAccessTokenUri();
        String other$accessTokenUri = other.getAccessTokenUri();
        if (this$accessTokenUri == null ? other$accessTokenUri != null : !this$accessTokenUri.equals(other$accessTokenUri)) {
            return false;
        }
        List<String> this$scope = this.getScope();
        List<String> other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !((Object)this$scope).equals(other$scope)) {
            return false;
        }
        String this$userInfoUri = this.getUserInfoUri();
        String other$userInfoUri = other.getUserInfoUri();
        if (this$userInfoUri == null ? other$userInfoUri != null : !this$userInfoUri.equals(other$userInfoUri)) {
            return false;
        }
        String this$userNameAttributeName = this.getUserNameAttributeName();
        String other$userNameAttributeName = other.getUserNameAttributeName();
        if (this$userNameAttributeName == null ? other$userNameAttributeName != null : !this$userNameAttributeName.equals(other$userNameAttributeName)) {
            return false;
        }
        String this$jwkSetUri = this.getJwkSetUri();
        String other$jwkSetUri = other.getJwkSetUri();
        if (this$jwkSetUri == null ? other$jwkSetUri != null : !this$jwkSetUri.equals(other$jwkSetUri)) {
            return false;
        }
        String this$clientAuthenticationMethod = this.getClientAuthenticationMethod();
        String other$clientAuthenticationMethod = other.getClientAuthenticationMethod();
        if (this$clientAuthenticationMethod == null ? other$clientAuthenticationMethod != null : !this$clientAuthenticationMethod.equals(other$clientAuthenticationMethod)) {
            return false;
        }
        String this$comment = this.getComment();
        String other$comment = other.getComment();
        if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
            return false;
        }
        String this$loginButtonIcon = this.getLoginButtonIcon();
        String other$loginButtonIcon = other.getLoginButtonIcon();
        if (this$loginButtonIcon == null ? other$loginButtonIcon != null : !this$loginButtonIcon.equals(other$loginButtonIcon)) {
            return false;
        }
        String this$loginButtonLabel = this.getLoginButtonLabel();
        String other$loginButtonLabel = other.getLoginButtonLabel();
        if (this$loginButtonLabel == null ? other$loginButtonLabel != null : !this$loginButtonLabel.equals(other$loginButtonLabel)) {
            return false;
        }
        String this$helpLink = this.getHelpLink();
        String other$helpLink = other.getHelpLink();
        return !(this$helpLink == null ? other$helpLink != null : !this$helpLink.equals(other$helpLink));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OAuth2ClientRegistrationTemplate;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $providerId = this.getProviderId();
        result = result * 59 + ($providerId == null ? 43 : $providerId.hashCode());
        OAuth2MapperConfig $mapperConfig = this.getMapperConfig();
        result = result * 59 + ($mapperConfig == null ? 43 : ((Object)$mapperConfig).hashCode());
        String $authorizationUri = this.getAuthorizationUri();
        result = result * 59 + ($authorizationUri == null ? 43 : $authorizationUri.hashCode());
        String $accessTokenUri = this.getAccessTokenUri();
        result = result * 59 + ($accessTokenUri == null ? 43 : $accessTokenUri.hashCode());
        List<String> $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : ((Object)$scope).hashCode());
        String $userInfoUri = this.getUserInfoUri();
        result = result * 59 + ($userInfoUri == null ? 43 : $userInfoUri.hashCode());
        String $userNameAttributeName = this.getUserNameAttributeName();
        result = result * 59 + ($userNameAttributeName == null ? 43 : $userNameAttributeName.hashCode());
        String $jwkSetUri = this.getJwkSetUri();
        result = result * 59 + ($jwkSetUri == null ? 43 : $jwkSetUri.hashCode());
        String $clientAuthenticationMethod = this.getClientAuthenticationMethod();
        result = result * 59 + ($clientAuthenticationMethod == null ? 43 : $clientAuthenticationMethod.hashCode());
        String $comment = this.getComment();
        result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
        String $loginButtonIcon = this.getLoginButtonIcon();
        result = result * 59 + ($loginButtonIcon == null ? 43 : $loginButtonIcon.hashCode());
        String $loginButtonLabel = this.getLoginButtonLabel();
        result = result * 59 + ($loginButtonLabel == null ? 43 : $loginButtonLabel.hashCode());
        String $helpLink = this.getHelpLink();
        result = result * 59 + ($helpLink == null ? 43 : $helpLink.hashCode());
        return result;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public OAuth2MapperConfig getMapperConfig() {
        return this.mapperConfig;
    }

    public String getAuthorizationUri() {
        return this.authorizationUri;
    }

    public String getAccessTokenUri() {
        return this.accessTokenUri;
    }

    public List<String> getScope() {
        return this.scope;
    }

    public String getUserInfoUri() {
        return this.userInfoUri;
    }

    public String getUserNameAttributeName() {
        return this.userNameAttributeName;
    }

    public String getJwkSetUri() {
        return this.jwkSetUri;
    }

    public String getClientAuthenticationMethod() {
        return this.clientAuthenticationMethod;
    }

    public String getComment() {
        return this.comment;
    }

    public String getLoginButtonIcon() {
        return this.loginButtonIcon;
    }

    public String getLoginButtonLabel() {
        return this.loginButtonLabel;
    }

    public String getHelpLink() {
        return this.helpLink;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public void setMapperConfig(OAuth2MapperConfig mapperConfig) {
        this.mapperConfig = mapperConfig;
    }

    public void setAuthorizationUri(String authorizationUri) {
        this.authorizationUri = authorizationUri;
    }

    public void setAccessTokenUri(String accessTokenUri) {
        this.accessTokenUri = accessTokenUri;
    }

    public void setScope(List<String> scope) {
        this.scope = scope;
    }

    public void setUserInfoUri(String userInfoUri) {
        this.userInfoUri = userInfoUri;
    }

    public void setUserNameAttributeName(String userNameAttributeName) {
        this.userNameAttributeName = userNameAttributeName;
    }

    public void setJwkSetUri(String jwkSetUri) {
        this.jwkSetUri = jwkSetUri;
    }

    public void setClientAuthenticationMethod(String clientAuthenticationMethod) {
        this.clientAuthenticationMethod = clientAuthenticationMethod;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setLoginButtonIcon(String loginButtonIcon) {
        this.loginButtonIcon = loginButtonIcon;
    }

    public void setLoginButtonLabel(String loginButtonLabel) {
        this.loginButtonLabel = loginButtonLabel;
    }

    public void setHelpLink(String helpLink) {
        this.helpLink = helpLink;
    }

    @Override
    public String toString() {
        return "OAuth2ClientRegistrationTemplate(providerId=" + this.getProviderId() + ", mapperConfig=" + this.getMapperConfig() + ", authorizationUri=" + this.getAuthorizationUri() + ", accessTokenUri=" + this.getAccessTokenUri() + ", scope=" + this.getScope() + ", userInfoUri=" + this.getUserInfoUri() + ", userNameAttributeName=" + this.getUserNameAttributeName() + ", jwkSetUri=" + this.getJwkSetUri() + ", clientAuthenticationMethod=" + this.getClientAuthenticationMethod() + ", comment=" + this.getComment() + ", loginButtonIcon=" + this.getLoginButtonIcon() + ", loginButtonLabel=" + this.getLoginButtonLabel() + ", helpLink=" + this.getHelpLink() + ")";
    }

    public OAuth2ClientRegistrationTemplate() {
    }
}

